/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.ETriState;
import com.helger.phase4.crypto.ECryptoAlgorithmCrypt;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.model.pmode.AbstractPModeMicroTypeConverter;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import com.helger.phase4.wss.EWSSVersion;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.util.MicroHelper;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PModeLegSecurityMicroTypeConverter
extends AbstractPModeMicroTypeConverter<PModeLegSecurity> {
    private static final IMicroQName ATTR_WSS_VERSION = new MicroQName("WSSVersion");
    private static final String ELEMENT_X509_SIGN_ELEMENT = "X509SignElement";
    private static final String ELEMENT_X509_SIGN_ATTACHMENT = "X509SignAttachment";
    private static final String ELEMENT_X509_SIGNATURE_CERTIFICATE = "X509SignatureCertificate";
    private static final IMicroQName ATTR_X509_SIGNATURE_HASH_FUNCTION = new MicroQName("X509SignatureHashFunction");
    private static final IMicroQName ATTR_X509_SIGNATURE_ALGORITHM = new MicroQName("X509SignatureAlgorithm");
    private static final String ELEMENT_X509_ENCRYPTION_ENCRYPT_ELEMENT = "X509EncryptionEncryptElement";
    private static final String ELEMENT_X509_ENCRYPTION_ENCRYPT_ATTACHMENT = "X509EncryptionEncryptAttachment";
    private static final String ELEMENT_X509_ENCRYPTION_CERTIFICATE = "X509EncryptionCertificate";
    private static final IMicroQName ATTR_X509_ENCRYPTION_ALGORITHM = new MicroQName("X509EncryptionAlgorithm");
    private static final IMicroQName ATTR_X509_ENCRYPTION_MINIMUM_STRENGTH = new MicroQName("X509EncryptionMinimumStrength");
    private static final IMicroQName ATTR_USERNAME_TOKEN_USERNAME = new MicroQName("UsernameTokenUsername");
    private static final IMicroQName ATTR_USERNAME_TOKEN_PASSWORD = new MicroQName("UsernameTokenPassword");
    private static final IMicroQName ATTR_USERNAME_TOKEN_DIGEST = new MicroQName("UsernameTokenDigest");
    private static final IMicroQName ATTR_USERNAME_TOKEN_NONCE = new MicroQName("UsernameTokenNonce");
    private static final IMicroQName ATTR_USERNAME_TOKEN_CREATED = new MicroQName("UsernameTokenCreated");
    private static final IMicroQName ATTR_PMODE_AUTHORIZE = new MicroQName("PModeAuthorize");
    private static final IMicroQName ATTR_SEND_RECEIPT = new MicroQName("SendReceipt");
    private static final IMicroQName ATTR_SEND_RECEIPT_REPLY_PATTERN = new MicroQName("SendReceiptReplyPattern");
    private static final IMicroQName ATTR_SEND_RECEIPT_NON_REPUDIATION = new MicroQName("SendReceiptNonRepudiation");

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull PModeLegSecurity pModeLegSecurity, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_WSS_VERSION, pModeLegSecurity.getWSSVersionAsString());
        for (String string3 : pModeLegSecurity.getAllX509SignElements()) {
            microElement.appendElement(string, ELEMENT_X509_SIGN_ELEMENT).appendText((CharSequence)string3);
        }
        for (String string3 : pModeLegSecurity.getAllX509SignAttachments()) {
            microElement.appendElement(string, ELEMENT_X509_SIGN_ATTACHMENT).appendText((CharSequence)string3);
        }
        if (pModeLegSecurity.hasX509SignatureCertificate()) {
            microElement.appendElement(string, ELEMENT_X509_SIGNATURE_CERTIFICATE).appendText((CharSequence)pModeLegSecurity.getX509SignatureCertificate());
        }
        microElement.setAttribute(ATTR_X509_SIGNATURE_HASH_FUNCTION, pModeLegSecurity.getX509SignatureHashFunctionID());
        microElement.setAttribute(ATTR_X509_SIGNATURE_ALGORITHM, pModeLegSecurity.getX509SignatureAlgorithmID());
        for (String string3 : pModeLegSecurity.getAllX509EncryptionEncryptElements()) {
            microElement.appendElement(string, ELEMENT_X509_ENCRYPTION_ENCRYPT_ELEMENT).appendText((CharSequence)string3);
        }
        for (String string3 : pModeLegSecurity.getAllX509EncryptionEncryptAttachments()) {
            microElement.appendElement(string, ELEMENT_X509_ENCRYPTION_ENCRYPT_ATTACHMENT).appendText((CharSequence)string3);
        }
        if (pModeLegSecurity.hasX509EncryptionCertificate()) {
            microElement.appendElement(string, ELEMENT_X509_ENCRYPTION_CERTIFICATE).appendText((CharSequence)pModeLegSecurity.getX509EncryptionCertificate());
        }
        microElement.setAttribute(ATTR_X509_ENCRYPTION_ALGORITHM, pModeLegSecurity.getX509EncryptionAlgorithmID());
        if (pModeLegSecurity.hasX509EncryptionMinimumStrength()) {
            microElement.setAttribute(ATTR_X509_ENCRYPTION_MINIMUM_STRENGTH, pModeLegSecurity.getX509EncryptionMinimumStrength().intValue());
        }
        microElement.setAttribute(ATTR_USERNAME_TOKEN_USERNAME, pModeLegSecurity.getUsernameTokenUsername());
        microElement.setAttribute(ATTR_USERNAME_TOKEN_PASSWORD, pModeLegSecurity.getUsernameTokenPassword());
        if (pModeLegSecurity.isUsernameTokenDigestDefined()) {
            microElement.setAttribute(ATTR_USERNAME_TOKEN_DIGEST, pModeLegSecurity.isUsernameTokenDigest());
        }
        if (pModeLegSecurity.isUsernameTokenNonceDefined()) {
            microElement.setAttribute(ATTR_USERNAME_TOKEN_NONCE, pModeLegSecurity.isUsernameTokenNonce());
        }
        if (pModeLegSecurity.isUsernameTokenCreatedDefined()) {
            microElement.setAttribute(ATTR_USERNAME_TOKEN_CREATED, pModeLegSecurity.isUsernameTokenCreated());
        }
        if (pModeLegSecurity.isPModeAuthorizeDefined()) {
            microElement.setAttribute(ATTR_PMODE_AUTHORIZE, pModeLegSecurity.isPModeAuthorize());
        }
        if (pModeLegSecurity.isSendReceiptDefined()) {
            microElement.setAttribute(ATTR_SEND_RECEIPT, pModeLegSecurity.isSendReceipt());
        }
        microElement.setAttribute(ATTR_SEND_RECEIPT_REPLY_PATTERN, pModeLegSecurity.getSendReceiptReplyPatternID());
        if (pModeLegSecurity.isSendReceiptNonRepudiationDefined()) {
            microElement.setAttribute(ATTR_SEND_RECEIPT_NON_REPUDIATION, pModeLegSecurity.isSendReceiptNonRepudiation());
        }
        return microElement;
    }

    @Nonnull
    public PModeLegSecurity convertToNative(@Nonnull IMicroElement iMicroElement) {
        Object object5;
        Object object22;
        Object object32;
        Object object42;
        String string = iMicroElement.getAttributeValue(ATTR_WSS_VERSION);
        EWSSVersion eWSSVersion = EWSSVersion.getFromVersionOrNull(string);
        if (eWSSVersion == null && string != null) {
            throw new IllegalStateException("Invalid WSS version '" + string + "'");
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object42 : iMicroElement.getAllChildElements(ELEMENT_X509_SIGN_ELEMENT)) {
            commonsArrayList.add((Object)object42.getTextContentTrimmed());
        }
        Iterator iterator = new CommonsArrayList();
        for (Object object32 : iMicroElement.getAllChildElements(ELEMENT_X509_SIGN_ATTACHMENT)) {
            iterator.add(object32.getTextContentTrimmed());
        }
        object42 = MicroHelper.getChildTextContentTrimmed((IMicroElement)iMicroElement, (String)ELEMENT_X509_SIGNATURE_CERTIFICATE);
        object32 = iMicroElement.getAttributeValue(ATTR_X509_SIGNATURE_HASH_FUNCTION);
        ECryptoAlgorithmSignDigest eCryptoAlgorithmSignDigest = ECryptoAlgorithmSignDigest.getFromIDOrNull((String)object32);
        if (eCryptoAlgorithmSignDigest == null && object32 != null) {
            throw new IllegalStateException("Invalid signature hash function '" + (String)object32 + "'");
        }
        String string2 = iMicroElement.getAttributeValue(ATTR_X509_SIGNATURE_ALGORITHM);
        ECryptoAlgorithmSign eCryptoAlgorithmSign = ECryptoAlgorithmSign.getFromIDOrNull(string2);
        if (eCryptoAlgorithmSign == null && string2 != null) {
            throw new IllegalStateException("Invalid signature algorithm '" + string2 + "'");
        }
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        for (Object object22 : iMicroElement.getAllChildElements(ELEMENT_X509_ENCRYPTION_ENCRYPT_ELEMENT)) {
            commonsArrayList2.add((Object)object22.getTextContentTrimmed());
        }
        Iterator iterator2 = new CommonsArrayList();
        for (Object object5 : iMicroElement.getAllChildElements(ELEMENT_X509_ENCRYPTION_ENCRYPT_ATTACHMENT)) {
            iterator2.add(object5.getTextContentTrimmed());
        }
        object22 = MicroHelper.getChildTextContentTrimmed((IMicroElement)iMicroElement, (String)ELEMENT_X509_ENCRYPTION_CERTIFICATE);
        object5 = iMicroElement.getAttributeValue(ATTR_X509_ENCRYPTION_ALGORITHM);
        ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt = ECryptoAlgorithmCrypt.getFromIDOrNull((String)object5);
        if (eCryptoAlgorithmCrypt == null && object5 != null) {
            throw new IllegalStateException("Invalid encrypt algorithm '" + (String)object5 + "'");
        }
        Integer n = (Integer)iMicroElement.getAttributeValueWithConversion(ATTR_X509_ENCRYPTION_MINIMUM_STRENGTH, Integer.class);
        String string3 = iMicroElement.getAttributeValue(ATTR_USERNAME_TOKEN_USERNAME);
        String string4 = iMicroElement.getAttributeValue(ATTR_USERNAME_TOKEN_PASSWORD);
        ETriState eTriState = PModeLegSecurityMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_USERNAME_TOKEN_DIGEST), false);
        ETriState eTriState2 = PModeLegSecurityMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_USERNAME_TOKEN_NONCE), false);
        ETriState eTriState3 = PModeLegSecurityMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_USERNAME_TOKEN_CREATED), false);
        ETriState eTriState4 = PModeLegSecurityMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_PMODE_AUTHORIZE), false);
        ETriState eTriState5 = PModeLegSecurityMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_SEND_RECEIPT), false);
        String string5 = iMicroElement.getAttributeValue(ATTR_SEND_RECEIPT_REPLY_PATTERN);
        EPModeSendReceiptReplyPattern ePModeSendReceiptReplyPattern = EPModeSendReceiptReplyPattern.getFromIDOrNull(string5);
        if (ePModeSendReceiptReplyPattern == null && string5 != null) {
            throw new IllegalStateException("Invalid SendReceipt ReplyPattern version '" + string5 + "'");
        }
        ETriState eTriState6 = PModeLegSecurityMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_SEND_RECEIPT_NON_REPUDIATION), false);
        return new PModeLegSecurity(eWSSVersion, (ICommonsList<String>)commonsArrayList, (ICommonsList<String>)iterator, (String)object42, eCryptoAlgorithmSignDigest, eCryptoAlgorithmSign, (ICommonsList<String>)commonsArrayList2, (ICommonsList<String>)iterator2, (String)object22, eCryptoAlgorithmCrypt, n, string3, string4, eTriState, eTriState2, eTriState3, eTriState4, eTriState5, ePModeSendReceiptReplyPattern, eTriState6);
    }
}

