/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.state.EMandatory;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.phase4.model.pmode.leg.PModeProperty;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PModePropertyJsonConverter {
    private static final String NAME = "Name";
    private static final String DESCRIPTION = "Description";
    private static final String DATA_TYPE = "DataType";
    private static final String MANDATORY = "Mandatory";

    private PModePropertyJsonConverter() {
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull PModeProperty pModeProperty) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(NAME, (Object)pModeProperty.getName());
        if (pModeProperty.hasDescription()) {
            jsonObject.add(DESCRIPTION, (Object)pModeProperty.getDescription());
        }
        jsonObject.add(DATA_TYPE, (Object)pModeProperty.getDataType());
        jsonObject.add(MANDATORY, pModeProperty.isMandatory());
        return jsonObject;
    }

    @Nonnull
    public static PModeProperty convertToNative(@Nonnull IJsonObject iJsonObject) {
        String string = iJsonObject.getAsString((Object)NAME);
        String string2 = iJsonObject.getAsString((Object)DESCRIPTION);
        String string3 = iJsonObject.getAsString((Object)DATA_TYPE);
        EMandatory eMandatory = EMandatory.valueOf((boolean)iJsonObject.getAsBoolean((Object)MANDATORY, false));
        return new PModeProperty(string, string2, string3, eMandatory);
    }
}

