/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.sender;

import com.helger.commons.string.StringHelper;
import com.helger.phase4.client.AS4ClientPullRequestMessage;
import com.helger.phase4.client.IAS4UserMessageConsumer;
import com.helger.phase4.sender.AS4BidirectionalClientHelper;
import com.helger.phase4.sender.AbstractAS4MessageBuilder;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.util.Phase4Exception;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractAS4PullRequestBuilder<IMPLTYPE extends AbstractAS4PullRequestBuilder<IMPLTYPE>>
extends AbstractAS4MessageBuilder<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAS4PullRequestBuilder.class);
    protected String m_sMPC;
    protected String m_sEndpointURL;
    protected IAS4UserMessageConsumer m_aUserMsgConsumer;

    protected AbstractAS4PullRequestBuilder() {
    }

    @Nonnull
    public final IMPLTYPE mpc(@Nullable String string) {
        this.m_sMPC = string;
        return (IMPLTYPE)((AbstractAS4PullRequestBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE endpointURL(@Nullable String string) {
        this.m_sEndpointURL = string;
        return (IMPLTYPE)((AbstractAS4PullRequestBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE userMsgConsumer(@Nullable IAS4UserMessageConsumer iAS4UserMessageConsumer) {
        this.m_aUserMsgConsumer = iAS4UserMessageConsumer;
        return (IMPLTYPE)((AbstractAS4PullRequestBuilder)this.thisAsT());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isEveryRequiredFieldSet() {
        if (!super.isEveryRequiredFieldSet()) {
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sMPC)) {
            LOGGER.warn("The field 'MPC' is not set");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sEndpointURL)) {
            LOGGER.warn("The field 'endpointURL' is not set");
            return false;
        }
        return true;
    }

    protected final void applyToPullRequest(@Nonnull AS4ClientPullRequestMessage aS4ClientPullRequestMessage) {
        if (this.m_aCustomHttpPoster != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using a custom IHttpPoster implementation: " + this.m_aCustomHttpPoster);
            }
            aS4ClientPullRequestMessage.setHttpPoster(this.m_aCustomHttpPoster);
        } else {
            aS4ClientPullRequestMessage.getHttpPoster().setHttpClientFactory(this.m_aHttpClientFactory);
            aS4ClientPullRequestMessage.getHttpPoster().setQuoteHttpHeaders(false);
        }
        aS4ClientPullRequestMessage.setSoapVersion(this.m_eSoapVersion);
        aS4ClientPullRequestMessage.setSendingDateTimeOrNow(this.m_aSendingDateTime);
        aS4ClientPullRequestMessage.setAS4CryptoFactory(this.m_aCryptoFactory);
        if (this.m_aHttpRetrySettings != null) {
            aS4ClientPullRequestMessage.httpRetrySettings().assignFrom(this.m_aHttpRetrySettings);
        }
        if (StringHelper.hasText((String)this.m_sMessageID)) {
            aS4ClientPullRequestMessage.setMessageID(this.m_sMessageID);
        }
        if (StringHelper.hasText((String)this.m_sRefToMessageID)) {
            aS4ClientPullRequestMessage.setRefToMessageID(this.m_sRefToMessageID);
        }
        aS4ClientPullRequestMessage.setMPC(this.m_sMPC);
    }

    @Override
    protected final void mainSendMessage() throws Phase4Exception {
        try (AS4ResourceHelper aS4ResourceHelper = new AS4ResourceHelper();){
            AS4ClientPullRequestMessage aS4ClientPullRequestMessage = new AS4ClientPullRequestMessage(aS4ResourceHelper);
            this.applyToPullRequest(aS4ClientPullRequestMessage);
            AS4BidirectionalClientHelper.sendAS4PullRequestAndReceiveAS4UserMessage(this.m_aCryptoFactory, this.pmodeResolver(), this.incomingAttachmentFactory(), this.incomingProfileSelector(), aS4ClientPullRequestMessage, this.m_aLocale, this.m_sEndpointURL, this.m_aBuildMessageCallback, this.m_aOutgoingDumper, this.m_aIncomingDumper, this.m_aRetryCallback, this.m_aResponseConsumer, this.m_aUserMsgConsumer);
        }
        catch (Phase4Exception phase4Exception) {
            throw phase4Exception;
        }
        catch (Exception exception) {
            throw new Phase4Exception("Wrapped Phase4Exception", exception);
        }
    }
}

