/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.sender;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.wrapper.Wrapper;
import com.helger.phase4.attachment.Phase4OutgoingAttachment;
import com.helger.phase4.client.AS4ClientUserMessage;
import com.helger.phase4.client.IAS4SignalMessageConsumer;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.model.MessageProperty;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.sender.AbstractAS4MessageBuilder;
import com.helger.phase4.util.Phase4Exception;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractAS4UserMessageBuilder<IMPLTYPE extends AbstractAS4UserMessageBuilder<IMPLTYPE>>
extends AbstractAS4MessageBuilder<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAS4UserMessageBuilder.class);
    protected IPMode m_aPMode;
    protected String m_sServiceType;
    protected String m_sService;
    protected String m_sAction;
    protected String m_sAgreementRef;
    protected String m_sPModeID;
    protected String m_sFromPartyIDType;
    protected String m_sFromPartyID;
    protected String m_sFromRole;
    protected String m_sToPartyIDType;
    protected String m_sToPartyID;
    protected String m_sToRole;
    protected String m_sConversationID;
    protected final ICommonsList<MessageProperty> m_aMessageProperties = new CommonsArrayList();
    protected X509Certificate m_aReceiverCertificate;
    protected String m_sEndpointURL;
    protected final ICommonsList<Phase4OutgoingAttachment> m_aAttachments = new CommonsArrayList();
    protected IAS4SignalMessageConsumer m_aSignalMsgConsumer;

    protected AbstractAS4UserMessageBuilder() {
        try {
            this.pmode(this.pmodeResolver().getPModeOfID(null, "s", "a", "i", "r", "a", null));
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to init AbstractAS4UserMessageBuilder", exception);
        }
    }

    @Nullable
    public final IPMode pmode() {
        return this.m_aPMode;
    }

    @Nonnull
    public final IMPLTYPE pmode(@Nullable IPMode iPMode) {
        this.m_aPMode = iPMode;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE service(@Nullable String string) {
        return this.service(null, string);
    }

    @Nonnull
    public final IMPLTYPE service(@Nullable String string, @Nullable String string2) {
        this.m_sServiceType = string;
        this.m_sService = string2;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE action(@Nullable String string) {
        this.m_sAction = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE agreementRef(@Nullable String string) {
        this.m_sAgreementRef = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE pmodeID(@Nullable String string) {
        this.m_sPModeID = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE fromPartyIDType(@Nullable String string) {
        this.m_sFromPartyIDType = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE fromPartyID(@Nullable String string) {
        this.m_sFromPartyID = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE fromRole(@Nullable String string) {
        this.m_sFromRole = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE toPartyIDType(@Nullable String string) {
        this.m_sToPartyIDType = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE toPartyID(@Nullable String string) {
        this.m_sToPartyID = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE toRole(@Nullable String string) {
        this.m_sToRole = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE conversationID(@Nullable String string) {
        this.m_sConversationID = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE addMessageProperty(@Nullable Ebms3Property ebms3Property) {
        return this.addMessageProperty(ebms3Property == null ? null : MessageProperty.builder(ebms3Property));
    }

    @Nonnull
    public final IMPLTYPE addMessageProperty(@Nullable MessageProperty.Builder builder) {
        return this.addMessageProperty(builder == null ? null : builder.build());
    }

    @Nonnull
    public final IMPLTYPE addMessageProperty(@Nullable MessageProperty messageProperty) {
        if (messageProperty != null) {
            this.m_aMessageProperties.add((Object)messageProperty);
        }
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE messageProperty(@Nullable Ebms3Property ebms3Property) {
        return this.messageProperty(ebms3Property == null ? null : MessageProperty.builder(ebms3Property));
    }

    @Nonnull
    public final IMPLTYPE messageProperty(@Nullable MessageProperty.Builder builder) {
        return this.messageProperty(builder == null ? null : builder.build());
    }

    @Nonnull
    public final IMPLTYPE messageProperty(@Nullable MessageProperty messageProperty) {
        if (messageProperty == null) {
            this.m_aMessageProperties.clear();
        } else {
            this.m_aMessageProperties.set((Object)messageProperty);
        }
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE messageProperties(MessageProperty ... messagePropertyArray) {
        this.m_aMessageProperties.setAll((Object[])messagePropertyArray);
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE messageProperties(@Nullable Iterable<? extends MessageProperty> iterable) {
        this.m_aMessageProperties.setAll(iterable);
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE receiverCertificate(@Nullable X509Certificate x509Certificate) {
        this.m_aReceiverCertificate = x509Certificate;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE endpointURL(@Nullable String string) {
        this.m_sEndpointURL = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE addAttachment(@Nullable Phase4OutgoingAttachment.Builder builder) {
        return this.addAttachment(builder == null ? null : builder.build());
    }

    @Nonnull
    public final IMPLTYPE addAttachment(@Nullable Phase4OutgoingAttachment phase4OutgoingAttachment) {
        if (phase4OutgoingAttachment != null) {
            this.m_aAttachments.add((Object)phase4OutgoingAttachment);
        }
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE attachment(@Nullable Phase4OutgoingAttachment.Builder builder) {
        return this.attachment(builder == null ? null : builder.build());
    }

    @Nonnull
    public final IMPLTYPE attachment(@Nullable Phase4OutgoingAttachment phase4OutgoingAttachment) {
        if (phase4OutgoingAttachment == null) {
            this.m_aAttachments.clear();
        } else {
            this.m_aAttachments.set((Object)phase4OutgoingAttachment);
        }
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE attachments(Phase4OutgoingAttachment ... phase4OutgoingAttachmentArray) {
        this.m_aAttachments.setAll((Object[])phase4OutgoingAttachmentArray);
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE attachments(@Nullable Iterable<? extends Phase4OutgoingAttachment> iterable) {
        this.m_aAttachments.setAll(iterable);
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE signalMsgConsumer(@Nullable IAS4SignalMessageConsumer iAS4SignalMessageConsumer) {
        this.m_aSignalMsgConsumer = iAS4SignalMessageConsumer;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isEveryRequiredFieldSet() {
        if (!super.isEveryRequiredFieldSet()) {
            return false;
        }
        if (this.m_aPMode == null) {
            LOGGER.warn("The field 'PMode' is not set");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sFromPartyID)) {
            LOGGER.warn("The field 'fromPartyID' is not set");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sFromRole)) {
            LOGGER.warn("The field 'fromRole' is not set");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sToPartyID)) {
            LOGGER.warn("The field 'toPartyID' is not set");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sToRole)) {
            LOGGER.warn("The field 'toRole' is not set");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sEndpointURL)) {
            LOGGER.warn("The field 'endpointURL' is not set");
            return false;
        }
        return true;
    }

    @OverridingMethodsMustInvokeSuper
    protected void applyToUserMessage(@Nonnull AS4ClientUserMessage aS4ClientUserMessage2) {
        if (this.m_aCustomHttpPoster != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using a custom IHttpPoster implementation: " + this.m_aCustomHttpPoster);
            }
            aS4ClientUserMessage2.setHttpPoster(this.m_aCustomHttpPoster);
        } else {
            aS4ClientUserMessage2.getHttpPoster().setHttpClientFactory(this.m_aHttpClientFactory);
            aS4ClientUserMessage2.getHttpPoster().setQuoteHttpHeaders(false);
        }
        aS4ClientUserMessage2.setSoapVersion(this.m_eSoapVersion);
        aS4ClientUserMessage2.setSendingDateTimeOrNow(this.m_aSendingDateTime);
        aS4ClientUserMessage2.setAS4CryptoFactory(this.m_aCryptoFactory);
        aS4ClientUserMessage2.setPMode(this.m_aPMode, true);
        if (this.m_aHttpRetrySettings != null) {
            aS4ClientUserMessage2.httpRetrySettings().assignFrom(this.m_aHttpRetrySettings);
        }
        if (this.m_aReceiverCertificate != null) {
            aS4ClientUserMessage2.cryptParams().setCertificate(this.m_aReceiverCertificate);
        }
        aS4ClientUserMessage2.setAgreementRefValue(this.m_sAgreementRef);
        if (StringHelper.hasText((String)this.m_sPModeID)) {
            aS4ClientUserMessage2.setPModeID(this.m_sPModeID);
        } else {
            aS4ClientUserMessage2.setPModeIDFactory(aS4ClientUserMessage -> null);
        }
        aS4ClientUserMessage2.setServiceType(this.m_sServiceType);
        aS4ClientUserMessage2.setServiceValue(this.m_sService);
        aS4ClientUserMessage2.setAction(this.m_sAction);
        if (StringHelper.hasText((String)this.m_sMessageID)) {
            aS4ClientUserMessage2.setMessageID(this.m_sMessageID);
        }
        if (StringHelper.hasText((String)this.m_sRefToMessageID)) {
            aS4ClientUserMessage2.setRefToMessageID(this.m_sRefToMessageID);
        }
        aS4ClientUserMessage2.setConversationID(this.m_sConversationID != null ? this.m_sConversationID : MessageHelperMethods.createRandomConversationID());
        aS4ClientUserMessage2.setFromPartyIDType(this.m_sFromPartyIDType);
        aS4ClientUserMessage2.setFromPartyID(this.m_sFromPartyID);
        aS4ClientUserMessage2.setFromRole(this.m_sFromRole);
        aS4ClientUserMessage2.setToPartyIDType(this.m_sToPartyIDType);
        aS4ClientUserMessage2.setToPartyID(this.m_sToPartyID);
        aS4ClientUserMessage2.setToRole(this.m_sToRole);
        for (MessageProperty messageProperty : this.m_aMessageProperties) {
            aS4ClientUserMessage2.ebms3Properties().add((Object)messageProperty.getAsEbms3Property());
        }
    }

    @Nonnull
    public final ESimpleUserMessageSendResult sendMessageAndCheckForReceipt() {
        return this.sendMessageAndCheckForReceipt(phase4Exception -> LOGGER.error("Exception sending AS4 user message", (Throwable)phase4Exception));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public final ESimpleUserMessageSendResult sendMessageAndCheckForReceipt(@Nullable Consumer<? super Phase4Exception> consumer) {
        Object object;
        IAS4SignalMessageConsumer iAS4SignalMessageConsumer = this.m_aSignalMsgConsumer;
        try {
            Wrapper wrapper = new Wrapper();
            IAS4SignalMessageConsumer iAS4SignalMessageConsumer2 = iAS4SignalMessageConsumer == null ? arg_0 -> ((Wrapper)wrapper).set(arg_0) : (this.m_aSignalMsgConsumer = ebms3SignalMessage -> {
                wrapper.set((Object)ebms3SignalMessage);
                iAS4SignalMessageConsumer.handleSignalMessage(ebms3SignalMessage);
            });
            if (this.sendMessage().isFailure()) {
                ESimpleUserMessageSendResult eSimpleUserMessageSendResult = ESimpleUserMessageSendResult.INVALID_PARAMETERS;
                return eSimpleUserMessageSendResult;
            }
            object = (Ebms3SignalMessage)wrapper.get();
            if (object == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to get a SignalMessage as the response");
                }
                ESimpleUserMessageSendResult eSimpleUserMessageSendResult = ESimpleUserMessageSendResult.NO_SIGNAL_MESSAGE_RECEIVED;
                return eSimpleUserMessageSendResult;
            }
            if (((Ebms3SignalMessage)object).hasErrorEntries()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("The received SignalMessage contains at lease one error");
                }
                ESimpleUserMessageSendResult eSimpleUserMessageSendResult = ESimpleUserMessageSendResult.AS4_ERROR_MESSAGE_RECEIVED;
                return eSimpleUserMessageSendResult;
            }
            if (((Ebms3SignalMessage)object).getReceipt() != null) {
                ESimpleUserMessageSendResult eSimpleUserMessageSendResult = ESimpleUserMessageSendResult.SUCCESS;
                return eSimpleUserMessageSendResult;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The SignalMessage contains neither Errors nor a Receipt - unexpected SignalMessage layout.");
            }
            ESimpleUserMessageSendResult eSimpleUserMessageSendResult = ESimpleUserMessageSendResult.INVALID_SIGNAL_MESSAGE_RECEIVED;
            return eSimpleUserMessageSendResult;
        }
        catch (Phase4Exception phase4Exception) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("An exception occurred sending out the AS4 message", (Throwable)phase4Exception);
            }
            if (consumer != null) {
                consumer.accept(phase4Exception);
            }
            object = ESimpleUserMessageSendResult.TRANSPORT_ERROR;
            return object;
        }
        finally {
            this.m_aSignalMsgConsumer = iAS4SignalMessageConsumer;
        }
    }

    public static enum ESimpleUserMessageSendResult implements IHasID<String>,
    ISuccessIndicator
    {
        INVALID_PARAMETERS("invalid-parameters"),
        TRANSPORT_ERROR("transport-error"),
        NO_SIGNAL_MESSAGE_RECEIVED("no-signal-msg-received"),
        AS4_ERROR_MESSAGE_RECEIVED("as4-error-msg-received"),
        INVALID_SIGNAL_MESSAGE_RECEIVED("invalid-signal-message-received"),
        SUCCESS("success");

        private final String m_sID;

        private ESimpleUserMessageSendResult(String string2) {
            this.m_sID = string2;
        }

        @Nonnull
        @Nonempty
        public String getID() {
            return this.m_sID;
        }

        public boolean isSuccess() {
            return this == SUCCESS;
        }

        public boolean isRetryFeasible() {
            return this == TRANSPORT_ERROR || this == NO_SIGNAL_MESSAGE_RECEIVED || this == INVALID_SIGNAL_MESSAGE_RECEIVED;
        }

        @Nullable
        public static ESimpleUserMessageSendResult getFromIDOrNull(@Nullable String string) {
            return (ESimpleUserMessageSendResult)EnumHelper.getFromIDOrNull(ESimpleUserMessageSendResult.class, (Object)string);
        }
    }
}

