/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.sender;

import com.helger.phase4.attachment.Phase4OutgoingAttachment;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.client.AS4ClientUserMessage;
import com.helger.phase4.sender.AS4BidirectionalClientHelper;
import com.helger.phase4.sender.AbstractAS4UserMessageBuilder;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.util.Phase4Exception;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractAS4UserMessageBuilderMIMEPayload<IMPLTYPE extends AbstractAS4UserMessageBuilderMIMEPayload<IMPLTYPE>>
extends AbstractAS4UserMessageBuilder<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAS4UserMessageBuilderMIMEPayload.class);
    private Phase4OutgoingAttachment m_aPayload;

    protected AbstractAS4UserMessageBuilderMIMEPayload() {
    }

    @Nonnull
    public final IMPLTYPE payload(@Nullable Phase4OutgoingAttachment.Builder builder) {
        return this.payload(builder == null ? null : builder.build());
    }

    @Nonnull
    public final IMPLTYPE payload(@Nullable Phase4OutgoingAttachment phase4OutgoingAttachment) {
        this.m_aPayload = phase4OutgoingAttachment;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilderMIMEPayload)this.thisAsT());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isEveryRequiredFieldSet() {
        if (!super.isEveryRequiredFieldSet()) {
            return false;
        }
        if (this.m_aPayload == null) {
            LOGGER.warn("The field 'payload' is not set");
            return false;
        }
        return true;
    }

    @Override
    protected final void mainSendMessage() throws Phase4Exception {
        try (AS4ResourceHelper aS4ResourceHelper = new AS4ResourceHelper();){
            AS4ClientUserMessage aS4ClientUserMessage = new AS4ClientUserMessage(aS4ResourceHelper);
            this.applyToUserMessage(aS4ClientUserMessage);
            aS4ClientUserMessage.setPayload(null);
            aS4ClientUserMessage.addAttachment(WSS4JAttachment.createOutgoingFileAttachment(this.m_aPayload, aS4ResourceHelper));
            for (Phase4OutgoingAttachment phase4OutgoingAttachment : this.m_aAttachments) {
                aS4ClientUserMessage.addAttachment(WSS4JAttachment.createOutgoingFileAttachment(phase4OutgoingAttachment, aS4ResourceHelper));
            }
            AS4BidirectionalClientHelper.sendAS4UserMessageAndReceiveAS4SignalMessage(this.m_aCryptoFactory, this.pmodeResolver(), this.incomingAttachmentFactory(), this.incomingProfileSelector(), aS4ClientUserMessage, this.m_aLocale, this.m_sEndpointURL, this.m_aBuildMessageCallback, this.m_aOutgoingDumper, this.m_aIncomingDumper, this.m_aRetryCallback, this.m_aResponseConsumer, this.m_aSignalMsgConsumer);
        }
        catch (Phase4Exception phase4Exception) {
            throw phase4Exception;
        }
        catch (Exception exception) {
            throw new Phase4Exception("Wrapped Phase4Exception", exception);
        }
    }
}

