/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.http.EHttpMethod;
import com.helger.http.EHttpVersion;
import com.helger.phase4.attachment.IAS4IncomingAttachmentFactory;
import com.helger.phase4.crypto.AS4CryptoFactoryProperties;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.model.pmode.resolve.DefaultPModeResolver;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.servlet.AS4IncomingMessageMetadata;
import com.helger.phase4.servlet.AS4RequestHandler;
import com.helger.phase4.servlet.AS4UnifiedResponse;
import com.helger.phase4.util.Phase4Exception;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS4XServletHandler
implements IXServletSimpleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4XServletHandler.class);
    private Supplier<? extends IAS4CryptoFactory> m_aCryptoFactorySupplier;
    private IPModeResolver m_aPModeResolver;
    private IAS4IncomingAttachmentFactory m_aIAF;
    private IHandlerCustomizer m_aHandlerCustomizer;

    public AS4XServletHandler() {
        this(AS4CryptoFactoryProperties::getDefaultInstance, DefaultPModeResolver.DEFAULT_PMODE_RESOLVER, IAS4IncomingAttachmentFactory.DEFAULT_INSTANCE);
    }

    public AS4XServletHandler(@Nonnull Supplier<? extends IAS4CryptoFactory> supplier, @Nonnull IPModeResolver iPModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory) {
        this.setCryptoFactorySupplier(supplier);
        this.setPModeResolver(iPModeResolver);
        this.setIncomingAttachmentFactory(iAS4IncomingAttachmentFactory);
    }

    @Nonnull
    public final Supplier<? extends IAS4CryptoFactory> getCryptoFactorySupplier() {
        return this.m_aCryptoFactorySupplier;
    }

    @Nonnull
    public final AS4XServletHandler setCryptoFactorySupplier(@Nonnull Supplier<? extends IAS4CryptoFactory> supplier) {
        ValueEnforcer.notNull(supplier, (String)"CryptoFactorySupplier");
        this.m_aCryptoFactorySupplier = supplier;
        return this;
    }

    @Nonnull
    public final IPModeResolver getPModeResolver() {
        return this.m_aPModeResolver;
    }

    @Nonnull
    public final AS4XServletHandler setPModeResolver(@Nonnull IPModeResolver iPModeResolver) {
        ValueEnforcer.notNull((Object)iPModeResolver, (String)"PModeResolver");
        this.m_aPModeResolver = iPModeResolver;
        return this;
    }

    @Nonnull
    public final IAS4IncomingAttachmentFactory getIncomingAttachmentFactory() {
        return this.m_aIAF;
    }

    @Nonnull
    public final AS4XServletHandler setIncomingAttachmentFactory(@Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory) {
        ValueEnforcer.notNull((Object)iAS4IncomingAttachmentFactory, (String)"IAF");
        this.m_aIAF = iAS4IncomingAttachmentFactory;
        return this;
    }

    @Nullable
    public final IHandlerCustomizer getHandlerCustomizer() {
        return this.m_aHandlerCustomizer;
    }

    @Nonnull
    public final AS4XServletHandler setHandlerCustomizer(@Nullable IHandlerCustomizer iHandlerCustomizer) {
        this.m_aHandlerCustomizer = iHandlerCustomizer;
        return this;
    }

    @Nonnull
    public AS4UnifiedResponse createUnifiedResponse(@Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull HttpServletRequest httpServletRequest, @Nonnull IRequestWebScope iRequestWebScope) {
        return new AS4UnifiedResponse(eHttpVersion, eHttpMethod, httpServletRequest);
    }

    @Nonnull
    @OverrideOnDemand
    protected AS4IncomingMessageMetadata createIncomingMessageMetadata(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return AS4IncomingMessageMetadata.createForRequest().setRemoteAddr(iRequestWebScopeWithoutResponse.getRemoteAddr()).setRemoteHost(iRequestWebScopeWithoutResponse.getRemoteHost()).setRemotePort(iRequestWebScopeWithoutResponse.getRemotePort()).setRemoteUser(iRequestWebScopeWithoutResponse.getRemoteUser()).setCookies(iRequestWebScopeWithoutResponse.getCookies());
    }

    protected void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull AS4UnifiedResponse aS4UnifiedResponse, @Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IPModeResolver iPModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nullable IHandlerCustomizer iHandlerCustomizer) throws Exception {
        AS4IncomingMessageMetadata aS4IncomingMessageMetadata = this.createIncomingMessageMetadata(iRequestWebScopeWithoutResponse);
        try (AS4RequestHandler aS4RequestHandler = new AS4RequestHandler(iAS4CryptoFactory, iPModeResolver, iAS4IncomingAttachmentFactory, aS4IncomingMessageMetadata);){
            if (iHandlerCustomizer != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Before customizeBeforeHandling");
                }
                iHandlerCustomizer.customizeBeforeHandling(iRequestWebScopeWithoutResponse, aS4UnifiedResponse, aS4RequestHandler);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("After customizeBeforeHandling");
                }
            }
            aS4RequestHandler.handleRequest(iRequestWebScopeWithoutResponse, aS4UnifiedResponse);
            if (iHandlerCustomizer != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Before customizeAfterHandling");
                }
                iHandlerCustomizer.customizeAfterHandling(iRequestWebScopeWithoutResponse, aS4UnifiedResponse, aS4RequestHandler);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("After customizeAfterHandling");
                }
            }
        }
        catch (Phase4Exception phase4Exception) {
            aS4UnifiedResponse.setResponseError(400, "Bad Request: " + phase4Exception.getMessage(), phase4Exception.getCause());
        }
        catch (Exception exception) {
            aS4UnifiedResponse.setResponseError(500, "Internal error processing AS4 request", exception);
        }
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        IAS4CryptoFactory iAS4CryptoFactory = this.m_aCryptoFactorySupplier.get();
        if (iAS4CryptoFactory == null) {
            throw new IllegalStateException("Failed to get an AS4 CryptoFactory");
        }
        this.handleRequest(iRequestWebScopeWithoutResponse, (AS4UnifiedResponse)unifiedResponse, iAS4CryptoFactory, this.m_aPModeResolver, this.m_aIAF, this.m_aHandlerCustomizer);
    }

    public static interface IHandlerCustomizer {
        public void customizeBeforeHandling(@Nonnull IRequestWebScopeWithoutResponse var1, @Nonnull AS4UnifiedResponse var2, @Nonnull AS4RequestHandler var3);

        default public void customizeAfterHandling(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull AS4UnifiedResponse aS4UnifiedResponse, @Nonnull AS4RequestHandler aS4RequestHandler) {
        }
    }
}

