/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.mgr;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.ClassHelper;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.quartz.DisallowConcurrentExecution;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.SimpleScheduleBuilder;
import com.helger.quartz.TriggerKey;
import com.helger.schedule.quartz.GlobalQuartzScheduler;
import com.helger.schedule.quartz.trigger.JDK8TriggerBuilder;
import com.helger.web.scope.util.AbstractScopeAwareJob;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public final class AS4DuplicateCleanupJob
extends AbstractScopeAwareJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4DuplicateCleanupJob.class);
    private static final String KEY_MINUTES = "mins";
    private static final AtomicBoolean WAS_SCHEDULED = new AtomicBoolean(false);

    protected void onExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) throws JobExecutionException {
        long l = jobDataMap.getAsLong((Object)KEY_MINUTES);
        OffsetDateTime offsetDateTime = MetaAS4Manager.getTimestampMgr().getCurrentDateTime().minusMinutes(l);
        ICommonsList<String> iCommonsList = MetaAS4Manager.getIncomingDuplicateMgr().evictAllItemsBefore(offsetDateTime);
        if (iCommonsList.isNotEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Evicted " + iCommonsList.size() + " incoming duplicate message IDs before " + offsetDateTime.toString());
        }
    }

    @Nullable
    public static TriggerKey scheduleMe(long l) {
        TriggerKey triggerKey = null;
        if (l > 0L) {
            if (!WAS_SCHEDULED.getAndSet(true)) {
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.putIn((Object)KEY_MINUTES, l);
                triggerKey = GlobalQuartzScheduler.getInstance().scheduleJob(ClassHelper.getClassLocalName(AS4DuplicateCleanupJob.class) + "-" + l, JDK8TriggerBuilder.newTrigger().startNow().withSchedule((IScheduleBuilder)SimpleScheduleBuilder.repeatMinutelyForever()), AS4DuplicateCleanupJob.class, (Map)jobDataMap);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("AS4DuplicateCleanupJob was successfully scheduled");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("AS4DuplicateCleanupJob is already scheduled");
            }
        } else {
            LOGGER.warn("Incoming AS4 duplicate message cleanup is disabled!");
        }
        return triggerKey;
    }

    public static void unschedule(@Nullable TriggerKey triggerKey) {
        if (triggerKey != null) {
            if (WAS_SCHEDULED.getAndSet(false)) {
                GlobalQuartzScheduler.getInstance().unscheduleJob(triggerKey);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("AS4DuplicateCleanupJob was successfully unscheduled");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("AS4DuplicateCleanupJob is not scheduled");
            }
        }
    }
}

