/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.soap;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Phase4KeyStoreCallbackHandler
implements CallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Phase4KeyStoreCallbackHandler.class);
    private final IAS4CryptoFactory m_aCryptoFactory;

    public Phase4KeyStoreCallbackHandler(@Nonnull IAS4CryptoFactory iAS4CryptoFactory) {
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactory");
        this.m_aCryptoFactory = iAS4CryptoFactory;
    }

    @Nonnull
    @Nonempty
    private static String _getUsage(int n) {
        switch (n) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "DECRYPT";
            }
            case 2: {
                return "USERNAME_TOKEN";
            }
            case 3: {
                return "SIGNATURE";
            }
            case 6: {
                return "SECURITY_CONTEXT_TOKEN";
            }
            case 7: {
                return "CUSTOM_TOKEN";
            }
            case 9: {
                return "SECRET_KEY";
            }
            case 10: {
                return "PASSWORD_ENCRYPTOR_PASSWORD";
            }
        }
        return "Unknown usage value " + n;
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbackArray) {
            if (callback instanceof WSPasswordCallback) {
                WSPasswordCallback wSPasswordCallback = (WSPasswordCallback)callback;
                String string = wSPasswordCallback.getIdentifier();
                String string2 = this.m_aCryptoFactory.getKeyPasswordPerAlias(string);
                if (string2 != null) {
                    wSPasswordCallback.setPassword(string2);
                    LOGGER.info("Found keystore password for alias '" + string + "' and usage " + Phase4KeyStoreCallbackHandler._getUsage(wSPasswordCallback.getUsage()));
                    continue;
                }
                LOGGER.warn("Found unsupported keystore alias '" + string + "' and usage " + Phase4KeyStoreCallbackHandler._getUsage(wSPasswordCallback.getUsage()));
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }
}

