/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.soap;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.attachment.WSS4JAttachmentCallbackHandler;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.crypto.AS4CryptoProperties;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.error.EEbmsError;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.servlet.AS4MessageState;
import com.helger.phase4.servlet.soap.ISOAPHeaderElementProcessor;
import com.helger.phase4.servlet.soap.Phase4KeyStoreCallbackHandler;
import com.helger.phase4.wss.WSSConfigManager;
import com.helger.phase4.wss.WSSSynchronizer;
import com.helger.xml.XMLHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPHeaderElementProcessorWSS4J
implements ISOAPHeaderElementProcessor {
    public static final QName QNAME_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    private static final Logger LOGGER = LoggerFactory.getLogger(SOAPHeaderElementProcessorWSS4J.class);
    private final IAS4CryptoFactory m_aCryptoFactory;
    private final IPMode m_aFallbackPMode;

    public SOAPHeaderElementProcessorWSS4J(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nullable IPMode iPMode) {
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"aCryptoFactory");
        this.m_aCryptoFactory = iAS4CryptoFactory;
        this.m_aFallbackPMode = iPMode;
    }

    @Nonnull
    private ESuccess _verifyAndDecrypt(@Nonnull Document document, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4MessageState aS4MessageState, @Nonnull ErrorList errorList, @Nonnull Supplier<WSSConfig> supplier) {
        Locale locale = aS4MessageState.getLocale();
        try {
            Object object;
            Serializable serializable;
            ICommonsList<WSS4JAttachment> iCommonsList22;
            Phase4KeyStoreCallbackHandler phase4KeyStoreCallbackHandler = new Phase4KeyStoreCallbackHandler(this.m_aCryptoFactory);
            WSS4JAttachmentCallbackHandler wSS4JAttachmentCallbackHandler = new WSS4JAttachmentCallbackHandler((Iterable<? extends WSS4JAttachment>)iCommonsList, aS4MessageState.getResourceHelper());
            WSSConfig wSSConfig = supplier.get();
            RequestData requestData = new RequestData();
            requestData.setCallbackHandler((CallbackHandler)phase4KeyStoreCallbackHandler);
            if (iCommonsList.isNotEmpty()) {
                requestData.setAttachmentCallbackHandler((CallbackHandler)wSS4JAttachmentCallbackHandler);
            }
            requestData.setSigVerCrypto(this.m_aCryptoFactory.getCrypto());
            requestData.setDecCrypto(this.m_aCryptoFactory.getCrypto());
            requestData.setWssConfig(wSSConfig);
            requestData.setAllowRSA15KeyTransportAlgorithm(AS4CryptoProperties.createFromConfig().isAllowRSA15KeyTransportAlgorithm());
            WSSecurityEngine wSSecurityEngine = new WSSecurityEngine();
            wSSecurityEngine.setWssConfig(wSSConfig);
            WSHandlerResult wSHandlerResult = wSSecurityEngine.processSecurityHeader(document, requestData);
            List list = wSHandlerResult.getResults();
            CommonsHashSet commonsHashSet = new CommonsHashSet();
            Serializable serializable2 = null;
            int n = 0;
            for (ICommonsList<WSS4JAttachment> iCommonsList22 : list) {
                Object object2;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("WSSecurityEngineResult: " + iCommonsList22);
                }
                int n2 = (object2 = (Integer)iCommonsList22.get((Object)"action")) != null ? (Integer)object2 : 0;
                n |= n2;
                serializable = (X509Certificate)iCommonsList22.get((Object)"x509-certificate");
                if (serializable == null) continue;
                commonsHashSet.add((Object)serializable);
                if (n2 != 4096 || serializable2 != null) continue;
                serializable2 = serializable;
            }
            aS4MessageState.setSoapWSS4JSecurityActions(n);
            if (commonsHashSet.size() > 1) {
                if (serializable2 == null) {
                    LOGGER.warn("Found " + commonsHashSet.size() + " different certificates in message. Using the first one.");
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("All gathered certificates: " + commonsHashSet);
                    }
                    object = (X509Certificate)commonsHashSet.getAtIndex(0);
                } else {
                    object = serializable2;
                }
            } else {
                object = commonsHashSet.size() == 1 ? (X509Certificate)commonsHashSet.getAtIndex(0) : null;
            }
            aS4MessageState.setUsedCertificate((X509Certificate)object);
            aS4MessageState.setDecryptedSoapDocument(document);
            iCommonsList22 = wSS4JAttachmentCallbackHandler.getAllResponseAttachments();
            for (WSS4JAttachment wSS4JAttachment : iCommonsList22) {
                serializable = aS4MessageState.getResourceHelper().createTempFile();
                StreamHelper.copyInputStreamToOutputStreamAndCloseOS((InputStream)wSS4JAttachment.getSourceStream(), (OutputStream)FileHelper.getBufferedOutputStream((File)serializable));
                wSS4JAttachment.setSourceStreamProvider((IHasInputStream)HasInputStream.multiple(() -> SOAPHeaderElementProcessorWSS4J.lambda$_verifyAndDecrypt$0((File)serializable)));
            }
            aS4MessageState.setDecryptedAttachments(iCommonsList22);
            return ESuccess.SUCCESS;
        }
        catch (IllegalStateException | IndexOutOfBoundsException | WSSecurityException throwable) {
            LOGGER.error("Error processing the WSSSecurity Header", throwable);
            errorList.add((Object)EEbmsError.EBMS_FAILED_DECRYPTION.getAsError(locale));
            aS4MessageState.setSoapWSS4JException((Exception)throwable);
            return ESuccess.FAILURE;
        }
        catch (IOException iOException) {
            LOGGER.error("IO error processing the WSSSecurity Header", (Throwable)iOException);
            errorList.add((Object)EEbmsError.EBMS_OTHER.getAsError(locale));
            aS4MessageState.setSoapWSS4JException(iOException);
            return ESuccess.FAILURE;
        }
    }

    @Override
    @Nonnull
    public ESuccess processHeaderElement(@Nonnull Document document, @Nonnull Element element, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4MessageState aS4MessageState, @Nonnull ErrorList errorList) {
        IPMode iPMode = aS4MessageState.getPMode();
        if (iPMode == null) {
            iPMode = this.m_aFallbackPMode;
        }
        if (iPMode == null) {
            throw new IllegalStateException("No PMode contained in AS4 state - seems like Ebms3 Messaging header is missing!");
        }
        Locale locale = aS4MessageState.getLocale();
        PModeLeg pModeLeg = iPMode.getLeg1();
        Ebms3UserMessage ebms3UserMessage = aS4MessageState.getEbmsUserMessage();
        if (ebms3UserMessage != null && StringHelper.hasText((String)ebms3UserMessage.getMessageInfo().getRefToMessageId())) {
            pModeLeg = iPMode.getLeg2();
        }
        if (pModeLeg.getSecurity() != null) {
            Object object;
            Object object2;
            Element element2;
            Element element3 = XMLHelper.getFirstChildElementOfName((Node)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
            if (element3 != null) {
                element2 = XMLHelper.getFirstChildElementOfName((Node)(element3 = XMLHelper.getFirstChildElementOfName((Node)element3, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"SignedInfo")), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"SignatureMethod");
                String string = element2 == null ? null : element2.getAttribute("Algorithm");
                object2 = ECryptoAlgorithmSign.getFromURIOrNull(string);
                if (object2 == null) {
                    LOGGER.error("Error processing the Security Header, your signing algorithm '" + string + "' is incorrect. Expected one of the following '" + Arrays.asList(ECryptoAlgorithmSign.values()) + "' algorithms");
                    errorList.add((Object)EEbmsError.EBMS_FAILED_AUTHENTICATION.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using signature algorithm " + (Object)object2);
                }
                element3 = XMLHelper.getFirstChildElementOfName((Node)element3, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Reference");
                string = (element3 = XMLHelper.getFirstChildElementOfName((Node)element3, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"DigestMethod")) == null ? null : element3.getAttribute("Algorithm");
                object = ECryptoAlgorithmSignDigest.getFromURIOrNull(string);
                if (object == null) {
                    LOGGER.error("Error processing the Security Header, your signing digest algorithm is incorrect. Expected one of the following'" + Arrays.toString((Object[])ECryptoAlgorithmSignDigest.values()) + "' algorithms");
                    errorList.add((Object)EEbmsError.EBMS_FAILED_AUTHENTICATION.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using signature digest algorithm " + (Object)object);
                }
            }
            if (ebms3UserMessage != null) {
                boolean bl = aS4MessageState.isSoapBodyPayloadPresent();
                for (int i = 0; i < iCommonsList.size(); ++i) {
                    object2 = (String)((WSS4JAttachment)iCommonsList.get(i)).getHeaders().get("Content-ID");
                    if (StringHelper.hasNoText((String)object2)) {
                        LOGGER.error("The provided attachment ID in the 'Content-ID' header may not be empty.");
                        errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                        return ESuccess.FAILURE;
                    }
                    if (!((String)object2).startsWith("<attachment=")) {
                        LOGGER.error("The provided attachment ID '" + (String)object2 + "' in the 'Content-ID' header does not start with the required prefix '" + "<attachment=" + "'");
                        errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                        return ESuccess.FAILURE;
                    }
                    if (!((String)object2).endsWith(">")) {
                        LOGGER.error("The provided attachment ID '" + (String)object2 + "' in the 'Content-ID' header does not end with the required suffix '" + ">" + "'");
                        errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                        return ESuccess.FAILURE;
                    }
                    object2 = ((String)object2).substring("<attachment=".length(), ((String)object2).length() - ">".length());
                    object = ebms3UserMessage.getPayloadInfo().getPartInfoAtIndex((bl ? 1 : 0) + i).getHref();
                    if (((String)object).contains((CharSequence)object2)) continue;
                    LOGGER.error("The usermessage part information '" + (String)object + "' does not reference the respective attachment ID '" + (String)object2 + "'");
                    errorList.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            }
            if ((element2 = AS4Configuration.isWSS4JSynchronizedSecurity() ? (ESuccess)WSSSynchronizer.call(() -> this._verifyAndDecrypt(document, iCommonsList, aS4MessageState, errorList, WSSConfigManager::createStaticWSSConfig)) : this._verifyAndDecrypt(document, iCommonsList, aS4MessageState, errorList, WSSConfigManager.getInstance()::createWSSConfig)).isFailure()) {
                return ESuccess.FAILURE;
            }
        }
        return ESuccess.SUCCESS;
    }

    private static /* synthetic */ InputStream lambda$_verifyAndDecrypt$0(File file) {
        return FileHelper.getBufferedInputStream((File)file);
    }
}

