/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.wss;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.lang.priviledged.IPrivilegedAction;
import com.helger.phase4.wss.AS4WsuIdAllocator;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import javax.annotation.Nonnull;
import org.apache.wss4j.dom.WsuIdAllocator;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSSConfigManager
extends AbstractGlobalSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(WSSConfigManager.class);

    @Deprecated
    @UsedViaReflection
    public WSSConfigManager() {
    }

    @Nonnull
    public static WSSConfigManager getInstance() {
        return (WSSConfigManager)WSSConfigManager.getGlobalSingleton(WSSConfigManager.class);
    }

    protected void onAfterInstantiation(@Nonnull IScope iScope) {
        boolean bl;
        boolean bl2;
        boolean bl3 = IPrivilegedAction.securityGetProvider((String)"STRTransform").invokeSafe() != null;
        boolean bl4 = IPrivilegedAction.securityGetProvider((String)"AttachmentContentSignatureTransform").invokeSafe() != null;
        boolean bl5 = bl2 = IPrivilegedAction.securityGetProvider((String)"AttachmentCompleteSignatureTransform").invokeSafe() != null;
        if (bl3 && bl4 && bl2) {
            LOGGER.info("All WSSConfig Security Providers are installed and therefore don't need to be installed again");
            bl = false;
        } else {
            bl = true;
            if (!(bl3 || bl4 || bl2)) {
                LOGGER.info("None of the WSSConfig Security Providers is already installed - doing it now");
            } else {
                LOGGER.warn("Some of the WSSConfig Security Providers are already installed - replacing them now. STRTransform=" + bl3 + "; AttachmentContentSignatureTransform=" + bl4 + "; AttachmentCompleteSignatureTransform=" + bl2);
            }
        }
        WSSConfig.setAddJceProviders((boolean)bl);
        WSSConfig.init();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished initializing WSSConfig Security Providers");
        }
    }

    protected void onBeforeDestroy(IScope iScope) throws Exception {
        LOGGER.info("Cleaning up WSSConfig." + (WSSConfig.isAddJceProviders() ? " Security Providers will also be removed." : " Security Providers were not installed by us."));
        WSSConfig.cleanUp();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished cleaning up WSSConfig");
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static WSSConfig createStaticWSSConfig() {
        WSSConfig wSSConfig = WSSConfig.getNewInstance();
        wSSConfig.setIdAllocator((WsuIdAllocator)new AS4WsuIdAllocator());
        return wSSConfig;
    }

    @Nonnull
    @ReturnsMutableCopy
    public WSSConfig createWSSConfig() {
        return WSSConfigManager.createStaticWSSConfig();
    }
}

