/*
 * Copyright (C) 2015-2024 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.phase4.profile;

import javax.annotation.Nonnull;

import com.helger.commons.annotation.IsSPIInterface;

/**
 * AS4 profile registrar SPI interface
 *
 * @author Philip Helger
 */
@IsSPIInterface
public interface IAS4ProfileRegistrarSPI
{
  /**
   * Register AS4 profiles at the provided registrar.
   *
   * @param aRegistrar
   *        The registrar to register at. Never <code>null</code>.
   */
  void registerAS4Profile (@Nonnull IAS4ProfileRegistrar aRegistrar);
}
