/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.attachment;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.io.ByteArrayWrapper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import java.io.File;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AS4OutgoingAttachment {
    private final ByteArrayWrapper m_aDataBytes;
    private final File m_aDataFile;
    private final String m_sContentID;
    private final String m_sFilename;
    private final IMimeType m_aMimeType;
    private final EAS4CompressionMode m_eCompressionMode;
    private final Charset m_aCharset;

    protected AS4OutgoingAttachment(@Nullable ByteArrayWrapper byteArrayWrapper, @Nullable File file, @Nullable String string, @Nullable String string2, @Nonnull IMimeType iMimeType, @Nullable EAS4CompressionMode eAS4CompressionMode, @Nullable Charset charset) {
        ValueEnforcer.isTrue((byteArrayWrapper != null || file != null ? 1 : 0) != 0, (String)"SrcData or SrcFile must be present");
        ValueEnforcer.isFalse((byteArrayWrapper != null && file != null ? 1 : 0) != 0, (String)"Either SrcData or SrcFile must be present but not both");
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        this.m_aDataBytes = byteArrayWrapper;
        this.m_aDataFile = file;
        this.m_sContentID = string;
        this.m_sFilename = string2;
        this.m_aMimeType = iMimeType;
        this.m_eCompressionMode = eAS4CompressionMode;
        this.m_aCharset = charset;
    }

    @Nullable
    public final ByteArrayWrapper getDataBytes() {
        return this.m_aDataBytes;
    }

    public final boolean hasDataBytes() {
        return this.m_aDataBytes != null;
    }

    @Nullable
    public final File getDataFile() {
        return this.m_aDataFile;
    }

    public final boolean hasDataFile() {
        return this.m_aDataFile != null;
    }

    @Nullable
    public final String getContentID() {
        return this.m_sContentID;
    }

    @Nullable
    public final String getFilename() {
        return this.m_sFilename;
    }

    @Nonnull
    public final IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nullable
    public final EAS4CompressionMode getCompressionMode() {
        return this.m_eCompressionMode;
    }

    @Nullable
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("DataBytes", (Object)this.m_aDataBytes).append("DataFile", (Object)this.m_aDataFile).append("ContentID", (Object)this.m_sContentID).append("Filename", (Object)this.m_sFilename).append("MimeType", (Object)this.m_aMimeType).append("CompressionMode", (Enum)this.m_eCompressionMode).append("Charset", (Object)this.m_aCharset).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IBuilder<AS4OutgoingAttachment> {
        private ByteArrayWrapper m_aDataBytes;
        private File m_aDataFile;
        private String m_sContentID;
        private String m_sFilename;
        private IMimeType m_aMimeType;
        private EAS4CompressionMode m_eCompressionMode;
        private Charset m_aCharset;

        @Nonnull
        public Builder data(@Nullable byte[] byArray) {
            return this.data(byArray == null ? null : new ByteArrayWrapper(byArray, false));
        }

        @Nonnull
        public Builder data(@Nullable ByteArrayWrapper byteArrayWrapper) {
            this.m_aDataBytes = byteArrayWrapper;
            this.m_aDataFile = null;
            return this;
        }

        @Nonnull
        public Builder data(@Nullable File file) {
            this.m_aDataBytes = null;
            this.m_aDataFile = file;
            return this;
        }

        @Nonnull
        public Builder reandomContentID() {
            return this.contentID(MessageHelperMethods.createRandomContentID());
        }

        @Nonnull
        public Builder contentID(@Nullable String string) {
            this.m_sContentID = string;
            return this;
        }

        @Nonnull
        public Builder filename(@Nullable String string) {
            this.m_sFilename = string;
            return this;
        }

        @Nonnull
        public Builder mimeTypeXML() {
            return this.mimeType(CMimeType.APPLICATION_XML);
        }

        @Nonnull
        public Builder mimeType(@Nullable IMimeType iMimeType) {
            this.m_aMimeType = iMimeType;
            return this;
        }

        @Nonnull
        public Builder compressionGZIP() {
            return this.compression(EAS4CompressionMode.GZIP);
        }

        @Nonnull
        public Builder compression(@Nullable EAS4CompressionMode eAS4CompressionMode) {
            this.m_eCompressionMode = eAS4CompressionMode;
            return this;
        }

        @Nonnull
        public Builder charset(@Nullable Charset charset) {
            this.m_aCharset = charset;
            return this;
        }

        @OverridingMethodsMustInvokeSuper
        protected void checkConsistency() {
            if (this.m_aDataBytes == null && this.m_aDataFile == null) {
                throw new IllegalStateException("Phase4OutgoingAttachment has no 'data' element");
            }
            if (this.m_aMimeType == null) {
                throw new IllegalStateException("Phase4OutgoingAttachment has no 'mimeType' element");
            }
        }

        @Nonnull
        public AS4OutgoingAttachment build() {
            this.checkConsistency();
            return new AS4OutgoingAttachment(this.m_aDataBytes, this.m_aDataFile, this.m_sContentID, this.m_sFilename, this.m_aMimeType, this.m_eCompressionMode, this.m_aCharset);
        }
    }
}

