/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.client.AS4ClientBuiltMessage;
import com.helger.phase4.mgr.MetaAS4Manager;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.hc.core5.http.message.StatusLine;

@Immutable
public class AS4ClientSentMessage<T> {
    private final AS4ClientBuiltMessage m_aBuiltMsg;
    private final StatusLine m_aResponseStatusLine;
    private HttpHeaderMap m_aResponseHeaders;
    private final T m_aResponseContent;
    private final OffsetDateTime m_aSentDateTime;

    public AS4ClientSentMessage(@Nonnull AS4ClientBuiltMessage aS4ClientBuiltMessage, @Nullable StatusLine statusLine, @Nonnull HttpHeaderMap httpHeaderMap, @Nullable T t) {
        this(aS4ClientBuiltMessage, statusLine, httpHeaderMap, t, MetaAS4Manager.getTimestampMgr().getCurrentDateTime());
    }

    protected AS4ClientSentMessage(@Nonnull AS4ClientBuiltMessage aS4ClientBuiltMessage, @Nullable StatusLine statusLine, @Nonnull HttpHeaderMap httpHeaderMap, @Nullable T t, @Nonnull OffsetDateTime offsetDateTime) {
        ValueEnforcer.notNull((Object)aS4ClientBuiltMessage, (String)"BuiltMsg");
        ValueEnforcer.notNull((Object)httpHeaderMap, (String)"ResponseHeaders");
        ValueEnforcer.notNull((Object)offsetDateTime, (String)"SentDateTime");
        this.m_aBuiltMsg = aS4ClientBuiltMessage;
        this.m_aResponseStatusLine = statusLine;
        this.m_aResponseHeaders = httpHeaderMap;
        this.m_aResponseContent = t;
        this.m_aSentDateTime = offsetDateTime;
    }

    @Nonnull
    public final AS4ClientBuiltMessage getBuiltMessage() {
        return this.m_aBuiltMsg;
    }

    @Nonnull
    @Nonempty
    public final String getMessageID() {
        return this.m_aBuiltMsg.getMessageID();
    }

    @Nullable
    public final StatusLine getResponseStatusLine() {
        return this.m_aResponseStatusLine;
    }

    public final boolean hasResponseStatusLine() {
        return this.m_aResponseStatusLine != null;
    }

    @Nonnull
    public final HttpHeaderMap getResponseHeaders() {
        return this.m_aResponseHeaders;
    }

    @Nullable
    public final T getResponse() {
        return this.m_aResponseContent;
    }

    public final boolean hasResponse() {
        return this.m_aResponseContent != null;
    }

    @Nonnull
    public final OffsetDateTime getSentDateTime() {
        return this.m_aSentDateTime;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BuiltMsg", (Object)this.m_aBuiltMsg).append("ResponseStatusLine", (Object)this.m_aResponseStatusLine).append("Response", this.m_aResponseContent).append("SentDateTime", (Object)this.m_aSentDateTime).getToString();
    }
}

