/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.crypto.AS4CryptoProperties;
import com.helger.phase4.crypto.AbstractAS4CryptoFactory;
import com.helger.phase4.crypto.ECryptoMode;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import java.security.KeyStore;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;

@Immutable
public class AS4CryptoFactoryProperties
extends AbstractAS4CryptoFactory {
    private static final AS4CryptoFactoryProperties DEFAULT_INSTANCE = new AS4CryptoFactoryProperties(AS4CryptoProperties.createFromConfig());
    private final AS4CryptoProperties m_aCryptoProps;
    private Crypto m_aCrypto;
    private KeyStore m_aKeyStore;
    private KeyStore m_aTrustStore;

    @Nonnull
    public static AS4CryptoFactoryProperties getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public AS4CryptoFactoryProperties(@Nonnull AS4CryptoProperties aS4CryptoProperties) {
        ValueEnforcer.notNull((Object)aS4CryptoProperties, (String)"CryptoProps");
        this.m_aCryptoProps = aS4CryptoProperties.getClone();
    }

    @Nonnull
    @ReturnsMutableObject
    public final AS4CryptoProperties cryptoProperties() {
        return this.m_aCryptoProps;
    }

    @Nonnull
    public static Crypto createCrypto(@Nonnull AS4CryptoProperties aS4CryptoProperties) {
        ValueEnforcer.notNull((Object)aS4CryptoProperties, (String)"CryptoProps");
        try {
            return CryptoFactory.getInstance((Properties)aS4CryptoProperties.getAsProperties());
        }
        catch (WSSecurityException wSSecurityException) {
            throw new IllegalStateException("Failed to create Crypto instance", wSSecurityException);
        }
    }

    @Override
    @Nonnull
    public final Crypto getCrypto(@Nonnull ECryptoMode eCryptoMode) {
        Crypto crypto = this.m_aCrypto;
        if (crypto == null) {
            crypto = this.m_aCrypto = AS4CryptoFactoryProperties.createCrypto(this.m_aCryptoProps);
        }
        return crypto;
    }

    @Override
    @Nullable
    public final KeyStore getKeyStore() {
        KeyStore keyStore = this.m_aKeyStore;
        if (keyStore == null) {
            keyStore = this.m_aKeyStore = KeyStoreHelper.loadKeyStore((IKeyStoreType)this.m_aCryptoProps.getKeyStoreType(), (String)this.m_aCryptoProps.getKeyStorePath(), (String)this.m_aCryptoProps.getKeyStorePassword()).getKeyStore();
        }
        return keyStore;
    }

    @Override
    @Nullable
    public final String getKeyAlias() {
        return this.m_aCryptoProps.getKeyAlias();
    }

    @Override
    @Nullable
    @Deprecated
    public final String getKeyPassword() {
        return this.m_aCryptoProps.getKeyPassword();
    }

    @Override
    @Nullable
    public String getKeyPasswordPerAlias(@Nullable String string) {
        String string2 = this.getKeyAlias();
        if (string2 != null && string != null && string2.equalsIgnoreCase(string)) {
            return this.m_aCryptoProps.getKeyPassword();
        }
        return null;
    }

    @Override
    @Nullable
    public final KeyStore getTrustStore() {
        KeyStore keyStore = this.m_aTrustStore;
        if (keyStore == null) {
            keyStore = this.m_aTrustStore = KeyStoreHelper.loadKeyStore((IKeyStoreType)this.m_aCryptoProps.getTrustStoreType(), (String)this.m_aCryptoProps.getTrustStorePath(), (String)this.m_aCryptoProps.getTrustStorePassword()).getKeyStore();
        }
        return keyStore;
    }

    @Nonnull
    public static AS4CryptoProperties readCryptoPropertiesFromFile(@Nullable String string) {
        AS4CryptoProperties aS4CryptoProperties;
        if (StringHelper.hasNoText((String)string)) {
            aS4CryptoProperties = new AS4CryptoProperties((IReadableResource)new ClassPathResource("private-crypto.properties"));
            if (!aS4CryptoProperties.isRead()) {
                aS4CryptoProperties = new AS4CryptoProperties((IReadableResource)new ClassPathResource("crypto.properties"));
            }
        } else {
            aS4CryptoProperties = new AS4CryptoProperties((IReadableResource)new ClassPathResource(string));
        }
        return aS4CryptoProperties;
    }
}

