/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.string.StringHelper;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.dump.AbstractAS4OutgoingDumperWithHeaders;
import com.helger.phase4.messaging.EAS4MessageMode;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.servlet.IAS4MessageState;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS4OutgoingDumperFileBased
extends AbstractAS4OutgoingDumperWithHeaders {
    public static final String DEFAULT_BASE_PATH = "outgoing/";
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4OutgoingDumperFileBased.class);
    private final IFileProvider m_aFileProvider;

    public AS4OutgoingDumperFileBased() {
        this((eAS4MessageMode, string, n) -> new File(AS4Configuration.getDumpBasePathFile(), DEFAULT_BASE_PATH + IFileProvider.getFilename(string, n)));
    }

    public AS4OutgoingDumperFileBased(@Nonnull IFileProvider iFileProvider) {
        ValueEnforcer.notNull((Object)iFileProvider, (String)"FileProvider");
        this.m_aFileProvider = iFileProvider;
    }

    @Nonnull
    protected final IFileProvider getFileProvider() {
        return this.m_aFileProvider;
    }

    @Override
    protected OutputStream openOutputStream(@Nonnull EAS4MessageMode eAS4MessageMode, @Nullable IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nullable IAS4MessageState iAS4MessageState, @Nonnull @Nonempty String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnegative int n) throws IOException {
        File file = this.m_aFileProvider.getFile(eAS4MessageMode, string, n);
        LOGGER.info("Logging outgoing AS4 message to '" + file.getAbsolutePath() + "' " + (this.isIncludeHeaders() ? "including headers" : "excluding headers"));
        return FileHelper.getBufferedOutputStream((File)file);
    }

    @Nonnull
    public static AS4OutgoingDumperFileBased createForDirectory(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"BaseDirectory");
        return new AS4OutgoingDumperFileBased((eAS4MessageMode, string, n) -> new File(file, IFileProvider.getFilename(string, n)));
    }

    @FunctionalInterface
    public static interface IFileProvider {
        public static final String DEFAULT_FILE_EXTENSION = ".as4out";

        @Nonnull
        public File getFile(@Nonnull EAS4MessageMode var1, @Nonnull @Nonempty String var2, @Nonnegative int var3);

        @Nonnull
        public static String getFilename(@Nonnull @Nonempty String string, @Nonnegative int n) {
            OffsetDateTime offsetDateTime = MetaAS4Manager.getTimestampMgr().getCurrentDateTime();
            return offsetDateTime.getYear() + "/" + StringHelper.getLeadingZero((int)offsetDateTime.getMonthValue(), (int)2) + "/" + StringHelper.getLeadingZero((int)offsetDateTime.getDayOfMonth(), (int)2) + "/" + PDTIOHelper.getTimeForFilename((LocalTime)offsetDateTime.toLocalTime()) + "-" + FilenameHelper.getAsSecureValidASCIIFilename((String)string) + "-" + n + DEFAULT_FILE_EXTENSION;
        }
    }
}

