/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.error;

import com.helger.commons.builder.IBuilder;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.ebms3header.Ebms3Description;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.error.EEbmsErrorCategory;
import com.helger.phase4.error.EEbmsErrorSeverity;
import com.helger.phase4.error.IEbmsError;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Ebms3ErrorBuilder
implements IBuilder<Ebms3Error> {
    private Ebms3Description m_aDescription;
    private String m_sErrorDetail;
    private EEbmsErrorCategory m_eCategory;
    private String m_sRefToMessageInError;
    private String m_sErrorCode;
    private String m_sOrigin;
    private EEbmsErrorSeverity m_eSeverity;
    private String m_sShortDescription;

    public Ebms3ErrorBuilder() {
    }

    public Ebms3ErrorBuilder(@Nonnull IEbmsError iEbmsError, @Nonnull Locale locale) {
        this.description(StringHelper.getNotNull((String)iEbmsError.getDescription().getDisplayText(locale), (String)iEbmsError.getShortDescription()), locale);
        this.category(iEbmsError.getCategory());
        this.errorCode(iEbmsError.getErrorCode());
        this.severity(iEbmsError.getSeverity());
        this.shortDescription(iEbmsError.getShortDescription());
    }

    @Nonnull
    public Ebms3ErrorBuilder description(@Nullable String string, @Nullable Locale locale) {
        return this.description(StringHelper.hasNoText((String)string) ? null : MessageHelperMethods.createEbms3Description(locale == null ? Locale.US : locale, string));
    }

    @Nonnull
    public Ebms3ErrorBuilder description(@Nullable Ebms3Description ebms3Description) {
        this.m_aDescription = ebms3Description;
        return this;
    }

    @Nonnull
    public Ebms3ErrorBuilder errorDetail(@Nullable String string, @Nullable Throwable throwable) {
        Throwable throwable2 = AS4Configuration.isIncludeStackTraceInErrorMessages() ? throwable : null;
        return this.errorDetail(StringHelper.getConcatenatedOnDemand((String)string, (String)": ", (String)(throwable2 == null ? "" : "Technical details: " + StringHelper.getConcatenatedOnDemand((String)throwable2.getClass().getName(), (String)" - ", (String)throwable2.getMessage()))));
    }

    @Nonnull
    public Ebms3ErrorBuilder errorDetail(@Nullable String string) {
        this.m_sErrorDetail = string;
        return this;
    }

    @Nonnull
    public Ebms3ErrorBuilder category(@Nullable EEbmsErrorCategory eEbmsErrorCategory) {
        this.m_eCategory = eEbmsErrorCategory;
        return this;
    }

    @Nonnull
    public Ebms3ErrorBuilder refToMessageInError(@Nullable String string) {
        this.m_sRefToMessageInError = string;
        return this;
    }

    @Nonnull
    public Ebms3ErrorBuilder errorCode(@Nullable String string) {
        this.m_sErrorCode = string;
        return this;
    }

    @Nonnull
    public Ebms3ErrorBuilder origin(@Nullable String string) {
        this.m_sOrigin = string;
        return this;
    }

    @Nonnull
    public Ebms3ErrorBuilder severity(@Nullable IErrorLevel iErrorLevel) {
        return this.severity(EEbmsErrorSeverity.getFromErrorLevelOrNull(iErrorLevel));
    }

    @Nonnull
    public Ebms3ErrorBuilder severity(@Nullable EEbmsErrorSeverity eEbmsErrorSeverity) {
        this.m_eSeverity = eEbmsErrorSeverity;
        return this;
    }

    @Nonnull
    public Ebms3ErrorBuilder shortDescription(@Nullable String string) {
        this.m_sShortDescription = string;
        return this;
    }

    @Nonnull
    public Ebms3Error build() {
        if (this.m_eSeverity == null) {
            throw new IllegalStateException("Severity is required");
        }
        if (StringHelper.hasNoText((String)this.m_sErrorCode)) {
            throw new IllegalStateException("Error Code is required");
        }
        Ebms3Error ebms3Error = new Ebms3Error();
        ebms3Error.setDescription(this.m_aDescription);
        ebms3Error.setErrorDetail(this.m_sErrorDetail);
        if (this.m_eCategory != null) {
            ebms3Error.setCategory(this.m_eCategory.getDisplayName());
        }
        ebms3Error.setRefToMessageInError(this.m_sRefToMessageInError);
        ebms3Error.setErrorCode(this.m_sErrorCode);
        ebms3Error.setOrigin(this.m_sOrigin);
        ebms3Error.setSeverity(this.m_eSeverity.getSeverity());
        ebms3Error.setShortDescription(this.m_sShortDescription);
        return ebms3Error;
    }
}

