/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.error;

import com.helger.commons.error.IError;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.phase4.ebms3header.Ebms3Description;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.error.EEbmsErrorCategory;
import com.helger.phase4.error.EEbmsErrorSeverity;
import com.helger.phase4.error.Ebms3ErrorBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IEbmsError {
    @Nonnull
    public String getErrorCode();

    @Nonnull
    public EEbmsErrorSeverity getSeverity();

    @Nonnull
    public String getShortDescription();

    @Nonnull
    public IHasDisplayText getDescription();

    @Nonnull
    @Deprecated(forRemoval=true, since="2.6.0")
    default public IHasDisplayText getErrorDetail() {
        return this.getDescription();
    }

    @Nonnull
    public EEbmsErrorCategory getCategory();

    @Nonnull
    default public Ebms3ErrorBuilder errorBuilder(@Nonnull Locale locale) {
        return new Ebms3ErrorBuilder(this, locale);
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="2.6.0")
    default public IError getAsError(@Nonnull Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="2.6.0")
    default public Ebms3Error getAsEbms3Error(@Nonnull Locale locale, @Nullable String string) {
        return this.errorBuilder(locale).refToMessageInError(string).build();
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="2.6.0")
    default public Ebms3Error getAsEbms3Error(@Nonnull Locale locale, @Nullable String string, @Nullable String string2) {
        return this.errorBuilder(locale).refToMessageInError(string).errorDetail(string2).build();
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="2.6.0")
    default public Ebms3Error getAsEbms3Error(@Nonnull Locale locale, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        return this.errorBuilder(locale).refToMessageInError(string).errorDetail(string3).origin(string2).build();
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="2.6.0")
    default public Ebms3Error getAsEbms3Error(@Nonnull Locale locale, @Nullable String string, @Nullable String string2, @Nullable Ebms3Description ebms3Description) {
        Ebms3ErrorBuilder ebms3ErrorBuilder = this.errorBuilder(locale).refToMessageInError(string).origin(string2);
        if (ebms3Description != null) {
            ebms3ErrorBuilder.description(ebms3Description);
        }
        return ebms3ErrorBuilder.build();
    }
}

