/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.http;

import com.helger.phase4.marshaller.Ebms3NamespaceHandler;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class AS4HttpDebug {
    public static final boolean DEFAULT_DEBUG = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4HttpDebug.class);
    private static final AtomicBoolean ENABLED = new AtomicBoolean(false);
    private static final XMLWriterSettings XWS = new XMLWriterSettings().setIndent(EXMLSerializeIndent.INDENT_AND_ALIGN).setNamespaceContext((NamespaceContext)((Object)Ebms3NamespaceHandler.getInstance()));

    private AS4HttpDebug() {
    }

    public static void setEnabled(boolean bl) {
        ENABLED.set(bl);
    }

    public static boolean isEnabled() {
        return ENABLED.get();
    }

    public static void debug(@Nonnull Supplier<? super String> supplier) {
        if (AS4HttpDebug.isEnabled()) {
            LOGGER.info("$$$ AS4 HTTP [" + MetaAS4Manager.getTimestampMgr().getCurrentDateTime().toString() + "] " + supplier.get());
        }
    }

    @Nonnull
    public static IXMLWriterSettings getDebugXMLWriterSettings() {
        return XWS;
    }
}

