/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.domain;

import com.helger.commons.ValueEnforcer;
import com.helger.phase4.ebms3header.Ebms3CollaborationInfo;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.ebms3header.Ebms3MessageProperties;
import com.helger.phase4.ebms3header.Ebms3PartyInfo;
import com.helger.phase4.ebms3header.Ebms3PayloadInfo;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.messaging.domain.AbstractAS4Message;
import com.helger.phase4.messaging.domain.EAS4MessageType;
import com.helger.phase4.soap.ESoapVersion;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AS4UserMessage
extends AbstractAS4Message<AS4UserMessage> {
    private final Ebms3UserMessage m_aUserMessage;

    public AS4UserMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Ebms3UserMessage ebms3UserMessage) {
        super(eSoapVersion, EAS4MessageType.USER_MESSAGE);
        ValueEnforcer.notNull((Object)ebms3UserMessage, (String)"UserMessage");
        this.m_aMessaging.addUserMessage(ebms3UserMessage);
        this.m_aUserMessage = ebms3UserMessage;
    }

    @Nonnull
    public final Ebms3UserMessage getEbms3UserMessage() {
        return this.m_aUserMessage;
    }

    @Nonnull
    public static AS4UserMessage create(@Nonnull ESoapVersion eSoapVersion, @Nonnull Ebms3UserMessage ebms3UserMessage) {
        return new AS4UserMessage(eSoapVersion, ebms3UserMessage);
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="2.3.0")
    public static AS4UserMessage create(@Nonnull Ebms3MessageInfo ebms3MessageInfo, @Nullable Ebms3PayloadInfo ebms3PayloadInfo, @Nonnull Ebms3CollaborationInfo ebms3CollaborationInfo, @Nonnull Ebms3PartyInfo ebms3PartyInfo, @Nullable Ebms3MessageProperties ebms3MessageProperties, @Nonnull ESoapVersion eSoapVersion) {
        return AS4UserMessage.create(ebms3MessageInfo, ebms3PayloadInfo, ebms3CollaborationInfo, ebms3PartyInfo, ebms3MessageProperties, null, eSoapVersion);
    }

    @Nonnull
    public static AS4UserMessage create(@Nonnull Ebms3MessageInfo ebms3MessageInfo, @Nullable Ebms3PayloadInfo ebms3PayloadInfo, @Nonnull Ebms3CollaborationInfo ebms3CollaborationInfo, @Nonnull Ebms3PartyInfo ebms3PartyInfo, @Nullable Ebms3MessageProperties ebms3MessageProperties, @Nullable String string, @Nonnull ESoapVersion eSoapVersion) {
        Ebms3UserMessage ebms3UserMessage = new Ebms3UserMessage();
        ebms3UserMessage.setPartyInfo(ebms3PartyInfo);
        ebms3UserMessage.setCollaborationInfo(ebms3CollaborationInfo);
        ebms3UserMessage.setMessageProperties(ebms3MessageProperties);
        ebms3UserMessage.setPayloadInfo(ebms3PayloadInfo);
        ebms3UserMessage.setMessageInfo(ebms3MessageInfo);
        ebms3UserMessage.setMpc(string);
        return AS4UserMessage.create(eSoapVersion, ebms3UserMessage);
    }
}

