/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.domain;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.EURLProtocol;
import com.helger.phase4.attachment.IAS4Attachment;
import com.helger.phase4.ebms3header.Ebms3AgreementRef;
import com.helger.phase4.ebms3header.Ebms3CollaborationInfo;
import com.helger.phase4.ebms3header.Ebms3Description;
import com.helger.phase4.ebms3header.Ebms3From;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.ebms3header.Ebms3MessageProperties;
import com.helger.phase4.ebms3header.Ebms3PartInfo;
import com.helger.phase4.ebms3header.Ebms3PartProperties;
import com.helger.phase4.ebms3header.Ebms3PartyId;
import com.helger.phase4.ebms3header.Ebms3PartyInfo;
import com.helger.phase4.ebms3header.Ebms3PayloadInfo;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3Service;
import com.helger.phase4.ebms3header.Ebms3To;
import com.helger.phase4.mgr.MetaAS4Manager;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.time.OffsetDateTime;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MessageHelperMethods {
    public static final String PART_PROPERTY_MIME_TYPE = "MimeType";
    public static final String PART_PROPERTY_CHARACTER_SET = "CharacterSet";
    public static final String PART_PROPERTY_COMPRESSION_TYPE = "CompressionType";
    public static final String PREFIX_CID = EURLProtocol.CID.getProtocol();
    @RegEx
    public static final String MESSAGE_ID_SUFFIX_REGEX = "^[a-zA-Z0-9\\._\\-]+$";
    private static String s_sCustomMessageIDSuffix = null;

    private MessageHelperMethods() {
    }

    @Nonnull
    @Nonempty
    public static String createRandomConversationID() {
        return "phase4@Conv" + ThreadLocalRandom.current().nextLong();
    }

    @Nullable
    public static String getCustomMessageIDSuffix() {
        return s_sCustomMessageIDSuffix;
    }

    public static void setCustomMessageIDSuffix(@Nullable String string) {
        if (StringHelper.hasText((String)string) && !RegExHelper.stringMatchesPattern((String)MESSAGE_ID_SUFFIX_REGEX, (String)string)) {
            throw new IllegalArgumentException("The provided message ID suffix '" + string + "'does not matche the required regular expression ^[a-zA-Z0-9\\._\\-]+$");
        }
        s_sCustomMessageIDSuffix = StringHelper.trimStart((String)string, (char)'.');
    }

    @Nonnull
    @Nonempty
    public static String createRandomMessageID() {
        return UUID.randomUUID().toString() + "@" + StringHelper.getConcatenatedOnDemand((String)"phase4", (char)'.', (String)s_sCustomMessageIDSuffix);
    }

    @Nonnull
    @Nonempty
    public static String createRandomContentID() {
        return "phase4-att-" + UUID.randomUUID().toString() + "@cid";
    }

    @Nonnull
    @Nonempty
    public static String createRandomMessagingID() {
        return "phase4-msg-" + UUID.randomUUID().toString();
    }

    @Nonnull
    @Nonempty
    public static String createRandomWSUID() {
        return "phase4-wsu-" + UUID.randomUUID().toString();
    }

    @Nonnull
    public static Ebms3MessageInfo createEbms3MessageInfo() {
        return MessageHelperMethods.createEbms3MessageInfo(MessageHelperMethods.createRandomMessageID(), null);
    }

    @Nonnull
    public static Ebms3MessageInfo createEbms3MessageInfo(@Nullable String string) {
        return MessageHelperMethods.createEbms3MessageInfo(MessageHelperMethods.createRandomMessageID(), string);
    }

    @Nonnull
    public static Ebms3MessageInfo createEbms3MessageInfo(@Nonnull @Nonempty String string, @Nullable String string2) {
        return MessageHelperMethods.createEbms3MessageInfo(string, string2, MetaAS4Manager.getTimestampMgr().getCurrentDateTime());
    }

    @Nonnull
    public static Ebms3MessageInfo createEbms3MessageInfo(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull OffsetDateTime offsetDateTime) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"MessageID");
        ValueEnforcer.notNull((Object)offsetDateTime, (String)"DateTime");
        Ebms3MessageInfo ebms3MessageInfo = new Ebms3MessageInfo();
        ebms3MessageInfo.setMessageId(string);
        if (StringHelper.hasText((String)string2)) {
            ebms3MessageInfo.setRefToMessageId(string2);
        }
        ebms3MessageInfo.setTimestamp(XMLOffsetDateTime.of((OffsetDateTime)offsetDateTime));
        return ebms3MessageInfo;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Ebms3Description createEbms3Description(@Nonnull Locale locale, @Nonnull String string) {
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        ValueEnforcer.notNull((Object)string, (String)"Text");
        Ebms3Description ebms3Description = new Ebms3Description();
        ebms3Description.setLang(locale.getLanguage());
        ebms3Description.setValue(string);
        return ebms3Description;
    }

    @Nonnull
    public static Ebms3Property createEbms3Property(@Nonnull @Nonempty String string, @Nonnull String string2) {
        return MessageHelperMethods.createEbms3Property(string, null, string2);
    }

    @Nonnull
    public static Ebms3Property createEbms3Property(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull String string3) {
        Ebms3Property ebms3Property = new Ebms3Property();
        ebms3Property.setName(string);
        ebms3Property.setType(string2);
        ebms3Property.setValue(string3);
        return ebms3Property;
    }

    @Nonnull
    public static Ebms3PartyId createEbms3PartyId(@Nonnull @Nonempty String string) {
        return MessageHelperMethods.createEbms3PartyId(null, string);
    }

    @Nonnull
    public static Ebms3PartyId createEbms3PartyId(@Nullable String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        Ebms3PartyId ebms3PartyId = new Ebms3PartyId();
        ebms3PartyId.setType(string);
        ebms3PartyId.setValue(string2);
        return ebms3PartyId;
    }

    @Nonnull
    public static Ebms3PartyInfo createEbms3ReversePartyInfo(@Nonnull Ebms3PartyInfo ebms3PartyInfo) {
        ValueEnforcer.notNull((Object)ebms3PartyInfo, (String)"OriginalPartyInfo");
        return MessageHelperMethods.createEbms3PartyInfo(ebms3PartyInfo.getTo().getRole(), ebms3PartyInfo.getTo().getPartyIdAtIndex(0).getValue(), ebms3PartyInfo.getFrom().getRole(), ebms3PartyInfo.getFrom().getPartyIdAtIndex(0).getValue());
    }

    @Nonnull
    public static Ebms3PartyInfo createEbms3PartyInfo(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4) {
        return MessageHelperMethods.createEbms3PartyInfo(string, null, string2, string3, null, string4);
    }

    @Nonnull
    public static Ebms3PartyInfo createEbms3PartyInfo(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4, @Nullable String string5, @Nonnull @Nonempty String string6) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FromRole");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"FromPartyID");
        ValueEnforcer.notEmpty((CharSequence)string4, (String)"ToRole");
        ValueEnforcer.notEmpty((CharSequence)string6, (String)"ToPartyID");
        Ebms3PartyInfo ebms3PartyInfo = new Ebms3PartyInfo();
        Ebms3From ebms3From = new Ebms3From();
        ebms3From.setRole(string);
        ebms3From.addPartyId(MessageHelperMethods.createEbms3PartyId(string2, string3));
        ebms3PartyInfo.setFrom(ebms3From);
        Ebms3To ebms3To = new Ebms3To();
        ebms3To.setRole(string4);
        ebms3To.addPartyId(MessageHelperMethods.createEbms3PartyId(string5, string6));
        ebms3PartyInfo.setTo(ebms3To);
        return ebms3PartyInfo;
    }

    @Nullable
    public static Ebms3MessageProperties createEbms3MessageProperties(@Nullable List<Ebms3Property> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Ebms3MessageProperties ebms3MessageProperties = new Ebms3MessageProperties();
        ebms3MessageProperties.setProperty(list);
        return ebms3MessageProperties;
    }

    @Nonnull
    public static Ebms3CollaborationInfo createEbms3CollaborationInfo(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nonnull @Nonempty String string4, @Nonnull @Nonempty String string5, @Nonnull String string6) {
        IExplicitlyCloneable iExplicitlyCloneable;
        ValueEnforcer.notEmpty((CharSequence)string4, (String)"ServiceValue");
        ValueEnforcer.notEmpty((CharSequence)string5, (String)"Action");
        ValueEnforcer.notNull((Object)string6, (String)"ConversationID");
        Ebms3CollaborationInfo ebms3CollaborationInfo = new Ebms3CollaborationInfo();
        if (StringHelper.hasText((String)string2)) {
            iExplicitlyCloneable = new Ebms3AgreementRef();
            if (StringHelper.hasText((String)string)) {
                iExplicitlyCloneable.setPmode(string);
            }
            iExplicitlyCloneable.setValue(string2);
            ebms3CollaborationInfo.setAgreementRef((Ebms3AgreementRef)iExplicitlyCloneable);
        }
        iExplicitlyCloneable = new Ebms3Service();
        iExplicitlyCloneable.setType(string3);
        iExplicitlyCloneable.setValue(string4);
        ebms3CollaborationInfo.setService((Ebms3Service)iExplicitlyCloneable);
        ebms3CollaborationInfo.setAction(string5);
        ebms3CollaborationInfo.setConversationId(string6);
        return ebms3CollaborationInfo;
    }

    @Nullable
    public static Ebms3PartInfo createEbms3PartInfo(@Nullable IAS4Attachment iAS4Attachment) {
        if (iAS4Attachment == null) {
            return null;
        }
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        Ebms3PartProperties ebms3PartProperties = new Ebms3PartProperties();
        ebms3PartProperties.addProperty(MessageHelperMethods.createEbms3Property(PART_PROPERTY_MIME_TYPE, iAS4Attachment.getUncompressedMimeType()));
        commonsHashSet.add((Object)PART_PROPERTY_MIME_TYPE);
        if (iAS4Attachment.hasCharset()) {
            ebms3PartProperties.addProperty(MessageHelperMethods.createEbms3Property(PART_PROPERTY_CHARACTER_SET, iAS4Attachment.getCharset().name()));
            commonsHashSet.add((Object)PART_PROPERTY_CHARACTER_SET);
        }
        if (iAS4Attachment.hasCompressionMode()) {
            ebms3PartProperties.addProperty(MessageHelperMethods.createEbms3Property(PART_PROPERTY_COMPRESSION_TYPE, iAS4Attachment.getCompressionMode().getMimeTypeAsString()));
            commonsHashSet.add((Object)PART_PROPERTY_COMPRESSION_TYPE);
        }
        for (Map.Entry entry : iAS4Attachment.customPartProperties().entrySet()) {
            if (!commonsHashSet.add((Object)((String)entry.getKey()))) continue;
            ebms3PartProperties.addProperty(MessageHelperMethods.createEbms3Property((String)entry.getKey(), (String)entry.getValue()));
        }
        Ebms3PartInfo ebms3PartInfo = new Ebms3PartInfo();
        ebms3PartInfo.setHref(PREFIX_CID + iAS4Attachment.getId());
        ebms3PartInfo.setPartProperties(ebms3PartProperties);
        return ebms3PartInfo;
    }

    @Nullable
    public static Ebms3PayloadInfo createEbms3PayloadInfo(boolean bl, @Nullable ICommonsList<? extends IAS4Attachment> iCommonsList) {
        Ebms3PayloadInfo ebms3PayloadInfo = new Ebms3PayloadInfo();
        if (bl) {
            ebms3PayloadInfo.addPartInfo(new Ebms3PartInfo());
        }
        if (iCommonsList != null) {
            for (IAS4Attachment iAS4Attachment : iCommonsList) {
                ebms3PayloadInfo.addPartInfo(MessageHelperMethods.createEbms3PartInfo(iAS4Attachment));
            }
        }
        if (ebms3PayloadInfo.getPartInfoCount() == 0) {
            return null;
        }
        return ebms3PayloadInfo;
    }

    public static void forEachHeaderAndRemoveAfterwards(@Nonnull MimeMessage mimeMessage, @Nonnull BiConsumer<String, String> biConsumer, boolean bl) throws MessagingException {
        CommonsArrayList commonsArrayList = CollectionHelper.newList((Enumeration)mimeMessage.getAllHeaders());
        for (Header header : commonsArrayList) {
            biConsumer.accept(header.getName(), bl ? HttpHeaderMap.getUnifiedValue((String)header.getValue()) : header.getValue());
        }
        for (Header header : commonsArrayList) {
            mimeMessage.removeHeader(header.getName());
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HttpHeaderMap getAndRemoveAllHeaders(@Nonnull MimeMessage mimeMessage) throws MessagingException {
        HttpHeaderMap httpHeaderMap = new HttpHeaderMap();
        MessageHelperMethods.forEachHeaderAndRemoveAfterwards(mimeMessage, (arg_0, arg_1) -> ((HttpHeaderMap)httpHeaderMap).addHeader(arg_0, arg_1), false);
        return httpHeaderMap;
    }
}

