/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.lang.ClassHelper;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.duplicate.IAS4DuplicateManager;
import com.helger.phase4.mgr.AS4ManagerFactoryInMemory;
import com.helger.phase4.mgr.AS4ManagerFactoryPersistingFileSystem;
import com.helger.phase4.mgr.IAS4ManagerFactory;
import com.helger.phase4.mgr.IAS4TimestampManager;
import com.helger.phase4.model.mpc.IMPCManager;
import com.helger.phase4.model.pmode.IPModeManager;
import com.helger.phase4.profile.IAS4ProfileManager;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaAS4Manager
extends AbstractGlobalSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaAS4Manager.class);
    private static IAS4ManagerFactory s_aFactory;
    private static IAS4TimestampManager s_aTimestampMgr;
    private IMPCManager m_aMPCMgr;
    private IPModeManager m_aPModeMgr;
    private IAS4DuplicateManager m_aIncomingDuplicateMgr;
    private IAS4ProfileManager m_aProfileMgr;

    @Nonnull
    public static IAS4ManagerFactory getFactory() {
        return s_aFactory;
    }

    public static void setFactory(@Nonnull IAS4ManagerFactory iAS4ManagerFactory) {
        ValueEnforcer.notNull((Object)iAS4ManagerFactory, (String)"Factory");
        s_aFactory = iAS4ManagerFactory;
        s_aTimestampMgr = s_aFactory.createTimestampManager();
    }

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public MetaAS4Manager() {
    }

    protected void onAfterInstantiation(@Nonnull IScope iScope) {
        try {
            LOGGER.info("Creating AS4 managers using factory class " + s_aFactory.getClass().getName());
            this.m_aMPCMgr = s_aFactory.createMPCManager();
            this.m_aPModeMgr = s_aFactory.createPModeManager();
            this.m_aIncomingDuplicateMgr = s_aFactory.createDuplicateManager();
            this.m_aProfileMgr = s_aFactory.createProfileManager();
            this.m_aPModeMgr.validateAllPModes();
            LOGGER.info(ClassHelper.getClassLocalName((Object)((Object)this)) + " was initialized");
        }
        catch (Exception exception) {
            throw new InitializationException("Failed to init " + ClassHelper.getClassLocalName((Object)((Object)this)), (Throwable)exception);
        }
    }

    @Nonnull
    public static MetaAS4Manager getInstance() {
        return (MetaAS4Manager)MetaAS4Manager.getGlobalSingleton(MetaAS4Manager.class);
    }

    @Nonnull
    public static IMPCManager getMPCMgr() {
        return MetaAS4Manager.getInstance().m_aMPCMgr;
    }

    @Nonnull
    public static IPModeManager getPModeMgr() {
        return MetaAS4Manager.getInstance().m_aPModeMgr;
    }

    @Nonnull
    public static IAS4DuplicateManager getIncomingDuplicateMgr() {
        return MetaAS4Manager.getInstance().m_aIncomingDuplicateMgr;
    }

    @Nonnull
    public static IAS4ProfileManager getProfileMgr() {
        return MetaAS4Manager.getInstance().m_aProfileMgr;
    }

    @Nonnull
    public static IAS4TimestampManager getTimestampMgr() {
        return s_aTimestampMgr;
    }

    static {
        if (AS4Configuration.isUseInMemoryManagers()) {
            LOGGER.info("MetaAS4Manager is initialized with in-memory data structures");
            s_aFactory = new AS4ManagerFactoryInMemory();
        } else {
            LOGGER.info("MetaAS4Manager is initialized using file system persistence");
            s_aFactory = new AS4ManagerFactoryPersistingFileSystem();
        }
        s_aTimestampMgr = s_aFactory.createTimestampManager();
    }
}

