/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class PModeReceptionAwareness
implements Serializable {
    public static final boolean DEFAULT_RECEPTION_AWARENESS = true;
    public static final boolean DEFAULT_RETRY = true;
    public static final int DEFAULT_MAX_RETRIES = 1;
    public static final long DEFAULT_RETRY_INTERVAL_MS = 10000L;
    public static final boolean DEFAULT_DUPLICATE_DETECTION = true;
    private ETriState m_eReceptionAwareness = ETriState.UNDEFINED;
    private ETriState m_eRetry = ETriState.UNDEFINED;
    private int m_nMaxRetries;
    private long m_nRetryIntervalMS;
    private ETriState m_eDuplicateDetection = ETriState.UNDEFINED;

    public PModeReceptionAwareness(@Nonnull ETriState eTriState, @Nonnull ETriState eTriState2, int n, long l, @Nonnull ETriState eTriState3) {
        this.setReceptionAwareness(eTriState);
        this.setRetry(eTriState2);
        this.setMaxRetries(n);
        this.setRetryIntervalMS(l);
        this.setDuplicateDetection(eTriState3);
    }

    public final boolean isReceptionAwarenessDefined() {
        return this.m_eReceptionAwareness.isDefined();
    }

    public final boolean isReceptionAwareness() {
        return this.m_eReceptionAwareness.getAsBooleanValue(true);
    }

    @Nonnull
    public final EChange setReceptionAwareness(boolean bl) {
        return this.setReceptionAwareness(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final EChange setReceptionAwareness(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"ReceptionAwareness");
        if (eTriState.equals((Object)this.m_eReceptionAwareness)) {
            return EChange.UNCHANGED;
        }
        this.m_eReceptionAwareness = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isRetryDefined() {
        return this.m_eRetry.isDefined();
    }

    public final boolean isRetry() {
        return this.m_eRetry.getAsBooleanValue(true);
    }

    @Nonnull
    public final EChange setRetry(boolean bl) {
        return this.setRetry(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final EChange setRetry(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"Retry");
        if (eTriState.equals((Object)this.m_eRetry)) {
            return EChange.UNCHANGED;
        }
        this.m_eRetry = eTriState;
        return EChange.CHANGED;
    }

    @Nonnegative
    public final int getMaxRetries() {
        return this.m_nMaxRetries;
    }

    @Nonnull
    public final EChange setMaxRetries(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"MaxRetries");
        if (n == this.m_nMaxRetries) {
            return EChange.UNCHANGED;
        }
        this.m_nMaxRetries = n;
        return EChange.CHANGED;
    }

    @Nonnegative
    public final long getRetryIntervalMS() {
        return this.m_nRetryIntervalMS;
    }

    @Nonnull
    public final EChange setRetryIntervalMS(@Nonnegative long l) {
        ValueEnforcer.isGE0((long)l, (String)"RetryIntervalMS");
        if (l == this.m_nRetryIntervalMS) {
            return EChange.UNCHANGED;
        }
        this.m_nRetryIntervalMS = l;
        return EChange.CHANGED;
    }

    public final boolean isDuplicateDetectionDefined() {
        return this.m_eDuplicateDetection.isDefined();
    }

    public final boolean isDuplicateDetection() {
        return this.m_eDuplicateDetection.getAsBooleanValue(true);
    }

    @Nonnull
    public final EChange setDuplicateDetection(boolean bl) {
        return this.setDuplicateDetection(ETriState.valueOf((boolean)bl));
    }

    @Nonnull
    public final EChange setDuplicateDetection(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"DuplicateDetection");
        if (eTriState.equals((Object)this.m_eDuplicateDetection)) {
            return EChange.UNCHANGED;
        }
        this.m_eDuplicateDetection = eTriState;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeReceptionAwareness pModeReceptionAwareness = (PModeReceptionAwareness)object;
        return this.m_eReceptionAwareness.equals((Object)pModeReceptionAwareness.m_eReceptionAwareness) && this.m_eRetry.equals((Object)pModeReceptionAwareness.m_eRetry) && this.m_nMaxRetries == pModeReceptionAwareness.m_nMaxRetries && this.m_nRetryIntervalMS == pModeReceptionAwareness.m_nRetryIntervalMS && this.m_eDuplicateDetection.equals((Object)pModeReceptionAwareness.m_eDuplicateDetection);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eReceptionAwareness).append((Enum)this.m_eRetry).append(this.m_nMaxRetries).append(this.m_nRetryIntervalMS).append((Enum)this.m_eDuplicateDetection).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ReceptionAwareness", (Enum)this.m_eReceptionAwareness).append("Retry", (Enum)this.m_eRetry).append("MaxRetries", this.m_nMaxRetries).append("RetryIntervalMS", this.m_nRetryIntervalMS).append("DuplicateDetection", (Enum)this.m_eDuplicateDetection).getToString();
    }

    @Nonnull
    public static PModeReceptionAwareness createDefault() {
        return new PModeReceptionAwareness(ETriState.valueOf((boolean)true), ETriState.valueOf((boolean)true), 1, 10000L, ETriState.valueOf((boolean)true));
    }
}

