/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class PModeAddressList
implements Serializable,
ICloneable<PModeAddressList> {
    public static final char ADDRESS_SEPARATOR = ',';
    private final ICommonsList<String> m_aAddresses = new CommonsArrayList();

    public PModeAddressList() {
    }

    public PModeAddressList(String ... stringArray) {
        if (stringArray != null) {
            this.addresses().addAll((Object[])stringArray);
        }
    }

    public PModeAddressList(@Nullable Iterable<? extends String> iterable) {
        if (iterable != null) {
            this.addresses().addAll(iterable);
        }
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<String> addresses() {
        return this.m_aAddresses;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getAllAddresses() {
        return (ICommonsList)this.m_aAddresses.getClone();
    }

    @Nonnull
    public String getAsString() {
        return StringHelper.getImploded((char)',', this.m_aAddresses);
    }

    @Nonnull
    @ReturnsMutableCopy
    public PModeAddressList getClone() {
        return new PModeAddressList((Iterable<? extends String>)this.m_aAddresses);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeAddressList pModeAddressList = (PModeAddressList)object;
        return this.m_aAddresses.equals(pModeAddressList.m_aAddresses);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aAddresses).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Addresses", this.m_aAddresses).getToString();
    }

    @Nonnull
    public static PModeAddressList createFromString(@Nullable String string) {
        ICommonsList iCommonsList = StringHelper.getExploded((char)',', (String)string);
        return new PModeAddressList((Iterable<? extends String>)iCommonsList);
    }
}

