/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.resolve;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.pmode.DefaultPMode;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.IPModeManager;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.profile.IAS4Profile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultPModeResolver
implements IPModeResolver {
    public static final IPModeResolver DEFAULT_PMODE_RESOLVER = new DefaultPModeResolver(false);
    private final boolean m_bUseDefaultAsFallback;

    public DefaultPModeResolver(boolean bl) {
        this.m_bUseDefaultAsFallback = bl;
    }

    public final boolean isUseDefaultAsFallback() {
        return this.m_bUseDefaultAsFallback;
    }

    @Override
    @Nullable
    public IPMode getPModeOfID(@Nullable String string, @Nonnull String string2, @Nonnull String string3, @Nonnull @Nonempty String string4, @Nonnull @Nonempty String string5, @Nullable String string6, @Nullable String string7) {
        IPModeManager iPModeManager = MetaAS4Manager.getPModeMgr();
        IPMode iPMode = null;
        if (StringHelper.hasText((String)string) && (iPMode = iPModeManager.getPModeOfID(string)) != null) {
            return iPMode;
        }
        iPMode = iPModeManager.getPModeOfServiceAndAction(string2, string3);
        if (iPMode != null) {
            return iPMode;
        }
        IAS4Profile iAS4Profile = MetaAS4Manager.getProfileMgr().getDefaultProfileOrNull();
        if (iAS4Profile != null) {
            return iAS4Profile.createPModeTemplate(string4, string5, string7);
        }
        if (!this.m_bUseDefaultAsFallback) {
            return null;
        }
        return DefaultPMode.getOrCreateDefaultPMode(string4, string5, string7, true);
    }
}

