/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.string.StringHelper;
import com.helger.commons.wrapper.Wrapper;
import com.helger.phase4.attachment.AS4DecompressException;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.IAS4IncomingAttachmentFactory;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.client.IAS4SignalMessageConsumer;
import com.helger.phase4.client.IAS4UserMessageConsumer;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.crypto.IAS4IncomingSecurityConfiguration;
import com.helger.phase4.dump.AS4DumpManager;
import com.helger.phase4.dump.IAS4IncomingDumper;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3PartInfo;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3PullRequest;
import com.helger.phase4.ebms3header.Ebms3Receipt;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.error.EEbmsError;
import com.helger.phase4.incoming.spi.IAS4IncomingMessageProcessingStatusSPI;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.AS4Helper;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.profile.IAS4Profile;
import com.helger.phase4.profile.IAS4ProfileValidator;
import com.helger.phase4.servlet.AS4MessageState;
import com.helger.phase4.servlet.AS4RequestHandler;
import com.helger.phase4.servlet.IAS4IncomingProfileSelector;
import com.helger.phase4.servlet.IAS4MessageState;
import com.helger.phase4.servlet.soap.AS4SingleSOAPHeader;
import com.helger.phase4.servlet.soap.ISOAPHeaderElementProcessor;
import com.helger.phase4.servlet.soap.SOAPHeaderElementProcessorRegistry;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.util.AS4XMLHelper;
import com.helger.phase4.util.Phase4Exception;
import com.helger.web.multipart.MultipartProgressNotifier;
import com.helger.web.multipart.MultipartStream;
import com.helger.xml.ChildElementIterator;
import com.helger.xml.XMLHelper;
import com.helger.xml.serialize.read.DOMReader;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.xml.namespace.QName;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class AS4IncomingHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4IncomingHandler.class);

    private AS4IncomingHandler() {
    }

    public static void parseAS4Message(@Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull @WillClose InputStream inputStream, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull IAS4ParsedMessageCallback iAS4ParsedMessageCallback, @Nullable IAS4IncomingDumper iAS4IncomingDumper) throws Phase4Exception, IOException, MessagingException, WSSecurityException {
        Object object;
        String string = httpHeaderMap.getFirstHeaderValue("Content-Type");
        if (StringHelper.hasNoText((String)string)) {
            throw new Phase4Exception("Content-Type header is missing");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received Content-Type string: '" + string + "'");
        }
        MimeType mimeType = MimeTypeParser.safeParseMimeType((String)string);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received Content-Type object: " + (IMimeType)mimeType);
        }
        if (mimeType == null) {
            throw new Phase4Exception("Failed to parse Content-Type '" + string + "'");
        }
        IMimeType iMimeType = mimeType.getCopyWithoutParameters();
        IAS4IncomingDumper iAS4IncomingDumper2 = iAS4IncomingDumper != null ? iAS4IncomingDumper : AS4DumpManager.getIncomingDumper();
        Document document = null;
        ESoapVersion eSoapVersion = null;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Wrapper wrapper = new Wrapper();
        Throwable throwable = null;
        ICommonsList iCommonsList = ServiceLoaderHelper.getAllSPIImplementations(IAS4IncomingMessageProcessingStatusSPI.class);
        Object object2 = iCommonsList.iterator();
        while (object2.hasNext()) {
            object = (IAS4IncomingMessageProcessingStatusSPI)object2.next();
            try {
                object.onMessageProcessingStarted(iAS4IncomingMessageMetadata);
            }
            catch (Exception exception) {
                LOGGER.error("IAS4IncomingMessageProcessingStatusSPI.onMessageProcessingStarted failed. SPI=" + (IAS4IncomingMessageProcessingStatusSPI)object + "; MessageMetadata=" + iAS4IncomingMessageMetadata, (Throwable)exception);
            }
        }
        try {
            if (iMimeType.equals(AS4RequestHandler.MT_MULTIPART_RELATED)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received MIME message");
                }
                if (StringHelper.hasNoText((String)(object2 = mimeType.getParameterValueWithName("boundary")))) {
                    throw new Phase4Exception("Content-Type '" + string + "' misses 'boundary' parameter");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("MIME Boundary: '" + (String)object2 + "'");
                }
                object = AS4DumpManager.getIncomingDumpAwareInputStream(iAS4IncomingDumper2, inputStream, iAS4IncomingMessageMetadata, httpHeaderMap, (Wrapper<OutputStream>)wrapper);
                try {
                    MultipartStream multipartStream = new MultipartStream((InputStream)object, ((String)object2).getBytes(StandardCharsets.ISO_8859_1), (MultipartProgressNotifier)null);
                    int n = 0;
                    while (true) {
                        boolean bl;
                        boolean bl2 = bl = n == 0 ? multipartStream.skipPreamble() : multipartStream.readBoundary();
                        if (!bl) {
                            break;
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Found MIME part #" + n);
                        }
                        try (MultipartStream.MultipartItemInputStream multipartItemInputStream = multipartStream.createInputStream();){
                            WSS4JAttachment wSS4JAttachment;
                            MimeBodyPart mimeBodyPart = new MimeBodyPart((InputStream)multipartItemInputStream);
                            if (n == 0) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Parsing first MIME part as SOAP document");
                                }
                                document = DOMReader.readXMLDOM((InputStream)mimeBodyPart.getInputStream());
                                wSS4JAttachment = MimeTypeParser.safeParseMimeType((String)mimeBodyPart.getContentType());
                                if (wSS4JAttachment != null) {
                                    wSS4JAttachment = wSS4JAttachment.getCopyWithoutParameters();
                                }
                                if ((eSoapVersion = ESoapVersion.getFromMimeTypeOrNull((IMimeType)wSS4JAttachment)) != null && LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Determined SOAP version " + eSoapVersion + " from Content-Type");
                                }
                                if (eSoapVersion == null && document != null && (eSoapVersion = ESoapVersion.getFromNamespaceURIOrNull(XMLHelper.getNamespaceURI((Node)document))) != null && LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Determined SOAP version " + eSoapVersion + " from XML root element namespace URI");
                                }
                            } else {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Parsing MIME part #" + n + " as attachment");
                                }
                                wSS4JAttachment = iAS4IncomingAttachmentFactory.createAttachment(mimeBodyPart, aS4ResourceHelper);
                                commonsArrayList.add((Object)wSS4JAttachment);
                            }
                        }
                        ++n;
                    }
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Read MIME message with " + commonsArrayList.size() + " attachment(s)");
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received plain message");
                }
                document = DOMReader.readXMLDOM((InputStream)AS4DumpManager.getIncomingDumpAwareInputStream(iAS4IncomingDumper2, inputStream, iAS4IncomingMessageMetadata, httpHeaderMap, (Wrapper<OutputStream>)wrapper));
                if (LOGGER.isDebugEnabled()) {
                    if (document != null) {
                        LOGGER.debug("Successfully parsed payload as XML");
                    } else {
                        LOGGER.debug("Failed to parse payload as XML");
                    }
                }
                if (document != null) {
                    object2 = XMLHelper.getNamespaceURI((Node)document);
                    eSoapVersion = ESoapVersion.getFromNamespaceURIOrNull((String)object2);
                    if (eSoapVersion != null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Determined SOAP version " + eSoapVersion + " from XML root element namespace URI '" + (String)object2 + "'");
                        }
                    } else {
                        LOGGER.warn("Failed to determine SOAP version from XML root element namespace URI '" + (String)object2 + "'");
                    }
                }
                if (eSoapVersion == null) {
                    eSoapVersion = ESoapVersion.getFromMimeTypeOrNull(iMimeType);
                    if (eSoapVersion != null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Determined SOAP version " + eSoapVersion + " from Content-Type '" + iMimeType.getAsString() + "'");
                        }
                    } else {
                        LOGGER.warn("Failed to determine SOAP version from Content-Type '" + iMimeType.getAsString() + "'");
                    }
                }
            }
            if (document == null) {
                throw new Phase4Exception((String)(eSoapVersion == null ? "Failed to parse incoming message!" : "Failed to parse incoming SOAP " + eSoapVersion.getVersion() + " document!"));
            }
            if (eSoapVersion == null) {
                throw new Phase4Exception("Failed to determine SOAP version of XML document!");
            }
            iAS4ParsedMessageCallback.handle(httpHeaderMap, document, eSoapVersion, (ICommonsList<WSS4JAttachment>)commonsArrayList);
        }
        catch (Phase4Exception | MessagingException | IOException | WSSecurityException throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (iAS4IncomingDumper2 != null && wrapper.isSet()) {
                try {
                    iAS4IncomingDumper2.onEndRequest(iAS4IncomingMessageMetadata);
                }
                catch (Exception exception) {
                    LOGGER.error("IncomingDumper.onEndRequest failed. Dumper=" + iAS4IncomingDumper2 + "; MessageMetadata=" + iAS4IncomingMessageMetadata, (Throwable)exception);
                }
            }
            for (IAS4IncomingMessageProcessingStatusSPI iAS4IncomingMessageProcessingStatusSPI : iCommonsList) {
                try {
                    iAS4IncomingMessageProcessingStatusSPI.onMessageProcessingEnded(iAS4IncomingMessageMetadata, (Exception)throwable);
                }
                catch (Exception exception) {
                    LOGGER.error("IAS4IncomingMessageProcessingStatusSPI.onMessageProcessingEnded failed. SPI=" + iAS4IncomingMessageProcessingStatusSPI + "; MessageMetadata=" + iAS4IncomingMessageMetadata, (Throwable)exception);
                }
            }
        }
    }

    private static void _processSoapHeaderElements(@Nonnull SOAPHeaderElementProcessorRegistry sOAPHeaderElementProcessorRegistry, @Nonnull Document document, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4MessageState aS4MessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) throws Phase4Exception {
        Object object;
        QName qName;
        ESoapVersion eSoapVersion = aS4MessageState.getSoapVersion();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ICommonsOrderedMap<QName, ISOAPHeaderElementProcessor> iCommonsOrderedMap = XMLHelper.getFirstChildElementOfName((Node)document.getDocumentElement(), (String)eSoapVersion.getNamespaceURI(), (String)eSoapVersion.getHeaderElementName());
        if (iCommonsOrderedMap == null) {
            throw new Phase4Exception("SOAP document is missing a Header element {" + eSoapVersion.getNamespaceURI() + "}" + eSoapVersion.getHeaderElementName());
        }
        for (Object object2 : new ChildElementIterator((Node)iCommonsOrderedMap)) {
            qName = XMLHelper.getQName((Element)object2);
            object = object2.getAttributeNS(eSoapVersion.getNamespaceURI(), "mustUnderstand");
            boolean bl = eSoapVersion.getMustUnderstandValue(true).equals(object);
            commonsArrayList.add((Object)new AS4SingleSOAPHeader((Element)object2, qName, bl));
        }
        iCommonsOrderedMap = sOAPHeaderElementProcessorRegistry.getAllElementProcessors();
        if (iCommonsOrderedMap.isEmpty()) {
            LOGGER.error("No SOAP Header element processor is registered");
        }
        for (Object object2 : iCommonsOrderedMap.entrySet()) {
            qName = (QName)object2.getKey();
            object = (AS4SingleSOAPHeader)commonsArrayList.findFirst(aS4SingleSOAPHeader -> qName.equals(aS4SingleSOAPHeader.getQName()));
            if (object == null) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Message contains no SOAP header element with QName " + qName.toString());
                continue;
            }
            ISOAPHeaderElementProcessor iSOAPHeaderElementProcessor = (ISOAPHeaderElementProcessor)object2.getValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing SOAP header element " + qName.toString() + " with processor " + iSOAPHeaderElementProcessor);
            }
            CommonsArrayList commonsArrayList2 = new CommonsArrayList();
            try {
                if (iSOAPHeaderElementProcessor.processHeaderElement(document, ((AS4SingleSOAPHeader)object).getNode(), iCommonsList, aS4MessageState, (ICommonsList<Ebms3Error>)commonsArrayList2).isSuccess()) {
                    ((AS4SingleSOAPHeader)object).setProcessed(true);
                    continue;
                }
                LOGGER.error("Failed to process SOAP header element " + qName.toString() + " with processor " + iSOAPHeaderElementProcessor + "; error details: " + (ICommonsList)commonsArrayList2);
                iCommonsList2.addAll((Collection)commonsArrayList2);
            }
            catch (Exception exception) {
                String string = "Error processing SOAP header element " + qName.toString() + " with processor " + iSOAPHeaderElementProcessor;
                LOGGER.error(string, (Throwable)exception);
                iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(aS4MessageState.getLocale()).refToMessageInError(aS4MessageState.getMessageID()).errorDetail(string, exception).build());
            }
            break;
        }
        if (iCommonsList2.isEmpty()) {
            for (Object object2 : commonsArrayList) {
                if (!((AS4SingleSOAPHeader)object2).isMustUnderstand() || ((AS4SingleSOAPHeader)object2).isProcessed()) continue;
                throw new Phase4Exception("Required SOAP header element " + ((AS4SingleSOAPHeader)object2).getQName().toString() + " could not be handled");
            }
        }
    }

    private static void _decompressAttachments(@Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull IAS4MessageState iAS4MessageState) {
        for (WSS4JAttachment wSS4JAttachment : (ICommonsList)iCommonsList.getClone()) {
            Ebms3Property ebms3Property2;
            EAS4CompressionMode eAS4CompressionMode = iAS4MessageState.getAttachmentCompressionMode(wSS4JAttachment.getId());
            if (eAS4CompressionMode == null) continue;
            IHasInputStream iHasInputStream = wSS4JAttachment.getInputStreamProvider();
            wSS4JAttachment.setSourceStreamProvider((IHasInputStream)new HasInputStream(() -> {
                try {
                    InputStream inputStream = iHasInputStream.getInputStream();
                    if (inputStream == null) {
                        throw new IllegalStateException("Failed to create InputStream from " + iHasInputStream);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Decompressing attachment with ID '" + wSS4JAttachment.getId() + "' using " + eAS4CompressionMode);
                    }
                    return eAS4CompressionMode.getDecompressStream(inputStream);
                }
                catch (IOException iOException) {
                    throw new AS4DecompressException(iOException);
                }
            }, iHasInputStream.isReadMultiple()));
            wSS4JAttachment.setCompressionMode(eAS4CompressionMode);
            String string = StringHelper.trimStart((String)wSS4JAttachment.getId(), (String)"attachment=");
            Ebms3PartInfo ebms3PartInfo2 = (Ebms3PartInfo)CollectionHelper.findFirst(ebms3UserMessage.getPayloadInfo().getPartInfo(), ebms3PartInfo -> ebms3PartInfo.getHref() != null && (ebms3PartInfo.getHref().equals(string) || ebms3PartInfo.getHref().equals(MessageHelperMethods.PREFIX_CID + string)));
            if (ebms3PartInfo2 == null || ebms3PartInfo2.getPartProperties() == null || (ebms3Property2 = (Ebms3Property)CollectionHelper.findFirst(ebms3PartInfo2.getPartProperties().getProperty(), ebms3Property -> ebms3Property.getName().equalsIgnoreCase("MimeType"))) == null) continue;
            String string2 = ebms3Property2.getValue();
            if (MimeTypeParser.safeParseMimeType((String)string2) == null) {
                LOGGER.warn("Value '" + string2 + "' of property 'MimeType' is not a valid MIME type");
            }
            wSS4JAttachment.overwriteMimeType(string2);
        }
    }

    @Nonnull
    public static IAS4MessageState processEbmsMessage(@Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nonnull Locale locale, @Nonnull SOAPHeaderElementProcessorRegistry sOAPHeaderElementProcessorRegistry, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector, @Nonnull ICommonsList<Ebms3Error> iCommonsList2, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) throws Phase4Exception {
        ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        ValueEnforcer.notNull((Object)httpHeaderMap, (String)"HttpHeaders");
        ValueEnforcer.notNull((Object)document, (String)"SoapDocument");
        ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion");
        ValueEnforcer.notNull(iCommonsList, (String)"IncomingAttachments");
        ValueEnforcer.notNull((Object)iAS4IncomingProfileSelector, (String)"AS4ProfileSelector");
        ValueEnforcer.notNull(iCommonsList2, (String)"EbmsErrorMessagesTarget");
        ValueEnforcer.notNull((Object)iAS4IncomingMessageMetadata, (String)"MessageMetadata");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received the following SOAP " + eSoapVersion.getVersion() + " document:");
            LOGGER.debug(AS4XMLHelper.serializeXML(document));
            if (iCommonsList.isEmpty()) {
                LOGGER.debug("Without any incoming attachments");
            } else {
                LOGGER.debug("Including the following " + iCommonsList.size() + " attachments:");
                LOGGER.debug(iCommonsList.toString());
            }
        }
        AS4MessageState aS4MessageState = new AS4MessageState(eSoapVersion, aS4ResourceHelper, locale);
        AS4IncomingHandler._processSoapHeaderElements(sOAPHeaderElementProcessorRegistry, document, iCommonsList, aS4MessageState, iCommonsList2);
        boolean bl = iCommonsList2.isEmpty();
        aS4MessageState.setSoapHeaderElementProcessingSuccessful(bl);
        if (bl) {
            Document document2;
            ErrorList errorList;
            IAS4ProfileValidator iAS4ProfileValidator;
            IAS4Profile iAS4Profile;
            Object object;
            Ebms3Receipt ebms3Receipt;
            Ebms3PullRequest ebms3PullRequest;
            Ebms3UserMessage ebms3UserMessage = aS4MessageState.getEbmsUserMessage();
            Ebms3SignalMessage ebms3SignalMessage = aS4MessageState.getEbmsSignalMessage();
            Ebms3Error ebms3Error = aS4MessageState.getEbmsError();
            int n = (ebms3UserMessage != null ? 1 : 0) + ((ebms3PullRequest = aS4MessageState.getEbmsPullRequest()) != null ? 1 : 0) + ((ebms3Receipt = aS4MessageState.getEbmsReceipt()) != null ? 1 : 0) + (ebms3Error != null ? 1 : 0);
            if (n != 1) {
                object = "Expected a UserMessage(" + (ebms3UserMessage != null ? 1 : 0) + "), a PullRequest(" + (ebms3PullRequest != null ? 1 : 0) + "), a Receipt(" + (ebms3Receipt != null ? 1 : 0) + ") or an Error(" + (ebms3Error != null ? 1 : 0) + ")";
                LOGGER.error((String)object);
                iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_NOT_RECOGNIZED.errorBuilder(locale).refToMessageInError(aS4MessageState.getMessageID()).errorDetail((String)object).build());
            }
            object = iAS4IncomingProfileSelector.getAS4ProfileID(aS4MessageState);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Determined AS4 profile ID '" + (String)object + "' for current message");
            }
            IPMode iPMode = aS4MessageState.getPMode();
            PModeLeg pModeLeg = aS4MessageState.getEffectivePModeLeg();
            if (StringHelper.hasText((String)object)) {
                iAS4Profile = MetaAS4Manager.getProfileMgr().getProfileOfID((String)object);
                if (iAS4Profile == null) {
                    throw new IllegalStateException("The configured AS4 profile '" + (String)object + "' does not exist.");
                }
                aS4MessageState.setAS4Profile(iAS4Profile);
                iAS4ProfileValidator = iAS4Profile.getValidator();
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("AS4 state contains no AS4 profile ID - therefore no consistency checks are performed");
                }
                iAS4Profile = null;
                iAS4ProfileValidator = null;
            }
            if (ebms3UserMessage != null) {
                if (iPMode == null) {
                    throw new Phase4Exception("No AS4 P-Mode configuration found for UserMessage!");
                }
                if (pModeLeg == null) {
                    throw new Phase4Exception("No AS4 P-Mode leg could be determined!");
                }
                if (iAS4ProfileValidator != null) {
                    if (iAS4IncomingProfileSelector.validateAgainstProfile()) {
                        errorList = new ErrorList();
                        iAS4ProfileValidator.validatePMode(iPMode, errorList);
                        iAS4ProfileValidator.validateUserMessage(ebms3UserMessage, errorList);
                        iAS4ProfileValidator.validateInitiatorIdentity(ebms3UserMessage, aS4MessageState.getUsedCertificate(), iAS4IncomingMessageMetadata, errorList);
                        if (errorList.isNotEmpty()) {
                            throw new Phase4Exception("Error validating incoming AS4 UserMessage with the profile " + iAS4Profile.getDisplayName() + "\n following errors are present: " + errorList.getAllErrors().getAllTexts(locale));
                        }
                    } else {
                        LOGGER.warn("The AS4 profile '" + (String)object + "' has a validation configured, but the usage was disabled using the AS4ProfileSelector");
                    }
                }
                errorList = aS4MessageState.hasDecryptedAttachments() ? aS4MessageState.getDecryptedAttachments() : aS4MessageState.getOriginalAttachments();
                AS4IncomingHandler._decompressAttachments((ICommonsList<WSS4JAttachment>)errorList, ebms3UserMessage, aS4MessageState);
            } else {
                if (ebms3PullRequest != null && iPMode == null) {
                    throw new Phase4Exception("No AS4 P-Mode configuration found for PullRequest!");
                }
                if (iAS4ProfileValidator != null) {
                    if (iAS4IncomingProfileSelector.validateAgainstProfile()) {
                        errorList = new ErrorList();
                        if (iPMode != null) {
                            iAS4ProfileValidator.validatePMode(iPMode, errorList);
                        }
                        iAS4ProfileValidator.validateSignalMessage(ebms3SignalMessage, errorList);
                        if (errorList.isNotEmpty()) {
                            throw new Phase4Exception("Error validating incoming AS4 SignalMessage with the profile " + iAS4Profile.getDisplayName() + "\n following errors are present: " + errorList.getAllErrors().getAllTexts(locale));
                        }
                    } else {
                        LOGGER.warn("The AS4 profile '" + (String)object + "' has a validation configured, but the usage was disabled using the AS4ProfileSelector");
                    }
                }
            }
            boolean bl2 = aS4MessageState.hasDecryptedSoapDocument();
            Document document3 = document2 = bl2 ? aS4MessageState.getDecryptedSoapDocument() : document;
            assert (document2 != null);
            Element element = XMLHelper.getFirstChildElementOfName((Node)document2.getDocumentElement(), (String)eSoapVersion.getNamespaceURI(), (String)eSoapVersion.getBodyElementName());
            if (element == null) {
                throw new Phase4Exception((bl2 ? "Decrypted" : "Original") + " SOAP document is missing a Body element");
            }
            aS4MessageState.setSoapBodyPayloadNode(element.getFirstChild());
            boolean bl3 = AS4Helper.isPingMessage(iPMode);
            aS4MessageState.setPingMessage(bl3);
        }
        return aS4MessageState;
    }

    @Nullable
    private static IAS4MessageState _parseMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nonnull IPModeResolver iPModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nullable IPMode iPMode, @Nonnull Locale locale, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpResponse httpResponse, @Nonnull byte[] byArray, @Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration) throws Phase4Exception {
        Wrapper wrapper = new Wrapper();
        IAS4ParsedMessageCallback iAS4ParsedMessageCallback = (httpHeaderMap, document, eSoapVersion, iCommonsList) -> {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            SOAPHeaderElementProcessorRegistry sOAPHeaderElementProcessorRegistry = SOAPHeaderElementProcessorRegistry.createDefault(iPModeResolver, iAS4CryptoFactory, iAS4CryptoFactory2, iPMode, iAS4IncomingSecurityConfiguration);
            IAS4MessageState iAS4MessageState = AS4IncomingHandler.processEbmsMessage(aS4ResourceHelper, locale, sOAPHeaderElementProcessorRegistry, httpHeaderMap, document, eSoapVersion, (ICommonsList<WSS4JAttachment>)iCommonsList, iAS4IncomingProfileSelector, (ICommonsList<Ebms3Error>)commonsArrayList, iAS4IncomingMessageMetadata);
            if (!iAS4MessageState.isSoapHeaderElementProcessingSuccessful()) {
                throw new Phase4Exception("Error processing AS4 message", iAS4MessageState.getSoapWSS4JException());
            }
            wrapper.set((Object)iAS4MessageState);
        };
        HttpHeaderMap httpHeaderMap2 = new HttpHeaderMap();
        for (Header header : httpResponse.getHeaders()) {
            httpHeaderMap2.addHeader(header.getName(), header.getValue());
        }
        try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);){
            AS4IncomingHandler.parseAS4Message(iAS4IncomingAttachmentFactory, aS4ResourceHelper, iAS4IncomingMessageMetadata, (InputStream)nonBlockingByteArrayInputStream, httpHeaderMap2, iAS4ParsedMessageCallback, iAS4IncomingDumper);
        }
        catch (Phase4Exception phase4Exception) {
            throw phase4Exception;
        }
        catch (Exception exception) {
            throw new Phase4Exception("Error parsing AS4 message", exception);
        }
        return (IAS4MessageState)wrapper.get();
    }

    @Nullable
    public static Ebms3SignalMessage parseSignalMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nonnull IPModeResolver iPModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nullable IPMode iPMode, @Nonnull Locale locale, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpResponse httpResponse, @Nonnull byte[] byArray, @Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration, @Nullable IAS4SignalMessageConsumer iAS4SignalMessageConsumer) throws Phase4Exception {
        IAS4MessageState iAS4MessageState = AS4IncomingHandler._parseMessage(iAS4CryptoFactory, iAS4CryptoFactory2, iPModeResolver, iAS4IncomingAttachmentFactory, iAS4IncomingProfileSelector, aS4ResourceHelper, iPMode, locale, iAS4IncomingMessageMetadata, httpResponse, byArray, iAS4IncomingDumper, iAS4IncomingSecurityConfiguration);
        if (iAS4MessageState == null) {
            return null;
        }
        Ebms3SignalMessage ebms3SignalMessage = iAS4MessageState.getEbmsSignalMessage();
        if (ebms3SignalMessage == null) {
            if (iAS4MessageState.getEbmsUserMessage() != null) {
                LOGGER.warn("A Message state is present, but it contains a UserMessage instead of a SignalMessage.");
            } else {
                LOGGER.warn("A Message state is present, but it contains neither a UserMessage nor a SignalMessage.");
            }
        } else if (iAS4SignalMessageConsumer != null) {
            iAS4SignalMessageConsumer.handleSignalMessage(ebms3SignalMessage, iAS4IncomingMessageMetadata, iAS4MessageState);
        }
        return ebms3SignalMessage;
    }

    @Nullable
    public static Ebms3UserMessage parseUserMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nonnull IPModeResolver iPModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nullable IPMode iPMode, @Nonnull Locale locale, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpResponse httpResponse, @Nonnull byte[] byArray, @Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration, @Nullable IAS4UserMessageConsumer iAS4UserMessageConsumer) throws Phase4Exception {
        IAS4MessageState iAS4MessageState = AS4IncomingHandler._parseMessage(iAS4CryptoFactory, iAS4CryptoFactory2, iPModeResolver, iAS4IncomingAttachmentFactory, iAS4IncomingProfileSelector, aS4ResourceHelper, iPMode, locale, iAS4IncomingMessageMetadata, httpResponse, byArray, iAS4IncomingDumper, iAS4IncomingSecurityConfiguration);
        if (iAS4MessageState == null) {
            return null;
        }
        Ebms3UserMessage ebms3UserMessage = iAS4MessageState.getEbmsUserMessage();
        if (ebms3UserMessage == null) {
            if (iAS4MessageState.getEbmsSignalMessage() != null) {
                LOGGER.warn("A Message state is present, but it contains a SignalMessage instead of a UserMessage.");
            } else {
                LOGGER.warn("A Message state is present, but it contains neither a SignalMessage nor a UserMessage.");
            }
        } else if (iAS4UserMessageConsumer != null) {
            iAS4UserMessageConsumer.handleUserMessage(ebms3UserMessage, iAS4IncomingMessageMetadata, iAS4MessageState);
        }
        return ebms3UserMessage;
    }

    public static interface IAS4ParsedMessageCallback {
        public void handle(@Nonnull HttpHeaderMap var1, @Nonnull Document var2, @Nonnull ESoapVersion var3, @Nonnull ICommonsList<WSS4JAttachment> var4) throws WSSecurityException, MessagingException, Phase4Exception;
    }
}

