/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.EMimeContentType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.httpclient.response.ResponseHandlerXml;
import com.helger.phase4.attachment.AS4DecompressException;
import com.helger.phase4.attachment.IAS4IncomingAttachmentFactory;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.client.IAS4RetryCallback;
import com.helger.phase4.crypto.AS4CryptParams;
import com.helger.phase4.crypto.AS4SigningParams;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.crypto.IAS4IncomingSecurityConfiguration;
import com.helger.phase4.dump.AS4DumpManager;
import com.helger.phase4.dump.IAS4IncomingDumper;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.ebms3header.Ebms3CollaborationInfo;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.ebms3header.Ebms3MessageProperties;
import com.helger.phase4.ebms3header.Ebms3PartyInfo;
import com.helger.phase4.ebms3header.Ebms3PayloadInfo;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.error.EEbmsError;
import com.helger.phase4.http.AS4HttpDebug;
import com.helger.phase4.http.BasicHttpPoster;
import com.helger.phase4.http.HttpMimeMessageEntity;
import com.helger.phase4.http.HttpRetrySettings;
import com.helger.phase4.http.HttpXMLEntity;
import com.helger.phase4.messaging.EAS4MessageMode;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import com.helger.phase4.messaging.crypto.AS4Encryptor;
import com.helger.phase4.messaging.crypto.AS4Signer;
import com.helger.phase4.messaging.domain.AS4ErrorMessage;
import com.helger.phase4.messaging.domain.AS4ReceiptMessage;
import com.helger.phase4.messaging.domain.AS4UserMessage;
import com.helger.phase4.messaging.domain.EAS4MessageType;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.messaging.mime.AS4MimeMessage;
import com.helger.phase4.messaging.mime.MimeMessageCreator;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.EMEPBinding;
import com.helger.phase4.model.MEPHelper;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.profile.IAS4Profile;
import com.helger.phase4.servlet.AS4IncomingHandler;
import com.helger.phase4.servlet.AS4IncomingProfileSelectorFromGlobal;
import com.helger.phase4.servlet.AS4UnifiedResponse;
import com.helger.phase4.servlet.IAS4IncomingProfileSelector;
import com.helger.phase4.servlet.IAS4MessageState;
import com.helger.phase4.servlet.IAS4RequestHandlerErrorConsumer;
import com.helger.phase4.servlet.IAS4ResponseAbstraction;
import com.helger.phase4.servlet.mgr.AS4ServletMessageProcessorManager;
import com.helger.phase4.servlet.soap.SOAPHeaderElementProcessorRegistry;
import com.helger.phase4.servlet.spi.AS4MessageProcessorResult;
import com.helger.phase4.servlet.spi.AS4SignalMessageProcessorResult;
import com.helger.phase4.servlet.spi.IAS4ServletMessageProcessorSPI;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.util.AS4XMLHelper;
import com.helger.phase4.util.Phase4Exception;
import com.helger.photon.io.PhotonWorkerPool;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import jakarta.mail.MessagingException;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AS4RequestHandler
implements AutoCloseable {
    public static final IMimeType MT_MULTIPART_RELATED = EMimeContentType.MULTIPART.buildMimeType("related");
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4RequestHandler.class);
    private final AS4ResourceHelper m_aResHelper;
    private final IAS4CryptoFactory m_aCryptoFactorySign;
    private final IAS4CryptoFactory m_aCryptoFactoryCrypt;
    private final IPModeResolver m_aPModeResolver;
    private final IAS4IncomingAttachmentFactory m_aIncomingAttachmentFactory;
    private final IAS4IncomingSecurityConfiguration m_aIncomingSecurityConfig;
    private IAS4IncomingProfileSelector m_aIncomingProfileSelector = AS4IncomingProfileSelectorFromGlobal.INSTANCE;
    private final IAS4IncomingMessageMetadata m_aMessageMetadata;
    private Locale m_aLocale = Locale.US;
    private IAS4IncomingDumper m_aIncomingDumper;
    private IAS4OutgoingDumper m_aOutgoingDumper;
    private IAS4RetryCallback m_aRetryCallback;
    private ISoapProcessingFinalizedCallback m_aSoapProcessingFinalizedCB;
    private Supplier<? extends ICommonsList<IAS4ServletMessageProcessorSPI>> m_aProcessorSupplier = AS4ServletMessageProcessorManager::getAllProcessors;
    private IAS4RequestHandlerErrorConsumer m_aErrorConsumer;

    public AS4RequestHandler(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nonnull IPModeResolver iPModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) {
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactorySign");
        ValueEnforcer.notNull((Object)iAS4CryptoFactory2, (String)"CryptoFactoryCrypt");
        ValueEnforcer.notNull((Object)iPModeResolver, (String)"PModeResolver");
        ValueEnforcer.notNull((Object)iAS4IncomingAttachmentFactory, (String)"IncomingAttachmentFactory");
        ValueEnforcer.notNull((Object)iAS4IncomingSecurityConfiguration, (String)"IncomingSecurityConfig");
        ValueEnforcer.notNull((Object)iAS4IncomingMessageMetadata, (String)"MessageMetadata");
        this.m_aResHelper = new AS4ResourceHelper();
        this.m_aCryptoFactorySign = iAS4CryptoFactory;
        this.m_aCryptoFactoryCrypt = iAS4CryptoFactory2;
        this.m_aPModeResolver = iPModeResolver;
        this.m_aIncomingAttachmentFactory = iAS4IncomingAttachmentFactory;
        this.m_aIncomingSecurityConfig = iAS4IncomingSecurityConfiguration;
        this.m_aMessageMetadata = iAS4IncomingMessageMetadata;
    }

    @Override
    public void close() {
        this.m_aResHelper.close();
    }

    @Nonnull
    public final Locale getLocale() {
        return this.m_aLocale;
    }

    @Nonnull
    public final AS4RequestHandler setLocale(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        this.m_aLocale = locale;
        return this;
    }

    @Nonnull
    public final IAS4IncomingProfileSelector getIncomingProfileSelector() {
        return this.m_aIncomingProfileSelector;
    }

    @Nonnull
    public final AS4RequestHandler setIncomingProfileSelector(@Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector) {
        ValueEnforcer.notNull((Object)iAS4IncomingProfileSelector, (String)"IncomingProfileSelector");
        this.m_aIncomingProfileSelector = iAS4IncomingProfileSelector;
        return this;
    }

    @Nullable
    public final IAS4IncomingDumper getIncomingDumper() {
        return this.m_aIncomingDumper;
    }

    @Nonnull
    public final AS4RequestHandler setIncomingDumper(@Nullable IAS4IncomingDumper iAS4IncomingDumper) {
        this.m_aIncomingDumper = iAS4IncomingDumper;
        return this;
    }

    @Nullable
    public final IAS4OutgoingDumper getOutgoingDumper() {
        return this.m_aOutgoingDumper;
    }

    @Nonnull
    public final AS4RequestHandler setOutgoingDumper(@Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
        this.m_aOutgoingDumper = iAS4OutgoingDumper;
        return this;
    }

    @Nullable
    public final IAS4RetryCallback getRetryCallback() {
        return this.m_aRetryCallback;
    }

    @Nonnull
    public final AS4RequestHandler setRetryCallback(@Nullable IAS4RetryCallback iAS4RetryCallback) {
        this.m_aRetryCallback = iAS4RetryCallback;
        return this;
    }

    @Nonnull
    public final Supplier<? extends ICommonsList<IAS4ServletMessageProcessorSPI>> getProcessorSupplier() {
        return this.m_aProcessorSupplier;
    }

    @Nonnull
    public final AS4RequestHandler setProcessorSupplier(@Nonnull Supplier<? extends ICommonsList<IAS4ServletMessageProcessorSPI>> supplier) {
        ValueEnforcer.notNull(supplier, (String)"ProcessorSupplier");
        this.m_aProcessorSupplier = supplier;
        return this;
    }

    @Nullable
    public final IAS4RequestHandlerErrorConsumer getErrorConsumer() {
        return this.m_aErrorConsumer;
    }

    @Nonnull
    public final AS4RequestHandler setErrorConsumer(@Nullable IAS4RequestHandlerErrorConsumer iAS4RequestHandlerErrorConsumer) {
        this.m_aErrorConsumer = iAS4RequestHandlerErrorConsumer;
        return this;
    }

    @Nullable
    public final ISoapProcessingFinalizedCallback getSoapProcessingFinalizedCallback() {
        return this.m_aSoapProcessingFinalizedCB;
    }

    @Nonnull
    public final AS4RequestHandler setSoapProcessingFinalizedCallback(@Nullable ISoapProcessingFinalizedCallback iSoapProcessingFinalizedCallback) {
        this.m_aSoapProcessingFinalizedCB = iSoapProcessingFinalizedCallback;
        return this;
    }

    private void _invokeSPIsForIncoming(@Nonnull HttpHeaderMap httpHeaderMap, @Nullable Ebms3UserMessage ebms3UserMessage, @Nullable Ebms3SignalMessage ebms3SignalMessage, @Nullable Node node, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nullable IPMode iPMode, @Nonnull IAS4MessageState iAS4MessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList3, @Nonnull SPIInvocationResult sPIInvocationResult) {
        ValueEnforcer.isTrue((ebms3UserMessage != null || ebms3SignalMessage != null ? 1 : 0) != 0, (String)"User OR Signal Message must be present");
        ValueEnforcer.isFalse((ebms3UserMessage != null && ebms3SignalMessage != null ? 1 : 0) != 0, (String)"Only one of User OR Signal Message may be present");
        boolean bl = ebms3UserMessage != null;
        String string = bl ? ebms3UserMessage.getMessageInfo().getMessageId() : ebms3SignalMessage.getMessageInfo().getMessageId();
        ICommonsList<IAS4ServletMessageProcessorSPI> iCommonsList4 = this.m_aProcessorSupplier.get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to invoke the following " + iCommonsList4.size() + " SPIs on message ID '" + string + "': " + iCommonsList4);
        }
        if (iCommonsList4.isEmpty()) {
            LOGGER.error("No IAS4ServletMessageProcessorSPI is available to process an incoming message");
        }
        for (IAS4ServletMessageProcessorSPI iAS4ServletMessageProcessorSPI : iCommonsList4) {
            if (iAS4ServletMessageProcessorSPI == null) continue;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Invoking AS4 message processor " + iAS4ServletMessageProcessorSPI + " for incoming message");
                }
                CommonsArrayList commonsArrayList = new CommonsArrayList();
                AS4MessageProcessorResult aS4MessageProcessorResult = bl ? iAS4ServletMessageProcessorSPI.processAS4UserMessage(this.m_aMessageMetadata, httpHeaderMap, ebms3UserMessage, iPMode, node, iCommonsList, iAS4MessageState, (ICommonsList<Ebms3Error>)commonsArrayList) : iAS4ServletMessageProcessorSPI.processAS4SignalMessage(this.m_aMessageMetadata, httpHeaderMap, ebms3SignalMessage, iPMode, iAS4MessageState, (ICommonsList<Ebms3Error>)commonsArrayList);
                if (aS4MessageProcessorResult == null) {
                    throw new IllegalStateException("No result object present from AS4 message processor " + iAS4ServletMessageProcessorSPI + " - this is a programming error");
                }
                if (commonsArrayList.isNotEmpty() || aS4MessageProcessorResult.isFailure()) {
                    if (commonsArrayList.isNotEmpty()) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("AS4 message processor " + iAS4ServletMessageProcessorSPI + " had processing errors - breaking. Details: " + (ICommonsList)commonsArrayList);
                        }
                        if (aS4MessageProcessorResult.isSuccess()) {
                            LOGGER.warn("Processing errors are present but success was returned by a previous AS4 message processor " + iAS4ServletMessageProcessorSPI + " - considering the whole processing to be failed instead");
                        }
                        iCommonsList2.addAll((Collection)commonsArrayList);
                    }
                    return;
                }
                Object object = aS4MessageProcessorResult.getAsyncResponseURL();
                if (StringHelper.hasText((String)object)) {
                    if (sPIInvocationResult.hasAsyncResponseURL()) {
                        String string2 = "Invoked AS4 message processor SPI " + iAS4ServletMessageProcessorSPI + " on '" + string + "' failed: the previous processor already returned an async response URL; it is not possible to handle two URLs. Please check your SPI implementations.";
                        LOGGER.error(string2);
                        iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(this.m_aLocale).refToMessageInError(string).errorDetail(string2).build());
                        return;
                    }
                    sPIInvocationResult.setAsyncResponseURL((String)object);
                    LOGGER.info("Using asynchronous response URL '" + (String)object + "' for message ID '" + string + "'");
                }
                if (!bl) {
                    assert (aS4MessageProcessorResult instanceof AS4SignalMessageProcessorResult);
                    if (ebms3SignalMessage.getReceipt() == null) {
                        object = ((AS4SignalMessageProcessorResult)aS4MessageProcessorResult).getPullReturnUserMessage();
                        if (sPIInvocationResult.hasPullReturnUserMsg()) {
                            if (object != null) {
                                String string3 = "Invoked AS4 message processor SPI " + iAS4ServletMessageProcessorSPI + " on '" + string + "' failed: the previous processor already returned a usermessage; it is not possible to return two usermessage. Please check your SPI implementations.";
                                LOGGER.warn(string3);
                                iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(this.m_aLocale).refToMessageInError(string).errorDetail(string3).build());
                                return;
                            }
                        } else {
                            if (object == null) {
                                String string4 = "Invoked AS4 message processor SPI " + iAS4ServletMessageProcessorSPI + " on '" + string + "' returned a failure: no UserMessage contained in the MPC";
                                LOGGER.error(string4);
                                iCommonsList2.add((Object)EEbmsError.EBMS_EMPTY_MESSAGE_PARTITION_CHANNEL.errorBuilder(this.m_aLocale).refToMessageInError(string).errorDetail(string4).build());
                                return;
                            }
                            sPIInvocationResult.setPullReturnUserMsg((Ebms3UserMessage)object);
                        }
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("The AS4 EbmsSignalMessage already has a Receipt");
                    }
                }
                aS4MessageProcessorResult.addAllAttachmentsTo((Collection<? super WSS4JAttachment>)iCommonsList3);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Successfully invoked AS4 message processor " + iAS4ServletMessageProcessorSPI);
            }
            catch (AS4DecompressException aS4DecompressException) {
                LOGGER.error("Failed to decompress AS4 payload", (Throwable)aS4DecompressException);
                iCommonsList2.add((Object)EEbmsError.EBMS_DECOMPRESSION_FAILURE.errorBuilder(this.m_aLocale).refToMessageInError(string).errorDetail("Failed to decompress AS4 payload", aS4DecompressException).build());
                return;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Error processing incoming AS4 message with processor " + iAS4ServletMessageProcessorSPI, exception);
            }
        }
        sPIInvocationResult.setSuccess(true);
    }

    private void _invokeSPIsForResponse(@Nonnull IAS4MessageState iAS4MessageState, @Nullable IAS4ResponseFactory iAS4ResponseFactory, @Nullable HttpEntity iCommonsList, @Nonnull IMimeType iMimeType, @Nullable String string) {
        ICommonsList<IAS4ServletMessageProcessorSPI> iCommonsList2;
        boolean bl = iAS4ResponseFactory != null;
        byte[] byArray = null;
        if (iAS4ResponseFactory != null) {
            ICommonsList<IAS4ServletMessageProcessorSPI> iCommonsList3 = iCommonsList2 = iCommonsList != null ? iCommonsList : iAS4ResponseFactory.getHttpEntityForSending(iMimeType);
            if (iCommonsList2.isRepeatable()) {
                int n = (int)iCommonsList2.getContentLength();
                if (n < 0) {
                    n = 16384;
                }
                try (Object object = new NonBlockingByteArrayOutputStream(n);){
                    iCommonsList2.writeTo((OutputStream)object);
                    byArray = object.getBufferOrCopy();
                }
                catch (IOException iOException) {
                    LOGGER.error("Error dumping response entity", (Throwable)iOException);
                }
            } else {
                LOGGER.warn("AS4 Response entity is not repeatable and therefore not read for SPIs");
            }
        } else {
            LOGGER.info("No response factory present");
        }
        iCommonsList2 = this.m_aProcessorSupplier.get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to invoke the following " + iCommonsList2.size() + " SPIs on AS4 message ID '" + iAS4MessageState.getMessageID() + "' and AS4 response message ID '" + string + ": " + iCommonsList2);
        }
        for (Object object : iCommonsList2) {
            if (object == null) continue;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Invoking AS4 message processor " + (IAS4ServletMessageProcessorSPI)object + " for response");
                }
                object.processAS4ResponseMessage(this.m_aMessageMetadata, iAS4MessageState, string, byArray, bl);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Finished invoking AS4 message processor " + (IAS4ServletMessageProcessorSPI)object + " for response");
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Error invoking AS4 message processor " + (IAS4ServletMessageProcessorSPI)object + " for response", exception);
            }
        }
    }

    @Nonnull
    private static AS4UserMessage _createReversedUserMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList) {
        Ebms3MessageInfo ebms3MessageInfo = MessageHelperMethods.createEbms3MessageInfo(string, ebms3UserMessage.getMessageInfo().getMessageId());
        Ebms3PayloadInfo ebms3PayloadInfo = MessageHelperMethods.createEbms3PayloadInfo(false, iCommonsList);
        Ebms3PartyInfo ebms3PartyInfo = MessageHelperMethods.createEbms3ReversePartyInfo(ebms3UserMessage.getPartyInfo());
        Ebms3CollaborationInfo ebms3CollaborationInfo = ebms3UserMessage.getCollaborationInfo();
        Ebms3MessageProperties ebms3MessageProperties = new Ebms3MessageProperties();
        Ebms3Property ebms3Property = null;
        Ebms3Property ebms3Property2 = null;
        for (Ebms3Property ebms3Property3 : ebms3UserMessage.getMessageProperties().getProperty()) {
            if (ebms3Property3.getName().equals("originalSender")) {
                ebms3Property2 = ebms3Property3;
                continue;
            }
            if (!ebms3Property3.getName().equals("finalRecipient")) continue;
            ebms3Property = ebms3Property3;
        }
        if (ebms3Property2 != null && ebms3Property != null) {
            ebms3Property.setName("originalSender");
            ebms3Property2.setName("finalRecipient");
            ebms3MessageProperties.addProperty(ebms3Property.clone());
            ebms3MessageProperties.addProperty(ebms3Property2.clone());
        }
        return AS4UserMessage.create(ebms3MessageInfo, ebms3PayloadInfo, ebms3CollaborationInfo, ebms3PartyInfo, ebms3MessageProperties, null, eSoapVersion);
    }

    private static boolean _isSendErrorAsResponse(@Nullable PModeLeg pModeLeg) {
        if (pModeLeg != null && pModeLeg.hasErrorHandling() && pModeLeg.getErrorHandling().isReportAsResponseDefined()) {
            return pModeLeg.getErrorHandling().isReportAsResponse();
        }
        return true;
    }

    private static boolean _isSendReceiptAsResponse(@Nullable PModeLeg pModeLeg) {
        if (pModeLeg != null && pModeLeg.hasSecurity()) {
            return EPModeSendReceiptReplyPattern.RESPONSE.equals((Object)pModeLeg.getSecurity().getSendReceiptReplyPattern());
        }
        return true;
    }

    @Nonnull
    private Document _signResponseIfNeeded(@Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4SigningParams aS4SigningParams, @Nonnull Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string) throws WSSecurityException {
        Document document2 = aS4SigningParams.isSigningEnabled() ? AS4Signer.createSignedMessage(this.m_aCryptoFactorySign, document, eSoapVersion, string, iCommonsList, this.m_aResHelper, true, aS4SigningParams.getClone()) : document;
        return document2;
    }

    private static boolean _isSendNonRepudiationInformation(@Nonnull PModeLeg pModeLeg) {
        if (pModeLeg.hasSecurity() && pModeLeg.getSecurity().isSendReceiptNonRepudiationDefined()) {
            return pModeLeg.getSecurity().isSendReceiptNonRepudiation();
        }
        return false;
    }

    @Nonnull
    private IAS4ResponseFactory _createResponseReceiptMessage(@Nonnull IAS4MessageState iAS4MessageState, @Nullable Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string, @Nonnull PModeLeg pModeLeg, @Nullable Ebms3UserMessage ebms3UserMessage, @Nullable ICommonsList<WSS4JAttachment> iCommonsList) throws WSSecurityException {
        AS4ReceiptMessage aS4ReceiptMessage = (AS4ReceiptMessage)AS4ReceiptMessage.create(eSoapVersion, string, ebms3UserMessage, document, AS4RequestHandler._isSendNonRepudiationInformation(pModeLeg)).setMustUnderstand(true);
        ESoapVersion eSoapVersion2 = pModeLeg.getProtocol().getSoapVersion();
        if (eSoapVersion2 != eSoapVersion) {
            LOGGER.warn("Received message with " + eSoapVersion + " but the Response PMode leg requires " + eSoapVersion2);
        }
        Document document2 = aS4ReceiptMessage.getAsSoapDocument();
        AS4SigningParams aS4SigningParams = this.m_aIncomingSecurityConfig.getSigningParamsCloneOrNew().setFromPMode(pModeLeg.getSecurity());
        Document document3 = this._signResponseIfNeeded(iCommonsList, aS4SigningParams, document2, eSoapVersion2, aS4ReceiptMessage.getMessagingID());
        return new AS4ResponseFactoryXML(this.m_aMessageMetadata, iAS4MessageState, string, document3, eSoapVersion2.getMimeType());
    }

    @Nonnull
    private IAS4ResponseFactory _createResponseErrorMessage(@Nonnull IAS4MessageState iAS4MessageState, @Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string, @Nullable PModeLeg pModeLeg, @Nonnull @Nonempty ICommonsList<Ebms3Error> iCommonsList) {
        ESoapVersion eSoapVersion2;
        AS4ErrorMessage aS4ErrorMessage = AS4ErrorMessage.create(eSoapVersion, MessageHelperMethods.createEbms3MessageInfo(string, iAS4MessageState.getMessageID()), iCommonsList);
        if (this.m_aErrorConsumer != null) {
            this.m_aErrorConsumer.onAS4ErrorMessage(iAS4MessageState, iCommonsList, aS4ErrorMessage);
        }
        if (pModeLeg != null) {
            eSoapVersion2 = pModeLeg.getProtocol().getSoapVersion();
            if (eSoapVersion2 != eSoapVersion) {
                LOGGER.warn("Received message with " + eSoapVersion + " but the Response PMode leg requires " + eSoapVersion2);
            }
        } else {
            eSoapVersion2 = eSoapVersion;
        }
        Document document = aS4ErrorMessage.getAsSoapDocument();
        if (pModeLeg != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying to sign AS4 Error response");
            }
            try {
                Document document2;
                AS4SigningParams aS4SigningParams = this.m_aIncomingSecurityConfig.getSigningParamsCloneOrNew().setFromPMode(pModeLeg.getSecurity());
                document = document2 = this._signResponseIfNeeded(null, aS4SigningParams, document, eSoapVersion2, aS4ErrorMessage.getMessagingID());
            }
            catch (WSSecurityException wSSecurityException) {
                LOGGER.warn("Tried to sign the AS4 Error message but failed. Returning the unsigned AS4 Error instead.", (Throwable)wSSecurityException);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cannot sign AS4 Error response, because no PMode Leg was provided");
        }
        return new AS4ResponseFactoryXML(this.m_aMessageMetadata, iAS4MessageState, string, document, eSoapVersion2.getMimeType());
    }

    @Nonnull
    private AS4MimeMessage _createMimeMessageForResponse(@Nonnull Document document, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull ESoapVersion eSoapVersion, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException, MessagingException {
        AS4MimeMessage aS4MimeMessage;
        if (aS4CryptParams.isCryptEnabled(arg_0 -> ((Logger)LOGGER).warn(arg_0))) {
            if (iCommonsList.isNotEmpty()) {
                aS4MimeMessage = AS4Encryptor.encryptToMimeMessage(eSoapVersion, document, iCommonsList, this.m_aCryptoFactoryCrypt, true, this.m_aResHelper, aS4CryptParams);
            } else {
                LOGGER.info("AS4 encryption is enabled but no response attachments are present");
                aS4MimeMessage = MimeMessageCreator.generateMimeMessage(eSoapVersion, document, iCommonsList);
            }
        } else {
            aS4MimeMessage = MimeMessageCreator.generateMimeMessage(eSoapVersion, document, iCommonsList);
        }
        if (aS4MimeMessage == null) {
            throw new IllegalStateException("Failed to create MimeMessage!");
        }
        return aS4MimeMessage;
    }

    @Nonnull
    private IAS4ResponseFactory _createResponseUserMessage(@Nonnull IAS4MessageState iAS4MessageState, @Nonnull ESoapVersion eSoapVersion, @Nonnull AS4UserMessage aS4UserMessage, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4SigningParams aS4SigningParams, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException, MessagingException {
        IAS4ResponseFactory iAS4ResponseFactory;
        String string = aS4UserMessage.getEbms3UserMessage().getMessageInfo().getMessageId();
        Document document = this._signResponseIfNeeded(iCommonsList, aS4SigningParams, aS4UserMessage.getAsSoapDocument(), eSoapVersion, aS4UserMessage.getMessagingID());
        if (iCommonsList.isEmpty()) {
            iAS4ResponseFactory = new AS4ResponseFactoryXML(this.m_aMessageMetadata, iAS4MessageState, string, document, eSoapVersion.getMimeType());
        } else {
            AS4MimeMessage aS4MimeMessage = this._createMimeMessageForResponse(document, iCommonsList, eSoapVersion, aS4CryptParams);
            iAS4ResponseFactory = new AS4ResponseFactoryMIME(this.m_aMessageMetadata, iAS4MessageState, string, aS4MimeMessage);
        }
        return iAS4ResponseFactory;
    }

    @Nullable
    private IAS4ResponseFactory _handleSoapMessage(@Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) throws WSSecurityException, MessagingException, Phase4Exception {
        Object object;
        String string;
        IAS4Profile iAS4Profile;
        Object object2;
        SOAPHeaderElementProcessorRegistry sOAPHeaderElementProcessorRegistry = SOAPHeaderElementProcessorRegistry.createDefault(this.m_aPModeResolver, this.m_aCryptoFactorySign, this.m_aCryptoFactoryCrypt, null, this.m_aIncomingSecurityConfig);
        IAS4MessageState iAS4MessageState = AS4IncomingHandler.processEbmsMessage(this.m_aResHelper, this.m_aLocale, sOAPHeaderElementProcessorRegistry, httpHeaderMap, document, eSoapVersion, iCommonsList, this.m_aIncomingProfileSelector, iCommonsList2, this.m_aMessageMetadata);
        IPMode iPMode = iAS4MessageState.getPMode();
        PModeLeg pModeLeg = iAS4MessageState.getEffectivePModeLeg();
        String string2 = iAS4MessageState.getMessageID();
        ICommonsList<WSS4JAttachment> iCommonsList3 = iAS4MessageState.hasDecryptedAttachments() ? iAS4MessageState.getDecryptedAttachments() : iAS4MessageState.getOriginalAttachments();
        Node node = iAS4MessageState.getSoapBodyPayloadNode();
        Ebms3UserMessage ebms3UserMessage = iAS4MessageState.getEbmsUserMessage();
        Ebms3SignalMessage ebms3SignalMessage = iAS4MessageState.getEbmsSignalMessage();
        if (iAS4MessageState.isSoapHeaderElementProcessingSuccessful()) {
            boolean bl;
            object2 = iAS4MessageState.getProfileID();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Now checking for duplicate message with message ID '" + string2 + "' and profile ID '" + (String)object2 + "'");
            }
            if (bl = MetaAS4Manager.getIncomingDuplicateMgr().registerAndCheck(string2, (String)object2, iPMode == null ? null : (String)iPMode.getID()).isBreak()) {
                String string3 = "Not invoking SPIs, because message with Message ID '" + string2 + "' was already handled (this is a duplicate)";
                LOGGER.error(string3);
                iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(this.m_aLocale).refToMessageInError(string2).errorDetail(string3).build());
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Message is not a duplicate");
            }
        }
        object2 = new SPIInvocationResult();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        boolean bl = true;
        if (iCommonsList2.isNotEmpty()) {
            bl = false;
        }
        if ((iAS4Profile = iAS4MessageState.getAS4Profile()) == null) {
            if (iAS4MessageState.isPingMessage()) {
                bl = false;
            }
        } else if (iAS4MessageState.isPingMessage()) {
            bl = iAS4Profile.isInvokeSPIForPingMessage();
        }
        if (iAS4MessageState.isPingMessage() && !bl) {
            LOGGER.info("Received an AS4 Ping message - meaning it will NOT be handled by the custom handlers.");
        }
        if (bl) {
            if (iPMode == null || iPMode.getMEPBinding().isSynchronous() || iPMode.getMEPBinding().isAsynchronousInitiator() || iAS4MessageState.getEffectivePModeLegNumber() != 1) {
                this._invokeSPIsForIncoming(httpHeaderMap, ebms3UserMessage, ebms3SignalMessage, node, iCommonsList3, iPMode, iAS4MessageState, iCommonsList2, (ICommonsList<WSS4JAttachment>)commonsArrayList, (SPIInvocationResult)object2);
                if (object2.isFailure()) {
                    LOGGER.warn("Error invoking synchronous SPIs");
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Successfully invoked synchronous SPIs");
                }
                if (this.m_aSoapProcessingFinalizedCB != null) {
                    this.m_aSoapProcessingFinalizedCB.onProcessingFinalized(true);
                }
            } else {
                string = () -> this.lambda$_handleSoapMessage$1(httpHeaderMap, ebms3UserMessage, ebms3SignalMessage, node, iCommonsList3, iPMode, iAS4MessageState, eSoapVersion, pModeLeg, (ICommonsList)commonsArrayList, string2);
                object = PhotonWorkerPool.getInstance().runThrowing("phase4 async processing", (IThrowingRunnable)string);
                if (this.m_aSoapProcessingFinalizedCB != null) {
                    ((CompletableFuture)object).thenRun(() -> this.m_aSoapProcessingFinalizedCB.onProcessingFinalized(false));
                }
            }
        }
        if (iAS4MessageState.isSoapHeaderElementProcessingSuccessful() && iAS4MessageState.getEbmsError() != null) {
            string = null;
            object = null;
        } else if (iCommonsList2.isNotEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating AS4 error message with these " + iCommonsList2.size() + " errors: " + iCommonsList2.getAllMapped(ebms3Error -> StringHelper.getConcatenatedOnDemand((String)ebms3Error.getDescriptionValue(), (String)" / ", (String)ebms3Error.getErrorDetail())));
            }
            if (AS4RequestHandler._isSendErrorAsResponse(pModeLeg)) {
                string = MessageHelperMethods.createRandomMessageID();
                object = this._createResponseErrorMessage(iAS4MessageState, eSoapVersion, string, pModeLeg, iCommonsList2);
            } else {
                LOGGER.warn("Not sending back the AS4 Error response, because it is prohibited in the PMode");
                string = null;
                object = null;
            }
        } else if (ebms3SignalMessage != null && ebms3SignalMessage.getReceipt() != null) {
            string = null;
            object = null;
        } else if (iPMode.getMEP().isOneWay() || iPMode.getMEPBinding().isAsynchronous()) {
            if (iPMode.getMEPBinding().equals((Object)EMEPBinding.PULL) || iPMode.getMEPBinding().equals((Object)EMEPBinding.PULL_PUSH) && ((SPIInvocationResult)object2).hasPullReturnUserMsg() || iPMode.getMEPBinding().equals((Object)EMEPBinding.PUSH_PULL) && ((SPIInvocationResult)object2).hasPullReturnUserMsg()) {
                AS4UserMessage aS4UserMessage = new AS4UserMessage(eSoapVersion, ((SPIInvocationResult)object2).getPullReturnUserMsg());
                string = aS4UserMessage.getEbms3UserMessage().getMessageInfo().getMessageId();
                object = new AS4ResponseFactoryXML(this.m_aMessageMetadata, iAS4MessageState, string, aS4UserMessage.getAsSoapDocument(), eSoapVersion.getMimeType());
            } else if (ebms3UserMessage != null) {
                boolean bl2 = AS4RequestHandler._isSendReceiptAsResponse(pModeLeg);
                if (bl2) {
                    string = MessageHelperMethods.createRandomMessageID();
                    object = this._createResponseReceiptMessage(iAS4MessageState, document, eSoapVersion, string, pModeLeg, ebms3UserMessage, (ICommonsList<WSS4JAttachment>)commonsArrayList);
                } else {
                    LOGGER.info("Not sending back the Receipt response, because sending Receipt response is prohibited in PMode");
                    string = null;
                    object = null;
                }
            } else {
                string = null;
                object = null;
            }
        } else {
            PModeLeg pModeLeg2 = iPMode.getLeg2();
            if (pModeLeg2 == null) {
                throw new Phase4Exception("PMode has no leg2!");
            }
            if (MEPHelper.isValidResponseTypeLeg2(iPMode.getMEP(), iPMode.getMEPBinding(), EAS4MessageType.USER_MESSAGE)) {
                string = MessageHelperMethods.createRandomMessageID();
                AS4UserMessage aS4UserMessage = AS4RequestHandler._createReversedUserMessage(eSoapVersion, string, ebms3UserMessage, (ICommonsList<WSS4JAttachment>)commonsArrayList);
                AS4SigningParams aS4SigningParams = this.m_aIncomingSecurityConfig.getSigningParamsCloneOrNew().setFromPMode(pModeLeg2.getSecurity());
                String string4 = ebms3UserMessage.getPartyInfo().getTo().getPartyIdAtIndex(0).getValue();
                AS4CryptParams aS4CryptParams = this.m_aIncomingSecurityConfig.getCryptParamsCloneOrNew().setFromPMode(pModeLeg2.getSecurity()).setAlias(string4);
                object = this._createResponseUserMessage(iAS4MessageState, pModeLeg2.getProtocol().getSoapVersion(), aS4UserMessage, (ICommonsList<WSS4JAttachment>)commonsArrayList, aS4SigningParams, aS4CryptParams);
            } else {
                string = null;
                object = null;
            }
        }
        this._invokeSPIsForResponse(iAS4MessageState, (IAS4ResponseFactory)object, null, eSoapVersion.getMimeType(), string);
        return object;
    }

    public void handleRequest(@Nonnull @WillClose InputStream inputStream, @Nonnull HttpHeaderMap httpHeaderMap2, @Nonnull IAS4ResponseAbstraction iAS4ResponseAbstraction) throws Phase4Exception, IOException, MessagingException, WSSecurityException {
        AS4IncomingHandler.IAS4ParsedMessageCallback iAS4ParsedMessageCallback = (httpHeaderMap, document, eSoapVersion, iCommonsList) -> {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            IAS4ResponseFactory iAS4ResponseFactory = this._handleSoapMessage(httpHeaderMap, document, eSoapVersion, (ICommonsList<WSS4JAttachment>)iCommonsList, (ICommonsList<Ebms3Error>)commonsArrayList);
            if (iAS4ResponseFactory != null) {
                IAS4OutgoingDumper iAS4OutgoingDumper = this.m_aOutgoingDumper != null ? this.m_aOutgoingDumper : AS4DumpManager.getOutgoingDumper();
                iAS4ResponseFactory.applyToResponse(iAS4ResponseAbstraction, iAS4OutgoingDumper);
            } else {
                iAS4ResponseAbstraction.setStatus(204);
            }
            AS4HttpDebug.debug(() -> "RECEIVE-END with " + (iAS4ResponseFactory != null ? "EBMS message" : "no content"));
        };
        AS4IncomingHandler.parseAS4Message(this.m_aIncomingAttachmentFactory, this.m_aResHelper, this.m_aMessageMetadata, inputStream, httpHeaderMap2, iAS4ParsedMessageCallback, this.m_aIncomingDumper);
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull AS4UnifiedResponse aS4UnifiedResponse) throws Phase4Exception, IOException, MessagingException, WSSecurityException {
        AS4HttpDebug.debug(() -> "RECEIVE-START at " + iRequestWebScopeWithoutResponse.getFullContextAndServletPath());
        ServletInputStream servletInputStream = iRequestWebScopeWithoutResponse.getRequest().getInputStream();
        HttpHeaderMap httpHeaderMap = iRequestWebScopeWithoutResponse.headers().getClone();
        IAS4ResponseAbstraction iAS4ResponseAbstraction = IAS4ResponseAbstraction.wrap(aS4UnifiedResponse);
        this.handleRequest((InputStream)servletInputStream, httpHeaderMap, iAS4ResponseAbstraction);
    }

    private /* synthetic */ void lambda$_handleSoapMessage$1(HttpHeaderMap httpHeaderMap, Ebms3UserMessage ebms3UserMessage, Ebms3SignalMessage ebms3SignalMessage, Node node, ICommonsList iCommonsList, IPMode iPMode, IAS4MessageState iAS4MessageState, ESoapVersion eSoapVersion, PModeLeg pModeLeg, ICommonsList iCommonsList2, String string) throws Exception {
        IAS4ResponseFactory iAS4ResponseFactory;
        Object object;
        Object object2;
        AS4SigningParams aS4SigningParams;
        Object object3;
        String string2;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        SPIInvocationResult sPIInvocationResult = new SPIInvocationResult();
        this._invokeSPIsForIncoming(httpHeaderMap, ebms3UserMessage, ebms3SignalMessage, node, (ICommonsList<WSS4JAttachment>)iCommonsList, iPMode, iAS4MessageState, (ICommonsList<Ebms3Error>)commonsArrayList, (ICommonsList<WSS4JAttachment>)commonsArrayList2, sPIInvocationResult);
        if (sPIInvocationResult.isSuccess()) {
            assert (commonsArrayList.isEmpty());
            string2 = MessageHelperMethods.createRandomMessageID();
            object3 = AS4RequestHandler._createReversedUserMessage(eSoapVersion, string2, ebms3UserMessage, (ICommonsList<WSS4JAttachment>)commonsArrayList2);
            aS4SigningParams = this.m_aIncomingSecurityConfig.getSigningParamsCloneOrNew().setFromPMode(pModeLeg.getSecurity());
            object2 = ebms3UserMessage.getPartyInfo().getTo().getPartyIdAtIndex(0).getValue();
            object = this.m_aIncomingSecurityConfig.getCryptParamsCloneOrNew().setFromPMode(pModeLeg.getSecurity()).setAlias((String)object2);
            iAS4ResponseFactory = this._createResponseUserMessage(iAS4MessageState, pModeLeg.getProtocol().getSoapVersion(), (AS4UserMessage)object3, (ICommonsList<WSS4JAttachment>)iCommonsList2, aS4SigningParams, (AS4CryptParams)object);
        } else {
            object3 = AS4ErrorMessage.create(eSoapVersion, iAS4MessageState.getMessageID(), (ICommonsList<Ebms3Error>)commonsArrayList);
            string2 = ((AS4ErrorMessage)object3).getEbms3SignalMessage().getMessageInfo().getMessageId();
            if (this.m_aErrorConsumer != null && commonsArrayList.isNotEmpty()) {
                this.m_aErrorConsumer.onAS4ErrorMessage(iAS4MessageState, (ICommonsList<Ebms3Error>)commonsArrayList, (AS4ErrorMessage)object3);
            }
            iAS4ResponseFactory = new AS4ResponseFactoryXML(this.m_aMessageMetadata, iAS4MessageState, string2, object3.getAsSoapDocument(), eSoapVersion.getMimeType());
        }
        object3 = sPIInvocationResult.getAsyncResponseURL();
        if (StringHelper.hasNoText((String)object3)) {
            throw new IllegalStateException("No asynchronous response URL present - please check your SPI implementation");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Responding asynchronous to: " + (String)object3);
        }
        aS4SigningParams = iAS4ResponseFactory.getHttpEntityForSending(eSoapVersion.getMimeType());
        aS4SigningParams = this.m_aResHelper.createRepeatableHttpEntity((HttpEntity)aS4SigningParams);
        this._invokeSPIsForResponse(iAS4MessageState, iAS4ResponseFactory, (HttpEntity)aS4SigningParams, eSoapVersion.getMimeType(), string2);
        object2 = new BasicHttpPoster();
        HttpHeaderMap httpHeaderMap2 = null;
        HttpRetrySettings httpRetrySettings = new HttpRetrySettings();
        object = (Document)((BasicHttpPoster)object2).sendGenericMessageWithRetries((String)object3, httpHeaderMap2, (HttpEntity)aS4SigningParams, string, httpRetrySettings, new ResponseHandlerXml(), this.m_aOutgoingDumper, this.m_aRetryCallback);
        AS4HttpDebug.debug(() -> AS4RequestHandler.lambda$_handleSoapMessage$0((Document)object));
    }

    private static /* synthetic */ String lambda$_handleSoapMessage$0(Document document) {
        return "SEND-RESPONSE [async sent] received: " + (document == null ? "null" : XMLWriter.getNodeAsString((Node)document, (IXMLWriterSettings)AS4HttpDebug.getDebugXMLWriterSettings()));
    }

    public static interface ISoapProcessingFinalizedCallback {
        public void onProcessingFinalized(boolean var1);
    }

    private static final class SPIInvocationResult
    implements ISuccessIndicator {
        private boolean m_bSuccess = false;
        private Ebms3UserMessage m_aPullReturnUserMsg;
        private String m_sAsyncResponseURL;

        private SPIInvocationResult() {
        }

        public boolean isSuccess() {
            return this.m_bSuccess;
        }

        void setSuccess(boolean bl) {
            this.m_bSuccess = bl;
        }

        void setPullReturnUserMsg(@Nonnull Ebms3UserMessage ebms3UserMessage) {
            this.m_aPullReturnUserMsg = ebms3UserMessage;
        }

        @Nullable
        public Ebms3UserMessage getPullReturnUserMsg() {
            return this.m_aPullReturnUserMsg;
        }

        public boolean hasPullReturnUserMsg() {
            return this.m_aPullReturnUserMsg != null;
        }

        void setAsyncResponseURL(@Nonnull String string) {
            this.m_sAsyncResponseURL = string;
        }

        @Nullable
        public String getAsyncResponseURL() {
            return this.m_sAsyncResponseURL;
        }

        public boolean hasAsyncResponseURL() {
            return StringHelper.hasText((String)this.m_sAsyncResponseURL);
        }
    }

    private static interface IAS4ResponseFactory {
        @Nonnull
        public HttpEntity getHttpEntityForSending(@Nonnull IMimeType var1);

        public void applyToResponse(@Nonnull IAS4ResponseAbstraction var1, @Nullable IAS4OutgoingDumper var2);
    }

    private static final class AS4ResponseFactoryXML
    implements IAS4ResponseFactory {
        private final IAS4IncomingMessageMetadata m_aIncomingMessageMetadata;
        private final IAS4MessageState m_aState;
        private final String m_sResponseMessageID;
        private final Document m_aDoc;
        private final IMimeType m_aMimeType;

        public AS4ResponseFactoryXML(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull IAS4MessageState iAS4MessageState, @Nonnull @Nonempty String string, @Nonnull Document document, @Nonnull IMimeType iMimeType) {
            ValueEnforcer.notNull((Object)iAS4IncomingMessageMetadata, (String)"IncomingMessageMetadata");
            ValueEnforcer.notNull((Object)iAS4MessageState, (String)"State");
            ValueEnforcer.notEmpty((CharSequence)string, (String)"ResponseMessageID");
            ValueEnforcer.notNull((Object)document, (String)"Doc");
            ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
            this.m_aIncomingMessageMetadata = iAS4IncomingMessageMetadata;
            this.m_aState = iAS4MessageState;
            this.m_sResponseMessageID = string;
            this.m_aDoc = document;
            this.m_aMimeType = iMimeType;
        }

        @Override
        @Nonnull
        public HttpEntity getHttpEntityForSending(@Nonnull IMimeType iMimeType) {
            return new HttpXMLEntity(this.m_aDoc, this.m_aMimeType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyToResponse(@Nonnull IAS4ResponseAbstraction iAS4ResponseAbstraction, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
            block6: {
                String string = AS4XMLHelper.serializeXML(this.m_aDoc);
                Charset charset = AS4XMLHelper.XWS.getCharset();
                byte[] byArray = string.getBytes(charset);
                iAS4ResponseAbstraction.setContent(byArray, charset);
                iAS4ResponseAbstraction.setMimeType(this.m_aMimeType);
                if (iAS4OutgoingDumper != null) {
                    try {
                        OutputStream outputStream = iAS4OutgoingDumper.onBeginRequest(EAS4MessageMode.RESPONSE, this.m_aIncomingMessageMetadata, this.m_aState, this.m_sResponseMessageID, null, 0);
                        if (outputStream == null) break block6;
                        try {
                            outputStream.write(byArray);
                        }
                        finally {
                            StreamHelper.close((AutoCloseable)outputStream);
                            iAS4OutgoingDumper.onEndRequest(EAS4MessageMode.RESPONSE, this.m_aIncomingMessageMetadata, this.m_aState, this.m_sResponseMessageID);
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.warn("IOException in dumping of outgoing XML response", (Throwable)iOException);
                    }
                }
            }
        }
    }

    private static final class AS4ResponseFactoryMIME
    implements IAS4ResponseFactory {
        private final IAS4IncomingMessageMetadata m_aIncomingMessageMetadata;
        private final IAS4MessageState m_aState;
        private final String m_sResponseMessageID;
        private final AS4MimeMessage m_aMimeMsg;
        private final HttpHeaderMap m_aHttpHeaders;

        public AS4ResponseFactoryMIME(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull IAS4MessageState iAS4MessageState, @Nonnull @Nonempty String string, @Nonnull AS4MimeMessage aS4MimeMessage) throws MessagingException {
            ValueEnforcer.notNull((Object)iAS4IncomingMessageMetadata, (String)"IncomingMessageMetadata");
            ValueEnforcer.notNull((Object)iAS4MessageState, (String)"State");
            ValueEnforcer.notEmpty((CharSequence)string, (String)"ResponseMessageID");
            ValueEnforcer.notNull((Object)((Object)aS4MimeMessage), (String)"MimeMsg");
            this.m_aIncomingMessageMetadata = iAS4IncomingMessageMetadata;
            this.m_aState = iAS4MessageState;
            this.m_sResponseMessageID = string;
            this.m_aMimeMsg = aS4MimeMessage;
            this.m_aHttpHeaders = MessageHelperMethods.getAndRemoveAllHeaders(this.m_aMimeMsg);
            if (!aS4MimeMessage.isRepeatable()) {
                LOGGER.warn("The response MIME message is not repeatable");
            }
        }

        @Nonnull
        public HttpMimeMessageEntity getHttpEntityForSending(@Nonnull IMimeType iMimeType) {
            return HttpMimeMessageEntity.create(this.m_aMimeMsg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyToResponse(@Nonnull IAS4ResponseAbstraction iAS4ResponseAbstraction, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
            block6: {
                HasInputStream hasInputStream = HasInputStream.multiple(() -> {
                    try {
                        return this.m_aMimeMsg.getInputStream();
                    }
                    catch (MessagingException | IOException throwable) {
                        throw new IllegalStateException("Failed to get MIME input stream", throwable);
                    }
                });
                iAS4ResponseAbstraction.setContent(this.m_aHttpHeaders, (IHasInputStream)hasInputStream);
                iAS4ResponseAbstraction.setMimeType(MT_MULTIPART_RELATED);
                if (iAS4OutgoingDumper != null) {
                    try {
                        OutputStream outputStream = iAS4OutgoingDumper.onBeginRequest(EAS4MessageMode.RESPONSE, this.m_aIncomingMessageMetadata, this.m_aState, this.m_sResponseMessageID, this.m_aHttpHeaders, 0);
                        if (outputStream == null) break block6;
                        try {
                            StreamHelper.copyInputStreamToOutputStream((InputStream)hasInputStream.getBufferedInputStream(), (OutputStream)outputStream);
                        }
                        finally {
                            StreamHelper.close((AutoCloseable)outputStream);
                            iAS4OutgoingDumper.onEndRequest(EAS4MessageMode.RESPONSE, this.m_aIncomingMessageMetadata, this.m_aState, this.m_sResponseMessageID);
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.warn("IOException in dumping of outgoing MIME response", (Throwable)iOException);
                    }
                }
            }
        }
    }
}

