/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.mgr;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.profile.IAS4Profile;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class AS4ProfileSelector {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static String s_sAS4ProfileID;

    private AS4ProfileSelector() {
    }

    @Nullable
    public static String getCustomAS4ProfileID() {
        return (String)RW_LOCK.readLockedGet(() -> s_sAS4ProfileID);
    }

    public static void setCustomAS4ProfileID(@Nullable String string) {
        RW_LOCK.writeLocked(() -> {
            s_sAS4ProfileID = string;
        });
    }

    @Nullable
    public static String getAS4ProfileID() {
        IAS4Profile iAS4Profile;
        String string = AS4ProfileSelector.getCustomAS4ProfileID();
        if (string == null && (string = AS4Configuration.getAS4ProfileID()) == null && (iAS4Profile = MetaAS4Manager.getProfileMgr().getDefaultProfileOrNull()) != null) {
            string = (String)iAS4Profile.getID();
        }
        return string;
    }
}

