/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.util;

import com.helger.commons.ValueEnforcer;
import java.io.IOException;
import java.io.OutputStream;

public class MultiOutputStream
extends OutputStream {
    private final OutputStream[] m_aOSs;

    public MultiOutputStream(OutputStream ... outputStreamArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])outputStreamArray, (String)"OutputStreams");
        this.m_aOSs = outputStreamArray;
    }

    @Override
    public void write(int n) throws IOException {
        for (OutputStream outputStream : this.m_aOSs) {
            outputStream.write(n);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (OutputStream outputStream : this.m_aOSs) {
            outputStream.write(byArray, n, n2);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream outputStream : this.m_aOSs) {
            outputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (OutputStream outputStream : this.m_aOSs) {
            outputStream.close();
        }
    }
}

