/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.phase4.client.AS4ClientBuiltMessage;
import com.helger.phase4.client.AbstractAS4ClientSignalMessage;
import com.helger.phase4.client.IAS4ClientBuildMessageCallback;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.error.IEbmsError;
import com.helger.phase4.http.HttpXMLEntity;
import com.helger.phase4.messaging.crypto.AS4Signer;
import com.helger.phase4.messaging.domain.AS4ErrorMessage;
import com.helger.phase4.messaging.domain.EAS4MessageType;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.util.AS4ResourceHelper;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.w3c.dom.Document;

public class AS4ClientErrorMessage
extends AbstractAS4ClientSignalMessage<AS4ClientErrorMessage> {
    private final ICommonsList<Ebms3Error> m_aErrorMessages = new CommonsArrayList();
    private boolean m_bErrorShouldBeSigned = false;

    public AS4ClientErrorMessage(@Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) {
        super(EAS4MessageType.ERROR_MESSAGE, aS4ResourceHelper);
    }

    public final void addErrorMessage(@Nonnull IEbmsError iEbmsError, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)iEbmsError, (String)"Error");
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        this.m_aErrorMessages.add((Object)iEbmsError.errorBuilder(locale).refToMessageInError(this.getRefToMessageID()).build());
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<Ebms3Error> errorMessages() {
        return this.m_aErrorMessages;
    }

    public final boolean isReceiptShouldBeSigned() {
        return this.m_bErrorShouldBeSigned;
    }

    @Nonnull
    public final AS4ClientErrorMessage setErrorShouldBeSigned(boolean bl) {
        this.m_bErrorShouldBeSigned = bl;
        return this;
    }

    private void _checkMandatoryAttributes() {
        if (this.m_aErrorMessages.isEmpty()) {
            throw new IllegalStateException("No Errors specified!");
        }
        if (this.m_aErrorMessages.containsAny(Objects::isNull)) {
            throw new IllegalStateException("Errors may not contain null elements.");
        }
        if (!this.hasRefToMessageID()) {
            throw new IllegalStateException("No reference to a message set.");
        }
    }

    @Override
    public AS4ClientBuiltMessage buildMessage(@Nonnull @Nonempty String string, @Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback) throws WSSecurityException {
        Document document;
        this._checkMandatoryAttributes();
        Ebms3MessageInfo ebms3MessageInfo = MessageHelperMethods.createEbms3MessageInfo(string, this.getRefToMessageID(), ((AS4ClientErrorMessage)this.ensureSendingDateTime()).getSendingDateTime());
        AS4ErrorMessage aS4ErrorMessage = AS4ErrorMessage.create(this.getSoapVersion(), ebms3MessageInfo, this.m_aErrorMessages);
        if (iAS4ClientBuildMessageCallback != null) {
            iAS4ClientBuildMessageCallback.onAS4Message(aS4ErrorMessage);
        }
        Document document2 = aS4ErrorMessage.getAsSoapDocument();
        if (iAS4ClientBuildMessageCallback != null) {
            iAS4ClientBuildMessageCallback.onSoapDocument(document2);
        }
        if (this.m_bErrorShouldBeSigned && this.signingParams().isSigningEnabled()) {
            IAS4CryptoFactory iAS4CryptoFactory = this.internalGetCryptoFactorySign();
            Document document3 = AS4Signer.createSignedMessage(iAS4CryptoFactory, document2, this.getSoapVersion(), aS4ErrorMessage.getMessagingID(), null, this.getAS4ResourceHelper(), true, this.signingParams().getClone());
            if (iAS4ClientBuildMessageCallback != null) {
                iAS4ClientBuildMessageCallback.onSignedSoapDocument(document3);
            }
            document = document3;
        } else {
            document = document2;
        }
        return new AS4ClientBuiltMessage(string, new HttpXMLEntity(document, this.getSoapVersion().getMimeType()));
    }
}

