/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.client.AS4ClientBuiltMessage;
import com.helger.phase4.client.AbstractAS4Client;
import com.helger.phase4.client.IAS4ClientBuildMessageCallback;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.ebms3header.Ebms3CollaborationInfo;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.ebms3header.Ebms3MessageProperties;
import com.helger.phase4.ebms3header.Ebms3PartyInfo;
import com.helger.phase4.ebms3header.Ebms3PayloadInfo;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.http.AS4HttpDebug;
import com.helger.phase4.http.HttpMimeMessageEntity;
import com.helger.phase4.http.HttpXMLEntity;
import com.helger.phase4.messaging.crypto.AS4Encryptor;
import com.helger.phase4.messaging.crypto.AS4Signer;
import com.helger.phase4.messaging.domain.AS4UserMessage;
import com.helger.phase4.messaging.domain.EAS4MessageType;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.messaging.mime.AS4MimeMessage;
import com.helger.phase4.messaging.mime.MimeMessageCreator;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import jakarta.mail.MessagingException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public class AS4ClientUserMessage
extends AbstractAS4Client<AS4ClientUserMessage> {
    public static final boolean DEFAULT_FORCE_MIME_MESSAGE = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4ClientUserMessage.class);
    private Node m_aSoapBodyPayload;
    private final ICommonsList<WSS4JAttachment> m_aAttachments = new CommonsArrayList();
    private boolean m_bForceMimeMessage = false;
    private final ICommonsList<Ebms3Property> m_aEbms3Properties = new CommonsArrayList();
    private String m_sAction;
    private String m_sServiceType;
    private String m_sServiceValue;
    private String m_sConversationID;
    private String m_sAgreementRefValue;
    private String m_sAgreementTypeValue;
    private String m_sFromRole = "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/defaultRole";
    private String m_sFromPartyIDType;
    private String m_sFromPartyIDValue;
    private String m_sToRole = "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/defaultRole";
    private String m_sToPartyIDType;
    private String m_sToPartyIDValue;
    private boolean m_bUseLeg1 = true;
    private IPMode m_aPMode;
    private Function<AS4ClientUserMessage, String> m_aPModeIDFactory = aS4ClientUserMessage -> aS4ClientUserMessage.getFromPartyID() + "-" + aS4ClientUserMessage.getToPartyID();

    public AS4ClientUserMessage(@Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) {
        super(EAS4MessageType.USER_MESSAGE, aS4ResourceHelper);
    }

    @Nullable
    public final Node getPayload() {
        return this.m_aSoapBodyPayload;
    }

    @Nonnull
    public final AS4ClientUserMessage setPayload(@Nullable Node node) {
        this.m_aSoapBodyPayload = node;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<WSS4JAttachment> attachments() {
        return this.m_aAttachments;
    }

    public final boolean isForceMimeMessage() {
        return this.m_bForceMimeMessage;
    }

    @Nonnull
    public final AS4ClientUserMessage setForceMimeMessage(boolean bl) {
        this.m_bForceMimeMessage = bl;
        return this;
    }

    @Nonnull
    public final AS4ClientUserMessage addAttachment(@Nonnull File file, @Nonnull IMimeType iMimeType, @Nullable EAS4CompressionMode eAS4CompressionMode) throws IOException {
        ValueEnforcer.notNull((Object)file, (String)"Attachment");
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        return this.addAttachment(WSS4JAttachment.createOutgoingFileAttachment(file, FilenameHelper.getWithoutPath((File)file), (String)null, iMimeType, eAS4CompressionMode, (Charset)null, this.getAS4ResourceHelper()));
    }

    @Nonnull
    public final AS4ClientUserMessage addAttachment(@Nonnull WSS4JAttachment wSS4JAttachment) {
        ValueEnforcer.notNull((Object)wSS4JAttachment, (String)"Attachment");
        this.m_aAttachments.add((Object)wSS4JAttachment);
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<Ebms3Property> ebms3Properties() {
        return this.m_aEbms3Properties;
    }

    @Nullable
    public final String getAction() {
        return this.m_sAction;
    }

    @Nonnull
    public final AS4ClientUserMessage setAction(@Nullable String string) {
        this.m_sAction = string;
        return this;
    }

    @Nullable
    public final String getServiceType() {
        return this.m_sServiceType;
    }

    @Nonnull
    public final AS4ClientUserMessage setServiceType(@Nullable String string) {
        this.m_sServiceType = string;
        return this;
    }

    @Nullable
    public final String getServiceValue() {
        return this.m_sServiceValue;
    }

    @Nonnull
    public final AS4ClientUserMessage setServiceValue(@Nullable String string) {
        this.m_sServiceValue = string;
        return this;
    }

    @Nullable
    public final String getConversationID() {
        return this.m_sConversationID;
    }

    @Nonnull
    public final AS4ClientUserMessage setConversationID(@Nullable String string) {
        this.m_sConversationID = string;
        return this;
    }

    @Nullable
    public final String getAgreementRefValue() {
        return this.m_sAgreementRefValue;
    }

    @Nonnull
    public final AS4ClientUserMessage setAgreementRefValue(@Nullable String string) {
        this.m_sAgreementRefValue = string;
        return this;
    }

    @Nullable
    public final String getAgreementTypeValue() {
        return this.m_sAgreementTypeValue;
    }

    @Nonnull
    public final AS4ClientUserMessage setAgreementTypeValue(@Nullable String string) {
        this.m_sAgreementTypeValue = string;
        return this;
    }

    @Nullable
    public final String getFromRole() {
        return this.m_sFromRole;
    }

    @Nonnull
    public final AS4ClientUserMessage setFromRole(@Nullable String string) {
        this.m_sFromRole = string;
        return this;
    }

    @Nullable
    public final String getFromPartyIDType() {
        return this.m_sFromPartyIDType;
    }

    @Nonnull
    public final AS4ClientUserMessage setFromPartyIDType(@Nullable String string) {
        this.m_sFromPartyIDType = string;
        return this;
    }

    @Nullable
    public final String getFromPartyID() {
        return this.m_sFromPartyIDValue;
    }

    @Nonnull
    public final AS4ClientUserMessage setFromPartyID(@Nullable String string) {
        this.m_sFromPartyIDValue = string;
        return this;
    }

    @Nullable
    public final String getToRole() {
        return this.m_sToRole;
    }

    @Nonnull
    public final AS4ClientUserMessage setToRole(@Nullable String string) {
        this.m_sToRole = string;
        return this;
    }

    @Nullable
    public final String getToPartyIDType() {
        return this.m_sToPartyIDType;
    }

    @Nonnull
    public final AS4ClientUserMessage setToPartyIDType(@Nullable String string) {
        this.m_sToPartyIDType = string;
        return this;
    }

    @Nullable
    public final String getToPartyID() {
        return this.m_sToPartyIDValue;
    }

    @Nonnull
    public final AS4ClientUserMessage setToPartyID(@Nullable String string) {
        this.m_sToPartyIDValue = string;
        return this;
    }

    public final boolean isUseLeg1() {
        return this.m_bUseLeg1;
    }

    @Nonnull
    public final AS4ClientUserMessage setUseLeg1(boolean bl) {
        this.m_bUseLeg1 = bl;
        return this;
    }

    @Nullable
    public final IPMode getPMode() {
        return this.m_aPMode;
    }

    public final void setUserMessageValuesFromPMode(@Nonnull IPMode iPMode, @Nonnull PModeLeg pModeLeg) {
        ValueEnforcer.notNull((Object)iPMode, (String)"PMode");
        ValueEnforcer.notNull((Object)pModeLeg, (String)"EffectiveLeg");
        if (pModeLeg.hasBusinessInfo()) {
            this.setAction(pModeLeg.getBusinessInfo().getAction());
            this.setServiceValue(pModeLeg.getBusinessInfo().getService());
            this.setServiceType(pModeLeg.getBusinessInfo().getServiceType());
        } else {
            this.setAction(null);
            this.setServiceValue(null);
            this.setServiceType(null);
        }
        this.setAgreementRefValue(iPMode.getAgreement());
        if (iPMode.hasInitiator()) {
            this.setFromRole(iPMode.getInitiator().getRole());
            this.setFromPartyIDType(iPMode.getInitiator().getIDType());
            this.setFromPartyID(iPMode.getInitiator().getIDValue());
        } else {
            this.setFromRole(null);
            this.setFromPartyIDType(null);
            this.setFromPartyID(null);
        }
        if (iPMode.hasResponder()) {
            this.setToRole(iPMode.getResponder().getRole());
            this.setToPartyIDType(iPMode.getResponder().getIDType());
            this.setToPartyID(iPMode.getResponder().getIDValue());
        } else {
            this.setToRole(null);
            this.setToPartyIDType(null);
            this.setToPartyID(null);
        }
        this.setValuesFromPMode(iPMode, pModeLeg);
    }

    public final void setPMode(@Nullable IPMode iPMode, boolean bl) {
        this.m_aPMode = iPMode;
        if (iPMode != null && bl) {
            PModeLeg pModeLeg;
            PModeLeg pModeLeg2 = pModeLeg = this.m_bUseLeg1 ? iPMode.getLeg1() : iPMode.getLeg2();
            if (pModeLeg != null) {
                this.setUserMessageValuesFromPMode(iPMode, pModeLeg);
            }
        }
    }

    @Nonnull
    public final Function<AS4ClientUserMessage, String> getPModeIDFactory() {
        return this.m_aPModeIDFactory;
    }

    @Nonnull
    public final AS4ClientUserMessage setPModeID(@Nullable String string) {
        return this.setPModeIDFactory(aS4ClientUserMessage -> string);
    }

    @Nonnull
    public final AS4ClientUserMessage setPModeIDFactory(@Nonnull Function<AS4ClientUserMessage, String> function) {
        ValueEnforcer.notNull(function, (String)"PModeIDFactory");
        this.m_aPModeIDFactory = function;
        return this;
    }

    private void _checkMandatoryAttributes() {
        if (StringHelper.hasNoText((String)this.m_sAction)) {
            throw new IllegalStateException("Action needs to be set");
        }
        if (StringHelper.hasNoText((String)this.m_sServiceValue)) {
            throw new IllegalStateException("ServiceValue needs to be set");
        }
        if (this.m_sConversationID == null) {
            throw new IllegalStateException("ConversationID needs to be set (but may be empty)");
        }
        if (StringHelper.hasNoText((String)this.m_sFromRole)) {
            throw new IllegalStateException("FromRole needs to be set");
        }
        if (StringHelper.hasNoText((String)this.m_sFromPartyIDValue)) {
            throw new IllegalStateException("FromPartyID needs to be set");
        }
        if (StringHelper.hasNoText((String)this.m_sToRole)) {
            throw new IllegalStateException("ToRole needs to be set");
        }
        if (StringHelper.hasNoText((String)this.m_sToPartyIDValue)) {
            throw new IllegalStateException("ToPartyID needs to be set");
        }
    }

    @Override
    @Nonnull
    public AS4ClientBuiltMessage buildMessage(@Nonnull @Nonempty String string, @Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback) throws WSSecurityException, MessagingException {
        Object object;
        LOGGER.info("phase4 --- usermessage-building:start");
        String string2 = this.m_aPModeIDFactory.apply(this);
        this._checkMandatoryAttributes();
        boolean bl = this.signingParams().isSigningEnabled();
        boolean bl2 = this.cryptParams().isCryptEnabled(arg_0 -> ((Logger)LOGGER).warn(arg_0));
        boolean bl3 = this.m_aSoapBodyPayload != null;
        boolean bl4 = this.m_aAttachments.isNotEmpty();
        Ebms3MessageInfo ebms3MessageInfo = MessageHelperMethods.createEbms3MessageInfo(string, this.getRefToMessageID(), ((AS4ClientUserMessage)this.ensureSendingDateTime()).getSendingDateTime());
        Ebms3PayloadInfo ebms3PayloadInfo = MessageHelperMethods.createEbms3PayloadInfo(this.m_aSoapBodyPayload != null, this.m_aAttachments);
        Ebms3CollaborationInfo ebms3CollaborationInfo = MessageHelperMethods.createEbms3CollaborationInfo(string2, this.m_sAgreementRefValue, this.m_sAgreementTypeValue, this.m_sServiceType, this.m_sServiceValue, this.m_sAction, this.m_sConversationID);
        Ebms3PartyInfo ebms3PartyInfo = MessageHelperMethods.createEbms3PartyInfo(this.m_sFromRole, this.m_sFromPartyIDType, this.m_sFromPartyIDValue, this.m_sToRole, this.m_sToPartyIDType, this.m_sToPartyIDValue);
        Ebms3MessageProperties ebms3MessageProperties = MessageHelperMethods.createEbms3MessageProperties(this.m_aEbms3Properties);
        AS4UserMessage aS4UserMessage = (AS4UserMessage)AS4UserMessage.create(ebms3MessageInfo, ebms3PayloadInfo, ebms3CollaborationInfo, ebms3PartyInfo, ebms3MessageProperties, null, this.getSoapVersion()).setMustUnderstand(true);
        if (iAS4ClientBuildMessageCallback != null) {
            iAS4ClientBuildMessageCallback.onAS4Message(aS4UserMessage);
        }
        Document document = aS4UserMessage.getAsSoapDocument(this.m_aSoapBodyPayload);
        if (iAS4ClientBuildMessageCallback != null) {
            iAS4ClientBuildMessageCallback.onSoapDocument(document);
        }
        Document document2 = document;
        AS4MimeMessage aS4MimeMessage = null;
        if (bl || bl2) {
            Document document3;
            AS4HttpDebug.debug(() -> "Unsigned/unencrypted UserMessage:\n" + XMLWriter.getNodeAsString((Node)document, (IXMLWriterSettings)AS4HttpDebug.getDebugXMLWriterSettings()));
            if (bl) {
                object = this.internalGetCryptoFactorySign();
                document2 = document3 = AS4Signer.createSignedMessage((IAS4CryptoFactory)object, document2, this.getSoapVersion(), aS4UserMessage.getMessagingID(), this.m_aAttachments, this.getAS4ResourceHelper(), true, this.signingParams().getClone());
                if (iAS4ClientBuildMessageCallback != null) {
                    iAS4ClientBuildMessageCallback.onSignedSoapDocument(document3);
                }
                AS4HttpDebug.debug(() -> "Signed UserMessage:\n" + XMLWriter.getNodeAsString((Node)document3, (IXMLWriterSettings)AS4HttpDebug.getDebugXMLWriterSettings()));
            }
            if (bl2) {
                object = this.internalGetCryptoFactoryCrypt();
                if (bl4) {
                    aS4MimeMessage = AS4Encryptor.encryptToMimeMessage(this.getSoapVersion(), document2, this.m_aAttachments, (IAS4CryptoFactory)object, true, this.getAS4ResourceHelper(), this.cryptParams().getClone());
                    if (iAS4ClientBuildMessageCallback != null) {
                        iAS4ClientBuildMessageCallback.onEncryptedMimeMessage(aS4MimeMessage);
                    }
                } else if (bl3) {
                    document3 = AS4Encryptor.encryptSoapBodyPayload((IAS4CryptoFactory)object, this.getSoapVersion(), document2, true, this.cryptParams().getClone());
                    if (iAS4ClientBuildMessageCallback != null) {
                        iAS4ClientBuildMessageCallback.onEncryptedSoapDocument(document3);
                    }
                    document2 = document3;
                } else {
                    LOGGER.info("AS4 encryption is enabled but neither a SOAP Body payload nor attachments are present");
                }
            }
        }
        if ((bl4 || this.m_bForceMimeMessage) && aS4MimeMessage == null) {
            aS4MimeMessage = MimeMessageCreator.generateMimeMessage(this.getSoapVersion(), document2, this.m_aAttachments);
        }
        object = aS4MimeMessage != null ? new AS4ClientBuiltMessage(string, HttpMimeMessageEntity.create(aS4MimeMessage)) : new AS4ClientBuiltMessage(string, new HttpXMLEntity(document2, this.getSoapVersion().getMimeType()));
        LOGGER.info("phase4 --- usermessage-building:end");
        return object;
    }
}

