/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.config;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.IResourceBase;
import com.helger.commons.io.resourceprovider.ReadableResourceProviderChain;
import com.helger.commons.string.StringParser;
import com.helger.config.Config;
import com.helger.config.ConfigFactory;
import com.helger.config.IConfig;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.config.source.res.ConfigurationSourceProperties;
import com.helger.config.value.IConfigurationValueProvider;
import java.io.File;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AS4Configuration {
    public static final String PROPERTY_PHASE4_MANAGER_INMEMORY = "phase4.manager.inmemory";
    public static final boolean DEFAULT_PHASE4_MANAGER_INMEMORY = true;
    public static final String PROPERTY_PHASE4_WSS4J_SYNCSECURITY = "phase4.wss4j.syncsecurity";
    public static final boolean DEFAULT_PHASE4_WSS4J_SYNCSECURITY = false;
    public static final long DEFAULT_PHASE4_INCOMING_DUPLICATEDISPOSAL_MINUTES = 10L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4Configuration.class);
    private static final MultiConfigurationValueProvider VP = AS4Configuration.createPhase4ValueProvider();
    private static final IConfig DEFAULT_INSTANCE = Config.create((IConfigurationValueProvider)VP);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static IConfig s_aConfig = DEFAULT_INSTANCE;

    @Nonnull
    public static MultiConfigurationValueProvider createPhase4ValueProvider() {
        MultiConfigurationValueProvider multiConfigurationValueProvider = ConfigFactory.createDefaultValueProvider();
        int n = EConfigSourceType.RESOURCE.getDefaultPriority();
        ReadableResourceProviderChain readableResourceProviderChain = ConfigFactory.createDefaultResourceProviderChain();
        IReadableResource iReadableResource = readableResourceProviderChain.getReadableResourceIf("private-phase4.properties", IResourceBase::exists);
        if (iReadableResource != null) {
            multiConfigurationValueProvider.addConfigurationSource((IConfigurationValueProvider)new ConfigurationSourceProperties(iReadableResource, StandardCharsets.UTF_8), n + 4);
        }
        if ((iReadableResource = readableResourceProviderChain.getReadableResourceIf("phase4.properties", IResourceBase::exists)) != null) {
            multiConfigurationValueProvider.addConfigurationSource((IConfigurationValueProvider)new ConfigurationSourceProperties(iReadableResource, StandardCharsets.UTF_8), n + 3);
        }
        return multiConfigurationValueProvider;
    }

    private AS4Configuration() {
    }

    @Nonnull
    public static IConfig getConfig() {
        RW_LOCK.readLock().lock();
        try {
            IConfig iConfig = s_aConfig;
            return iConfig;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    @Nonnull
    public static IConfig setConfig(@Nonnull IConfig iConfig) {
        IConfig iConfig2;
        ValueEnforcer.notNull((Object)iConfig, (String)"NewConfig");
        RW_LOCK.writeLock().lock();
        try {
            iConfig2 = s_aConfig;
            s_aConfig = iConfig;
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
        if (!EqualsHelper.identityEqual((Object)iConfig2, (Object)iConfig)) {
            LOGGER.info("The phase4 configuration provider was changed to " + String.valueOf(iConfig));
        }
        return iConfig2;
    }

    public static boolean isGlobalDebug() {
        return AS4Configuration.getConfig().getAsBoolean((Object)"global.debug", false);
    }

    public static boolean isGlobalProduction() {
        return AS4Configuration.getConfig().getAsBoolean((Object)"global.production", false);
    }

    public static boolean isNoStartupInfo() {
        return AS4Configuration.getConfig().getAsBoolean((Object)"global.nostartupinfo", true);
    }

    @Nonnull
    public static String getDataPath() {
        return AS4Configuration.getConfig().getAsString((Object)"global.datapath", "phase4-data");
    }

    public static boolean isUseInMemoryManagers() {
        String string = AS4Configuration.getConfig().getAsString((Object)PROPERTY_PHASE4_MANAGER_INMEMORY);
        return StringParser.parseBool((String)string, (boolean)true);
    }

    public static boolean isWSS4JSynchronizedSecurity() {
        String string = AS4Configuration.getConfig().getAsString((Object)PROPERTY_PHASE4_WSS4J_SYNCSECURITY);
        return StringParser.parseBool((String)string, (boolean)false);
    }

    @Nullable
    public static String getAS4ProfileID() {
        return AS4Configuration.getConfig().getAsString((Object)"phase4.profile");
    }

    public static long getIncomingDuplicateDisposalMinutes() {
        return AS4Configuration.getConfig().getAsLong((Object)"phase4.incoming.duplicatedisposal.minutes", 10L);
    }

    @Nonnull
    public static String getDumpBasePath() {
        return AS4Configuration.getConfig().getAsString((Object)"phase4.dump.path", "phase4-dumps");
    }

    @Nonnull
    public static File getDumpBasePathFile() {
        return new File(AS4Configuration.getDumpBasePath()).getAbsoluteFile();
    }

    @Nullable
    public static String getThisEndpointAddress() {
        return AS4Configuration.getConfig().getAsString((Object)"phase4.endpoint.address");
    }

    public static boolean isIncludeStackTraceInErrorMessages() {
        return AS4Configuration.getConfig().getAsBoolean((Object)"phase4.errormsg.include.stacktraces", true);
    }
}

