/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.phase4.crypto.AbstractAS4CryptoFactory;
import com.helger.phase4.crypto.ECryptoMode;
import java.security.KeyStore;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;

@Immutable
public class AS4CryptoFactoryInMemoryKeyStore
extends AbstractAS4CryptoFactory {
    private final KeyStore m_aKeyStore;
    private final String m_sKeyAlias;
    private final String m_sKeyPassword;
    private final KeyStore m_aTrustStore;
    private Merlin m_aCrypto;

    public AS4CryptoFactoryInMemoryKeyStore(@Nonnull KeyStore keyStore, @Nonnull @Nonempty String string, @Nonnull String string2, @Nullable KeyStore keyStore2) {
        ValueEnforcer.notNull((Object)keyStore, (String)"KeyStore");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"KeyAlias");
        ValueEnforcer.notNull((Object)string2, (String)"KeyPassword");
        this.m_aKeyStore = keyStore;
        this.m_sKeyAlias = string;
        this.m_sKeyPassword = string2;
        this.m_aTrustStore = keyStore2;
    }

    @Override
    @Nonnull
    public final Crypto getCrypto(@Nonnull ECryptoMode eCryptoMode) {
        Merlin merlin = this.m_aCrypto;
        if (merlin == null) {
            merlin = this.m_aCrypto = new Merlin(this.m_aTrustStore == null, "changeit");
            merlin.setKeyStore(this.m_aKeyStore);
            merlin.setTrustStore(this.m_aTrustStore);
        }
        return merlin;
    }

    @Override
    @Nonnull
    public final KeyStore getKeyStore() {
        return this.m_aKeyStore;
    }

    @Override
    @Nonnull
    public final String getKeyAlias() {
        return this.m_sKeyAlias;
    }

    @Override
    @Nonnull
    @Deprecated
    public final String getKeyPassword() {
        return this.m_sKeyPassword;
    }

    @Override
    @Nullable
    public String getKeyPasswordPerAlias(@Nullable String string) {
        if (this.m_sKeyAlias != null && string != null && this.m_sKeyAlias.equalsIgnoreCase(string)) {
            return this.m_sKeyPassword;
        }
        return null;
    }

    @Override
    @Nullable
    public final KeyStore getTrustStore() {
        return this.m_aTrustStore;
    }
}

