/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.lang.NonBlockingProperties;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import com.helger.config.IConfig;
import com.helger.phase4.config.AS4Configuration;
import com.helger.security.keystore.EKeyStoreType;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.wss4j.common.crypto.Merlin;

@Immutable
public class AS4CryptoProperties
implements Serializable,
ICloneable<AS4CryptoProperties> {
    public static final String CRYPTO_PROVIDER = "org.apache.wss4j.crypto.provider";
    public static final String KEYSTORE_TYPE = "org.apache.wss4j.crypto.merlin.keystore.type";
    public static final String KEYSTORE_FILE = "org.apache.wss4j.crypto.merlin.keystore.file";
    public static final String KEYSTORE_PASSWORD = "org.apache.wss4j.crypto.merlin.keystore.password";
    public static final String KEY_ALIAS = "org.apache.wss4j.crypto.merlin.keystore.alias";
    public static final String KEY_PASSWORD = "org.apache.wss4j.crypto.merlin.keystore.private.password";
    public static final String LOAD_CACERTS = "org.apache.wss4j.crypto.merlin.load.cacerts";
    public static final String TRUSTSTORE_PROVIDER = "org.apache.wss4j.crypto.merlin.truststore.provider";
    public static final String TRUSTSTORE_TYPE = "org.apache.wss4j.crypto.merlin.truststore.type";
    public static final String TRUSTSTORE_FILE = "org.apache.wss4j.crypto.merlin.truststore.file";
    public static final String TRUSTSTORE_PASSWORD = "org.apache.wss4j.crypto.merlin.truststore.password";
    public static final EKeyStoreType DEFAULT_KEYSTORE_TYPE = EKeyStoreType.JKS;
    public static final EKeyStoreType DEFAULT_TRUSTSTORE_TYPE = EKeyStoreType.JKS;
    private NonBlockingProperties m_aProps;

    public AS4CryptoProperties() {
        this.m_aProps = new NonBlockingProperties();
        this.setCryptoProviderDefault();
    }

    public AS4CryptoProperties(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        if (iReadableResource.exists()) {
            try {
                this.m_aProps = new NonBlockingProperties();
                try (InputStream inputStream = iReadableResource.getInputStream();){
                    this.m_aProps.load(inputStream);
                }
            }
            catch (Exception exception) {
                throw new InitializationException("Failed to init CryptoProperties from resource " + String.valueOf(iReadableResource) + "!", (Throwable)exception);
            }
        }
    }

    public final boolean isRead() {
        return this.m_aProps != null;
    }

    @Nullable
    public Properties getAsProperties() {
        if (this.m_aProps == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.m_aProps);
        return properties;
    }

    @Nullable
    private String _getProperty(@Nonnull String string) {
        NonBlockingProperties nonBlockingProperties = this.m_aProps;
        return nonBlockingProperties == null ? null : nonBlockingProperties.getProperty(string);
    }

    private void _setProperty(@Nonnull String string, @Nullable String string2) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        NonBlockingProperties nonBlockingProperties = this.m_aProps;
        if (string2 == null) {
            if (nonBlockingProperties != null) {
                nonBlockingProperties.remove((Object)string);
            }
        } else {
            if (nonBlockingProperties == null) {
                nonBlockingProperties = this.m_aProps = new NonBlockingProperties();
            }
            nonBlockingProperties.put((Object)string, (Object)string2);
        }
    }

    @Nullable
    public String getCryptoProvider() {
        return this._getProperty(CRYPTO_PROVIDER);
    }

    @Nonnull
    public final AS4CryptoProperties setCryptoProvider(@Nullable String string) {
        this._setProperty(CRYPTO_PROVIDER, string);
        return this;
    }

    @Nonnull
    public final AS4CryptoProperties setCryptoProviderDefault() {
        return this.setCryptoProvider(Merlin.class.getName());
    }

    @Nonnull
    public EKeyStoreType getKeyStoreType() {
        String string = this._getProperty(KEYSTORE_TYPE);
        return EKeyStoreType.getFromIDCaseInsensitiveOrDefault((String)string, (EKeyStoreType)DEFAULT_KEYSTORE_TYPE);
    }

    @Nonnull
    public final AS4CryptoProperties setKeyStoreType(@Nullable EKeyStoreType eKeyStoreType) {
        this._setProperty(KEYSTORE_TYPE, eKeyStoreType == null ? null : eKeyStoreType.getID());
        return this;
    }

    @Nullable
    public String getKeyStorePath() {
        return this._getProperty(KEYSTORE_FILE);
    }

    @Nonnull
    public final AS4CryptoProperties setKeyStorePath(@Nullable String string) {
        this._setProperty(KEYSTORE_FILE, string);
        return this;
    }

    @Nullable
    public String getKeyStorePassword() {
        return this._getProperty(KEYSTORE_PASSWORD);
    }

    @Nullable
    public char[] getKeyStorePasswordCharArray() {
        String string = this.getKeyStorePassword();
        return string == null ? null : string.toCharArray();
    }

    @Nonnull
    public final AS4CryptoProperties setKeyStorePassword(@Nullable String string) {
        this._setProperty(KEYSTORE_PASSWORD, string);
        return this;
    }

    @Nullable
    public String getKeyAlias() {
        return this._getProperty(KEY_ALIAS);
    }

    @Nonnull
    public final AS4CryptoProperties setKeyAlias(@Nullable String string) {
        this._setProperty(KEY_ALIAS, string);
        return this;
    }

    @Nullable
    public String getKeyPassword() {
        return this._getProperty(KEY_PASSWORD);
    }

    @Nullable
    public char[] getKeyPasswordCharArray() {
        String string = this.getKeyPassword();
        return string == null ? null : string.toCharArray();
    }

    @Nonnull
    public final AS4CryptoProperties setKeyPassword(@Nullable String string) {
        this._setProperty(KEY_PASSWORD, string);
        return this;
    }

    @Nonnull
    public ETriState getLoadCACerts() {
        String string = this._getProperty(LOAD_CACERTS);
        return string == null ? ETriState.UNDEFINED : ETriState.valueOf((boolean)StringParser.parseBool((String)string));
    }

    @Nonnull
    public final AS4CryptoProperties setLoadCACerts(boolean bl) {
        this._setProperty(LOAD_CACERTS, Boolean.toString(bl));
        return this;
    }

    @Nullable
    public String getTrustStoreProvider() {
        return this._getProperty(TRUSTSTORE_PROVIDER);
    }

    @Nonnull
    public final AS4CryptoProperties setTrustStoreProvider(@Nullable String string) {
        this._setProperty(TRUSTSTORE_PROVIDER, string);
        return this;
    }

    @Nonnull
    public EKeyStoreType getTrustStoreType() {
        String string = this._getProperty(TRUSTSTORE_TYPE);
        return EKeyStoreType.getFromIDCaseInsensitiveOrDefault((String)string, (EKeyStoreType)DEFAULT_TRUSTSTORE_TYPE);
    }

    @Nonnull
    public final AS4CryptoProperties setTrustStoreType(@Nullable EKeyStoreType eKeyStoreType) {
        this._setProperty(TRUSTSTORE_TYPE, eKeyStoreType == null ? null : eKeyStoreType.getID());
        return this;
    }

    @Nullable
    public String getTrustStorePath() {
        return this._getProperty(TRUSTSTORE_FILE);
    }

    @Nonnull
    public final AS4CryptoProperties setTrustStorePath(@Nullable String string) {
        this._setProperty(TRUSTSTORE_FILE, string);
        return this;
    }

    @Nullable
    public String getTrustStorePassword() {
        return this._getProperty(TRUSTSTORE_PASSWORD);
    }

    @Nullable
    public char[] getTrustStorePasswordCharArray() {
        String string = this.getTrustStorePassword();
        return string == null ? null : string.toCharArray();
    }

    @Nonnull
    public final AS4CryptoProperties setTrustStorePassword(@Nullable String string) {
        this._setProperty(TRUSTSTORE_PASSWORD, string);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public AS4CryptoProperties getClone() {
        AS4CryptoProperties aS4CryptoProperties = new AS4CryptoProperties();
        aS4CryptoProperties.m_aProps.setAll((Map)this.m_aProps);
        return aS4CryptoProperties;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Props", (Object)this.m_aProps).getToString();
    }

    @Nonnull
    public static AS4CryptoProperties createFromConfig() {
        IConfig iConfig = AS4Configuration.getConfig();
        AS4CryptoProperties aS4CryptoProperties = new AS4CryptoProperties();
        for (String string : new String[]{CRYPTO_PROVIDER, KEYSTORE_TYPE, KEYSTORE_FILE, KEYSTORE_PASSWORD, KEY_ALIAS, KEY_PASSWORD, LOAD_CACERTS, TRUSTSTORE_PROVIDER, TRUSTSTORE_TYPE, TRUSTSTORE_FILE, TRUSTSTORE_PASSWORD}) {
            String string2 = iConfig.getAsString((Object)string);
            if (string2 == null) continue;
            aS4CryptoProperties.m_aProps.put((Object)string, (Object)string2);
        }
        return aS4CryptoProperties;
    }
}

