/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.crypto;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.crypto.ICryptoAlgorithmSign;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECryptoAlgorithmSign implements ICryptoAlgorithmSign
{
    RSA_SHA_256("rsa-sha-256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"),
    RSA_SHA_384("rsa-sha-384", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384"),
    RSA_SHA_512("rsa-sha-512", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512"),
    ECDSA_SHA_256("ecdsa-sha-256", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"),
    ECDSA_SHA_384("ecdsa-sha-384", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384"),
    ECDSA_SHA_512("ecdsa-sha-512", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512"),
    RSA_SHA_256_MGF1("rsa-sha-256-mgf1", "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1"),
    RSA_SHA_384_MGF1("rsa-sha-384-mgf1", "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1"),
    RSA_SHA_512_MGF1("rsa-sha-512-mgf1", "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1"),
    RSA_SHA3_256_MGF1("rsa-sha3-256-mgf1", "http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1"),
    RSA_SHA3_384_MGF1("rsa-sha3-384-mgf1", "http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1"),
    RSA_SHA3_512_MGF1("rsa-sha3-512-mgf1", "http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1");

    public static final ECryptoAlgorithmSign SIGN_ALGORITHM_DEFAULT;
    private final String m_sID;
    private final String m_sAlgorithmURI;

    private ECryptoAlgorithmSign(String string2, String string3) {
        this.m_sID = string2;
        this.m_sAlgorithmURI = string3;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAlgorithmURI() {
        return this.m_sAlgorithmURI;
    }

    @Nullable
    public static ECryptoAlgorithmSign getFromIDOrNull(@Nullable String string) {
        return (ECryptoAlgorithmSign)EnumHelper.getFromIDOrNull(ECryptoAlgorithmSign.class, (Object)string);
    }

    @Nonnull
    public static ECryptoAlgorithmSign getFromIDOrThrow(@Nullable String string) {
        return (ECryptoAlgorithmSign)EnumHelper.getFromIDOrThrow(ECryptoAlgorithmSign.class, (Object)string);
    }

    @Nullable
    public static ECryptoAlgorithmSign getFromIDOrDefault(@Nullable String string, @Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        return (ECryptoAlgorithmSign)EnumHelper.getFromIDOrDefault(ECryptoAlgorithmSign.class, (Object)string, (Enum)eCryptoAlgorithmSign);
    }

    @Nullable
    public static ECryptoAlgorithmSign getFromURIOrNull(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return (ECryptoAlgorithmSign)EnumHelper.findFirst(ECryptoAlgorithmSign.class, eCryptoAlgorithmSign -> eCryptoAlgorithmSign.getAlgorithmURI().equals(string));
    }

    static {
        SIGN_ALGORITHM_DEFAULT = RSA_SHA_256;
    }
}

