/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.string.StringHelper;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.dump.AbstractAS4IncomingDumperWithHeaders;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS4IncomingDumperFileBased
extends AbstractAS4IncomingDumperWithHeaders {
    public static final String DEFAULT_BASE_PATH = "incoming/";
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4IncomingDumperFileBased.class);
    private final IFileProvider m_aFileProvider;

    public AS4IncomingDumperFileBased() {
        this((iAS4IncomingMessageMetadata, httpHeaderMap) -> new File(AS4Configuration.getDumpBasePathFile(), DEFAULT_BASE_PATH + IFileProvider.getFilename(iAS4IncomingMessageMetadata)));
    }

    public AS4IncomingDumperFileBased(@Nonnull IFileProvider iFileProvider) {
        ValueEnforcer.notNull((Object)iFileProvider, (String)"FileProvider");
        this.m_aFileProvider = iFileProvider;
    }

    @Override
    @Nullable
    protected OutputStream openOutputStream(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap) throws IOException {
        File file = this.m_aFileProvider.createFile(iAS4IncomingMessageMetadata, httpHeaderMap);
        LOGGER.info("Logging incoming AS4 message to '" + file.getAbsolutePath() + "' " + (this.isIncludeHeaders() ? "including headers" : "excluding headers"));
        return FileHelper.getBufferedOutputStream((File)file);
    }

    @Nonnull
    public static AS4IncomingDumperFileBased createForDirectory(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"BaseDirectory");
        return new AS4IncomingDumperFileBased((iAS4IncomingMessageMetadata, httpHeaderMap) -> new File(file, IFileProvider.getFilename(iAS4IncomingMessageMetadata)));
    }

    @FunctionalInterface
    public static interface IFileProvider {
        public static final String DEFAULT_FILE_EXTENSION = ".as4in";

        @Nonnull
        public File createFile(@Nonnull IAS4IncomingMessageMetadata var1, @Nonnull HttpHeaderMap var2);

        @Nonnull
        public static String getFilename(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) {
            OffsetDateTime offsetDateTime = iAS4IncomingMessageMetadata.getIncomingDT();
            return offsetDateTime.getYear() + "/" + StringHelper.getLeadingZero((int)offsetDateTime.getMonthValue(), (int)2) + "/" + StringHelper.getLeadingZero((int)offsetDateTime.getDayOfMonth(), (int)2) + "/" + PDTIOHelper.getTimeForFilename((LocalTime)offsetDateTime.toLocalTime()) + "-" + FilenameHelper.getAsSecureValidASCIIFilename((String)iAS4IncomingMessageMetadata.getIncomingUniqueID()) + DEFAULT_FILE_EXTENSION;
        }
    }
}

