/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.http;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.messaging.mime.AS4MimeMessage;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;

public class HttpMimeMessageEntity
extends AbstractHttpEntity {
    private final AS4MimeMessage m_aMsg;

    protected HttpMimeMessageEntity(@Nonnull @Nonempty String string, @Nonnull AS4MimeMessage aS4MimeMessage) {
        super(string, null);
        this.m_aMsg = aS4MimeMessage;
    }

    public final void close() throws IOException {
    }

    @Nonnull
    public final MimeMessage getMimeMessage() {
        return this.m_aMsg;
    }

    public boolean isRepeatable() {
        return this.m_aMsg.isRepeatable();
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean isStreaming() {
        return false;
    }

    public InputStream getContent() throws IOException {
        try {
            return this.m_aMsg.getInputStream();
        }
        catch (MessagingException messagingException) {
            throw new IOException("Error reading MIME message", messagingException);
        }
    }

    public void writeTo(@Nonnull OutputStream outputStream) throws IOException {
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        try {
            this.m_aMsg.writeTo(outputStream);
        }
        catch (MessagingException messagingException) {
            throw new IOException("Error writing MIME message", messagingException);
        }
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("MimeMsg", (Object)this.m_aMsg).getToString();
    }

    @Nonnull
    public static HttpMimeMessageEntity create(@Nonnull AS4MimeMessage aS4MimeMessage) {
        ValueEnforcer.notNull((Object)((Object)aS4MimeMessage), (String)"Msg");
        try {
            return new HttpMimeMessageEntity(aS4MimeMessage.getContentType(), aS4MimeMessage);
        }
        catch (MessagingException messagingException) {
            throw new IllegalArgumentException("Failed to get the Content-Type from " + String.valueOf((Object)aS4MimeMessage), messagingException);
        }
    }
}

