/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.messaging.EAS4MessageMode;
import jakarta.servlet.http.Cookie;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAS4IncomingMessageMetadata {
    @Nonnull
    @Nonempty
    public String getIncomingUniqueID();

    @Nonnull
    public OffsetDateTime getIncomingDT();

    @Nonnull
    public EAS4MessageMode getMode();

    @Nullable
    public String getRemoteAddr();

    default public boolean hasRemoteAddr() {
        return StringHelper.hasText((String)this.getRemoteAddr());
    }

    @Nullable
    public String getRemoteHost();

    default public boolean hasRemoteHost() {
        return StringHelper.hasText((String)this.getRemoteHost());
    }

    @CheckForSigned
    public int getRemotePort();

    default public boolean hasRemotePort() {
        return this.getRemotePort() > 0;
    }

    @Nullable
    public String getRemoteUser();

    default public boolean hasRemoteUser() {
        return StringHelper.hasText((String)this.getRemoteUser());
    }

    @Nullable
    @ReturnsMutableObject
    public ICommonsList<X509Certificate> remoteTlsCerts();

    default public boolean hasRemoteTlsCerts() {
        return this.remoteTlsCerts() != null && this.remoteTlsCerts().isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<Cookie> cookies();

    @Nonnull
    @ReturnsMutableObject
    default public ICommonsList<Cookie> getAllCookies() {
        return (ICommonsList)this.cookies().getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public HttpHeaderMap getAllHttpHeaders();

    @Nullable
    public String getRequestMessageID();
}

