/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.crypto;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.mime.CMimeType;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.attachment.WSS4JAttachmentCallbackHandler;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.crypto.AS4CryptParams;
import com.helger.phase4.crypto.ECryptoMode;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.messaging.mime.AS4MimeMessage;
import com.helger.phase4.messaging.mime.MimeMessageCreator;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.wss.WSSConfigManager;
import com.helger.phase4.wss.WSSSynchronizer;
import jakarta.mail.MessagingException;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

@Immutable
public final class AS4Encryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4Encryptor.class);

    private AS4Encryptor() {
    }

    @Nonnull
    private static WSSecEncrypt _createEncrypt(@Nonnull WSSecHeader wSSecHeader, @Nonnull AS4CryptParams aS4CryptParams) {
        WSSecEncrypt wSSecEncrypt;
        WSSecEncrypt wSSecEncrypt2 = wSSecEncrypt = aS4CryptParams.hasWSSecEncryptCustomizer() ? aS4CryptParams.getWSSecEncryptCustomizer().createWSSecEncrypt(wSSecHeader) : new WSSecEncrypt(wSSecHeader);
        if (wSSecEncrypt == null) {
            throw new IllegalStateException("Failed to create WSSecEncrypt for " + String.valueOf(wSSecHeader));
        }
        wSSecEncrypt.setKeyIdentifierType(aS4CryptParams.getKeyIdentifierType().getTypeID());
        wSSecEncrypt.setSymmetricEncAlgorithm(aS4CryptParams.getAlgorithmCrypt().getAlgorithmURI());
        wSSecEncrypt.setKeyEncAlgo(aS4CryptParams.getKeyEncAlgorithm().getID());
        wSSecEncrypt.setMGFAlgorithm(aS4CryptParams.getMGFAlgorithm());
        wSSecEncrypt.setDigestAlgorithm(aS4CryptParams.getDigestAlgorithm());
        wSSecEncrypt.setEncryptSymmKey(aS4CryptParams.isEncryptSymmetricSessionKey());
        if (aS4CryptParams.hasCertificate()) {
            wSSecEncrypt.setUseThisCert(aS4CryptParams.getCertificate());
        } else if (aS4CryptParams.hasAlias()) {
            wSSecEncrypt.setUserInfo(aS4CryptParams.getAlias());
        }
        if (aS4CryptParams.hasWSSecEncryptCustomizer()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Before running WSSecEncryptCustomizer.customize");
            }
            aS4CryptParams.getWSSecEncryptCustomizer().customize(wSSecEncrypt);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("After running WSSecEncryptCustomizer.customize");
            }
        }
        return wSSecEncrypt;
    }

    @Nonnull
    private static Document _encryptSoapBodyPayload(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull ESoapVersion eSoapVersion, @Nonnull Document document, boolean bl, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException {
        SecretKey secretKey;
        LOGGER.info("Now encrypting AS4 SOAP message. KeyIdentifierType=" + aS4CryptParams.getKeyIdentifierType().name() + "; EncAlgo=" + aS4CryptParams.getAlgorithmCrypt().getAlgorithmURI() + "; KeyEncAlgo=" + String.valueOf((Object)aS4CryptParams.getKeyEncAlgorithm()) + "; MgfAlgo=" + aS4CryptParams.getMGFAlgorithm() + "; DigestAlgo=" + aS4CryptParams.getDigestAlgorithm() + (String)(aS4CryptParams.hasAlias() ? "; KeyAlias=" + aS4CryptParams.getAlias() : "") + (String)(aS4CryptParams.hasCertificate() ? "; CertificateSubjectCN=" + aS4CryptParams.getCertificate().getSubjectX500Principal().getName() : ""));
        WSSecHeader wSSecHeader = new WSSecHeader(document);
        wSSecHeader.insertSecurityHeader();
        WSSecEncrypt wSSecEncrypt = AS4Encryptor._createEncrypt(wSSecHeader, aS4CryptParams);
        wSSecEncrypt.getParts().add(new WSEncryptionPart("Body", eSoapVersion.getNamespaceURI(), "Content"));
        Attr attr = wSSecHeader.getSecurityHeaderElement().getAttributeNodeNS(eSoapVersion.getNamespaceURI(), "mustUnderstand");
        if (attr != null) {
            attr.setValue(eSoapVersion.getMustUnderstandValue(bl));
        }
        if ((secretKey = aS4CryptParams.getSessionKeyProvider().getSessionKey()) == null) {
            throw new IllegalStateException("Failed to create a symmetric session key from " + String.valueOf(aS4CryptParams.getSessionKeyProvider()));
        }
        return wSSecEncrypt.build(iAS4CryptoFactory.getCrypto(ECryptoMode.ENCRYPT_SIGN), secretKey);
    }

    @Nonnull
    public static Document encryptSoapBodyPayload(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull ESoapVersion eSoapVersion, @Nonnull Document document, boolean bl, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException {
        Document document2;
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactoryCrypt");
        ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion");
        ValueEnforcer.notNull((Object)document, (String)"XMLDoc");
        ValueEnforcer.notNull((Object)aS4CryptParams, (String)"CryptParams");
        LOGGER.info("phase4 --- encrypt.soap:start");
        if (AS4Configuration.isWSS4JSynchronizedSecurity()) {
            document2 = (Document)WSSSynchronizer.call(() -> AS4Encryptor._encryptSoapBodyPayload(iAS4CryptoFactory, eSoapVersion, document, bl, aS4CryptParams));
        } else {
            WSSConfigManager.getInstance();
            document2 = AS4Encryptor._encryptSoapBodyPayload(iAS4CryptoFactory, eSoapVersion, document, bl, aS4CryptParams);
        }
        LOGGER.info("phase4 --- encrypt.soap:start");
        return document2;
    }

    @Nonnull
    private static AS4MimeMessage _encryptToMimeMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Document document, @Nonnull @Nonempty ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull IAS4CryptoFactory iAS4CryptoFactory, boolean bl, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException {
        SecretKey secretKey;
        LOGGER.info("Now encrypting AS4 MIME message. KeyIdentifierType=" + aS4CryptParams.getKeyIdentifierType().name() + "; EncAlgo=" + aS4CryptParams.getAlgorithmCrypt().getAlgorithmURI() + "; KeyEncAlgo=" + String.valueOf((Object)aS4CryptParams.getKeyEncAlgorithm()) + "; MgfAlgo=" + aS4CryptParams.getMGFAlgorithm() + "; DigestAlgo=" + aS4CryptParams.getDigestAlgorithm() + (String)(aS4CryptParams.hasAlias() ? "; KeyAlias=" + aS4CryptParams.getAlias() : "") + (String)(aS4CryptParams.hasCertificate() ? "; CertificateSubjectCN=" + aS4CryptParams.getCertificate().getSubjectX500Principal().getName() : ""));
        WSSecHeader wSSecHeader = new WSSecHeader(document);
        wSSecHeader.insertSecurityHeader();
        WSSecEncrypt wSSecEncrypt = AS4Encryptor._createEncrypt(wSSecHeader, aS4CryptParams);
        wSSecEncrypt.getParts().add(new WSEncryptionPart(MessageHelperMethods.PREFIX_CID + "Attachments", "Content"));
        WSS4JAttachmentCallbackHandler wSS4JAttachmentCallbackHandler = new WSS4JAttachmentCallbackHandler((Iterable<? extends WSS4JAttachment>)iCommonsList, aS4ResourceHelper);
        wSSecEncrypt.setAttachmentCallbackHandler((CallbackHandler)wSS4JAttachmentCallbackHandler);
        Attr attr = wSSecHeader.getSecurityHeaderElement().getAttributeNodeNS(eSoapVersion.getNamespaceURI(), "mustUnderstand");
        if (attr != null) {
            attr.setValue(eSoapVersion.getMustUnderstandValue(bl));
        }
        if ((secretKey = aS4CryptParams.getSessionKeyProvider().getSessionKey()) == null) {
            throw new IllegalStateException("Failed to create a symmetric session key from " + String.valueOf(aS4CryptParams.getSessionKeyProvider()));
        }
        Document document2 = wSSecEncrypt.build(iAS4CryptoFactory.getCrypto(ECryptoMode.ENCRYPT_SIGN), secretKey);
        ICommonsList<WSS4JAttachment> iCommonsList2 = wSS4JAttachmentCallbackHandler.getAllResponseAttachments();
        for (WSS4JAttachment wSS4JAttachment : iCommonsList2) {
            wSS4JAttachment.overwriteMimeType(CMimeType.APPLICATION_OCTET_STREAM.getAsString());
            wSS4JAttachment.setContentTransferEncoding(EContentTransferEncoding.BINARY);
        }
        try {
            return MimeMessageCreator.generateMimeMessage(eSoapVersion, document2, iCommonsList2);
        }
        catch (MessagingException messagingException) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)messagingException), "Failed to generate MIME message");
        }
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="2.5.1")
    public static AS4MimeMessage encryptMimeMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Document document, @Nonnull @Nonempty ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull IAS4CryptoFactory iAS4CryptoFactory, boolean bl, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException {
        return AS4Encryptor.encryptToMimeMessage(eSoapVersion, document, iCommonsList, iAS4CryptoFactory, bl, aS4ResourceHelper, aS4CryptParams);
    }

    @Nonnull
    public static AS4MimeMessage encryptToMimeMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Document document, @Nonnull @Nonempty ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull IAS4CryptoFactory iAS4CryptoFactory, boolean bl, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException {
        AS4MimeMessage aS4MimeMessage;
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactoryCrypt");
        ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion");
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"Attachments");
        ValueEnforcer.notNull((Object)document, (String)"XMLDoc");
        ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        ValueEnforcer.notNull((Object)aS4CryptParams, (String)"CryptParams");
        LOGGER.info("phase4 --- encrypt.mime:start");
        if (AS4Configuration.isWSS4JSynchronizedSecurity()) {
            aS4MimeMessage = (AS4MimeMessage)((Object)WSSSynchronizer.call(() -> AS4Encryptor._encryptToMimeMessage(eSoapVersion, document, iCommonsList, iAS4CryptoFactory, bl, aS4ResourceHelper, aS4CryptParams)));
        } else {
            WSSConfigManager.getInstance();
            aS4MimeMessage = AS4Encryptor._encryptToMimeMessage(eSoapVersion, document, iCommonsList, iAS4CryptoFactory, bl, aS4ResourceHelper, aS4CryptParams);
        }
        LOGGER.info("phase4 --- encrypt.mime:end");
        return aS4MimeMessage;
    }
}

