/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.domain;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.ebms3header.Ebms3Receipt;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.ebms3header.MessagePartNRInformation;
import com.helger.phase4.ebms3header.NonRepudiationInformation;
import com.helger.phase4.marshaller.DSigReferenceMarshaller;
import com.helger.phase4.marshaller.NonRepudiationInformationMarshaller;
import com.helger.phase4.messaging.domain.AS4UserMessage;
import com.helger.phase4.messaging.domain.AbstractAS4Message;
import com.helger.phase4.messaging.domain.EAS4MessageType;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.xml.ChildElementIterator;
import com.helger.xml.XMLHelper;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xsds.xmldsig.ReferenceType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AS4ReceiptMessage
extends AbstractAS4Message<AS4ReceiptMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4ReceiptMessage.class);
    private final Ebms3SignalMessage m_aSignalMessage;

    public AS4ReceiptMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Ebms3SignalMessage ebms3SignalMessage) {
        super(eSoapVersion, EAS4MessageType.RECEIPT);
        ValueEnforcer.notNull((Object)ebms3SignalMessage, (String)"SignalMessage");
        this.m_aMessaging.addSignalMessage(ebms3SignalMessage);
        this.m_aSignalMessage = ebms3SignalMessage;
    }

    @Nonnull
    public final Ebms3SignalMessage getEbms3SignalMessage() {
        return this.m_aSignalMessage;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Node> getAllDSigReferenceNodes(@Nullable Node node) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Element element = XMLHelper.getFirstChildElementOfName((Node)node, (String)"Envelope");
        if (element != null && (element = XMLHelper.getFirstChildElementOfName((Node)element, (String)"Header")) != null && (element = XMLHelper.getFirstChildElementOfName((Node)element, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", (String)"Security")) != null && (element = XMLHelper.getFirstChildElementOfName((Node)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature")) != null && (element = XMLHelper.getFirstChildElementOfName((Node)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"SignedInfo")) != null) {
            new ChildElementIterator((Node)element).findAll(XMLHelper.filterElementWithNamespaceAndLocalName((String)"http://www.w3.org/2000/09/xmldsig#", (String)"Reference"), arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ReferenceType> getAllDSigReferences(@Nullable Node node) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Node node2 : AS4ReceiptMessage.getAllDSigReferenceNodes(node)) {
            ReferenceType referenceType = (ReferenceType)new DSigReferenceMarshaller().read(node2);
            if (referenceType == null) {
                LOGGER.error("Failed to read the content of the 'Reference' node as an XMLDsig Reference object: " + String.valueOf(node2) + " / " + XMLWriter.getNodeAsString((Node)node2));
                LOGGER.error("This will most likely end in invalid non-repudiation of receipt information!");
                continue;
            }
            commonsArrayList.add((Object)referenceType);
        }
        return commonsArrayList;
    }

    @Nonnull
    public static AS4ReceiptMessage create(@Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string, @Nullable Ebms3UserMessage ebms3UserMessage, @Nullable Node node, boolean bl) {
        ICommonsList<ReferenceType> iCommonsList = AS4ReceiptMessage.getAllDSigReferences(node);
        Ebms3SignalMessage ebms3SignalMessage = new Ebms3SignalMessage();
        IExplicitlyCloneable iExplicitlyCloneable = MessageHelperMethods.createEbms3MessageInfo(string, ebms3UserMessage != null ? ebms3UserMessage.getMessageInfo().getMessageId() : null);
        ebms3SignalMessage.setMessageInfo((Ebms3MessageInfo)iExplicitlyCloneable);
        iExplicitlyCloneable = new Ebms3Receipt();
        if (iCommonsList.isNotEmpty() && bl) {
            NonRepudiationInformation nonRepudiationInformation = new NonRepudiationInformation();
            for (ReferenceType referenceType : iCommonsList) {
                MessagePartNRInformation messagePartNRInformation = new MessagePartNRInformation();
                messagePartNRInformation.setReference(referenceType);
                nonRepudiationInformation.addMessagePartNRInformation(messagePartNRInformation);
            }
            Element element = new NonRepudiationInformationMarshaller().getAsElement(nonRepudiationInformation);
            if (element == null) {
                LOGGER.error("Failed to serialize NonRepudiationInformation object");
            } else {
                iExplicitlyCloneable.addAny(element);
            }
        } else {
            if (iCommonsList.isEmpty()) {
                LOGGER.info("Found no ds:Reference elements in the source message, hence returning the source UserMessage in the Receipt");
            } else {
                LOGGER.info("Non-repudiation is disabled, hence returning the source UserMessage in the Receipt");
            }
            iExplicitlyCloneable.addAny(AS4UserMessage.create(eSoapVersion, ebms3UserMessage).getAsSoapDocument().getDocumentElement());
        }
        ebms3SignalMessage.setReceipt((Ebms3Receipt)iExplicitlyCloneable);
        return new AS4ReceiptMessage(eSoapVersion, ebms3SignalMessage);
    }
}

