/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.mime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.messaging.mime.AS4MimeMessage;
import com.helger.phase4.messaging.mime.DataContentHandlerSoap12;
import com.helger.phase4.messaging.mime.SoapMimeMultipart;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4XMLHelper;
import jakarta.activation.CommandMap;
import jakarta.activation.DataHandler;
import jakarta.activation.MailcapCommandMap;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;

public final class MimeMessageCreator {
    private MimeMessageCreator() {
    }

    @Nonnull
    public static AS4MimeMessage generateMimeMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Document document, @Nullable ICommonsList<WSS4JAttachment> iCommonsList) throws MessagingException {
        ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion");
        ValueEnforcer.notNull((Object)document, (String)"SoapEnvelope");
        Charset charset = AS4XMLHelper.XWS.getCharset();
        SoapMimeMultipart soapMimeMultipart = new SoapMimeMultipart(eSoapVersion);
        EContentTransferEncoding eContentTransferEncoding = EContentTransferEncoding.BINARY;
        String string = eSoapVersion.getMimeType(charset).getAsString();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(new DataHandler((Object)new DOMSource(document), string));
        mimeBodyPart.setHeader("Content-Transfer-Encoding", eContentTransferEncoding.getID());
        soapMimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        boolean bl = true;
        if (iCommonsList != null) {
            for (WSS4JAttachment wSS4JAttachment : iCommonsList) {
                wSS4JAttachment.addToMimeMultipart(soapMimeMultipart);
                if (wSS4JAttachment.isRepeatable()) continue;
                bl = false;
            }
        }
        Object object = new AS4MimeMessage((Session)null, bl);
        object.setContent((Multipart)soapMimeMultipart);
        object.saveChanges();
        return object;
    }

    static {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap(ESoapVersion.SOAP_12.getMimeType().getAsStringWithoutParameters() + ";; x-java-content-handler=" + DataContentHandlerSoap12.class.getName());
        CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
    }
}

