/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.StringHelper;
import com.helger.json.IJsonObject;
import com.helger.phase4.model.EMEP;
import com.helger.phase4.model.EMEPBinding;
import com.helger.phase4.model.pmode.PModeJsonConverter;
import com.helger.phase4.model.pmode.PModeParty;
import com.helger.phase4.model.pmode.PModePayloadService;
import com.helger.phase4.model.pmode.PModeReceptionAwareness;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.tenancy.IBusinessObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IPMode
extends IBusinessObject {
    @Nullable
    public PModeParty getInitiator();

    default public boolean hasInitiator() {
        return this.getInitiator() != null;
    }

    @Nullable
    default public String getInitiatorID() {
        PModeParty pModeParty = this.getInitiator();
        return pModeParty == null ? null : pModeParty.getID();
    }

    default public boolean hasInitiatorID(@Nullable String string) {
        return EqualsHelper.equals((Object)string, (Object)this.getInitiatorID());
    }

    @Nullable
    public PModeParty getResponder();

    default public boolean hasResponder() {
        return this.getResponder() != null;
    }

    @Nullable
    default public String getResponderID() {
        PModeParty pModeParty = this.getResponder();
        return pModeParty == null ? null : pModeParty.getID();
    }

    default public boolean hasResponderID(@Nullable String string) {
        return EqualsHelper.equals((Object)string, (Object)this.getResponderID());
    }

    @Nullable
    public String getAgreement();

    default public boolean hasAgreement() {
        return StringHelper.hasText((String)this.getAgreement());
    }

    @Nonnull
    public EMEP getMEP();

    @Nonnull
    @Nonempty
    default public String getMEPID() {
        return this.getMEP().getID();
    }

    @Nonnull
    public EMEPBinding getMEPBinding();

    @Nonnull
    @Nonempty
    default public String getMEPBindingID() {
        return this.getMEPBinding().getID();
    }

    @Nullable
    public PModeLeg getLeg1();

    default public boolean hasLeg1() {
        return this.getLeg1() != null;
    }

    @Nullable
    public PModeLeg getLeg2();

    default public boolean hasLeg2() {
        return this.getLeg2() != null;
    }

    @Nullable
    public PModePayloadService getPayloadService();

    default public boolean hasPayloadService() {
        return this.getPayloadService() != null;
    }

    @Nullable
    public PModeReceptionAwareness getReceptionAwareness();

    default public boolean hasReceptionAwareness() {
        return this.getReceptionAwareness() != null;
    }

    @Nonnull
    default public IJsonObject getAsJson() {
        return PModeJsonConverter.convertToJson(this);
    }
}

