/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.id.IHasID;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.type.ObjectType;
import com.helger.dao.DAOException;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.IPModeManager;
import com.helger.phase4.model.pmode.PMode;
import com.helger.phase4.model.pmode.PModeValidationException;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.io.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.tenancy.AbstractBusinessObject;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PModeManager
extends AbstractPhotonMapBasedWALDAO<IPMode, PMode>
implements IPModeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PModeManager.class);

    public PModeManager(@Nullable String string) throws DAOException {
        super(PMode.class, string);
    }

    private void _validatePMode(@Nonnull IPMode iPMode) {
        try {
            this.validatePMode(iPMode);
        }
        catch (PModeValidationException pModeValidationException) {
            throw new IllegalArgumentException("PMode is invalid", pModeValidationException);
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    private void _createPModeLocked(@Nonnull PMode pMode) {
        this.internalCreateItem((IHasID)pMode);
        AuditHelper.onAuditCreateSuccess((ObjectType)PMode.OT, (Object[])new Object[]{pMode.getID()});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created PMode with ID '" + pMode.getID() + "'");
        }
    }

    @Override
    public void createPMode(@Nonnull PMode pMode) {
        ValueEnforcer.notNull((Object)pMode, (String)"PMode");
        this._validatePMode(pMode);
        this.m_aRWLock.writeLocked(() -> this._createPModeLocked(pMode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange updatePMode(@Nonnull IPMode iPMode) {
        ValueEnforcer.notNull((Object)iPMode, (String)"PMode");
        this._validatePMode(iPMode);
        PMode pMode = (PMode)this.getOfID((String)iPMode.getID());
        if (pMode == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)PMode.OT, (String)((String)iPMode.getID()), (Object[])new Object[]{"no-such-id"});
            return EChange.UNCHANGED;
        }
        if (pMode.isDeleted()) {
            AuditHelper.onAuditModifyFailure((ObjectType)PMode.OT, (String)((String)iPMode.getID()), (Object[])new Object[]{"already-deleted"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.UNCHANGED;
            eChange = eChange.or((IChangeIndicator)pMode.setInitiator(iPMode.getInitiator()));
            eChange = eChange.or((IChangeIndicator)pMode.setResponder(iPMode.getResponder()));
            eChange = eChange.or((IChangeIndicator)pMode.setAgreement(iPMode.getAgreement()));
            eChange = eChange.or((IChangeIndicator)pMode.setMEP(iPMode.getMEP()));
            eChange = eChange.or((IChangeIndicator)pMode.setMEPBinding(iPMode.getMEPBinding()));
            eChange = eChange.or((IChangeIndicator)pMode.setLeg1(iPMode.getLeg1()));
            eChange = eChange.or((IChangeIndicator)pMode.setLeg2(iPMode.getLeg2()));
            eChange = eChange.or((IChangeIndicator)pMode.setPayloadService(iPMode.getPayloadService()));
            eChange = eChange.or((IChangeIndicator)pMode.setReceptionAwareness(iPMode.getReceptionAwareness()));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow((AbstractBusinessObject)pMode);
            this.internalUpdateItem((IHasID)pMode);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)PMode.OT, (String)"all", (Object[])new Object[]{pMode.getID()});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updated PMode with ID '" + (String)iPMode.getID() + "'");
        }
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createOrUpdatePMode(@Nonnull PMode pMode) {
        ValueEnforcer.notNull((Object)pMode, (String)"PMode");
        this._validatePMode(pMode);
        Predicate<IPMode> predicate = IPModeManager.getPModeFilter(pMode.getID(), pMode.getInitiator(), pMode.getResponder());
        IPMode iPMode = (IPMode)this.findFirst(predicate);
        if (iPMode == null) {
            this.m_aRWLock.writeLock().lock();
            try {
                iPMode = (IPMode)this.findFirst(predicate);
                if (iPMode == null) {
                    this._createPModeLocked(pMode);
                }
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        if (iPMode != null) {
            this.updatePMode(iPMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange markPModeDeleted(@Nullable String string) {
        PMode pMode = (PMode)this.getOfID(string);
        if (pMode == null) {
            AuditHelper.onAuditDeleteFailure((ObjectType)PMode.OT, (Object[])new Object[]{"no-such-object-id", string});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow((AbstractBusinessObject)pMode).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure((ObjectType)PMode.OT, (Object[])new Object[]{"already-deleted", string});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemDeleted((IHasID)pMode);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)PMode.OT, (Object[])new Object[]{string});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Marked PMode with ID '" + pMode.getID() + "' as deleted");
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange deletePMode(@Nullable String string) {
        PMode pMode = (PMode)this.getOfID(string);
        if (pMode == null) {
            AuditHelper.onAuditDeleteFailure((ObjectType)PMode.OT, (Object[])new Object[]{"no-such-object-id", string});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            this.internalDeleteItem(string);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)PMode.OT, (Object[])new Object[]{string});
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public IPMode getPModeOfID(@Nullable String string) {
        return (IPMode)this.getOfID(string);
    }
}

