/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.resolve;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.pmode.DefaultPMode;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.IPModeManager;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.profile.IAS4Profile;
import com.helger.phase4.profile.IAS4ProfileManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultPModeResolver
implements IPModeResolver {
    public static final IPModeResolver DEFAULT_PMODE_RESOLVER = new DefaultPModeResolver(null, false);
    private final String m_sAS4ProfileID;
    private final boolean m_bUseDefaultAsFallback;

    @Deprecated(forRemoval=true, since="2.8.2")
    public DefaultPModeResolver(boolean bl) {
        this(null, bl);
    }

    public DefaultPModeResolver(@Nullable String string, boolean bl) {
        this.m_sAS4ProfileID = string;
        this.m_bUseDefaultAsFallback = bl;
    }

    @Nullable
    public final String getAS4ProfileID() {
        return this.m_sAS4ProfileID;
    }

    public final boolean isUseDefaultAsFallback() {
        return this.m_bUseDefaultAsFallback;
    }

    @Nullable
    @OverrideOnDemand
    protected IPMode createDefaultPMode(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3) {
        IAS4ProfileManager iAS4ProfileManager = MetaAS4Manager.getProfileMgr();
        IAS4Profile iAS4Profile = null;
        if (StringHelper.hasText((String)this.m_sAS4ProfileID)) {
            iAS4Profile = iAS4ProfileManager.getProfileOfID(this.m_sAS4ProfileID);
        }
        if (iAS4Profile == null) {
            iAS4Profile = iAS4ProfileManager.getDefaultProfileOrNull();
        }
        if (iAS4Profile != null) {
            return iAS4Profile.createPModeTemplate(string, string2, string3);
        }
        if (!this.m_bUseDefaultAsFallback) {
            return null;
        }
        return DefaultPMode.getOrCreateDefaultPMode(string, string2, string3, true);
    }

    @Override
    @Nullable
    public IPMode getPModeOfID(@Nullable String string, @Nonnull String string2, @Nonnull String string3, @Nonnull @Nonempty String string4, @Nonnull @Nonempty String string5, @Nullable String string6, @Nullable String string7) {
        IPModeManager iPModeManager = MetaAS4Manager.getPModeMgr();
        IPMode iPMode = null;
        if (StringHelper.hasText((String)string) && (iPMode = iPModeManager.getPModeOfID(string)) != null) {
            return iPMode;
        }
        iPMode = iPModeManager.getPModeOfServiceAndAction(string2, string3);
        if (iPMode != null) {
            return iPMode;
        }
        return this.createDefaultPMode(string4, string5, string7);
    }

    public String toString() {
        return new ToStringGenerator(null).append("AS4ProfileID", (Object)this.m_sAS4ProfileID).append("UseDefaultAsFallback", this.m_bUseDefaultAsFallback).getToString();
    }
}

