/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.sender;

import com.helger.commons.wrapper.Wrapper;
import com.helger.httpclient.response.ResponseHandlerHttpEntity;
import com.helger.phase4.attachment.IAS4IncomingAttachmentFactory;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.client.AS4ClientPullRequestMessage;
import com.helger.phase4.client.AS4ClientSentMessage;
import com.helger.phase4.client.AS4ClientUserMessage;
import com.helger.phase4.client.IAS4ClientBuildMessageCallback;
import com.helger.phase4.client.IAS4RawResponseConsumer;
import com.helger.phase4.client.IAS4RetryCallback;
import com.helger.phase4.client.IAS4SignalMessageConsumer;
import com.helger.phase4.client.IAS4UserMessageConsumer;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.crypto.IAS4IncomingSecurityConfiguration;
import com.helger.phase4.dump.IAS4IncomingDumper;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.servlet.AS4IncomingHandler;
import com.helger.phase4.servlet.AS4IncomingMessageMetadata;
import com.helger.phase4.servlet.IAS4IncomingProfileSelector;
import com.helger.phase4.util.Phase4Exception;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AS4BidirectionalClientHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4BidirectionalClientHelper.class);

    private AS4BidirectionalClientHelper() {
    }

    public static void sendAS4UserMessageAndReceiveAS4SignalMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nonnull IPModeResolver iPModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector, @Nonnull AS4ClientUserMessage aS4ClientUserMessage, @Nonnull Locale locale, @Nonnull String string, @Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration, @Nullable IAS4RetryCallback iAS4RetryCallback, @Nullable IAS4RawResponseConsumer iAS4RawResponseConsumer, @Nullable IAS4SignalMessageConsumer iAS4SignalMessageConsumer) throws IOException, Phase4Exception, WSSecurityException, MessagingException {
        Object object2;
        LOGGER.info("Sending AS4 UserMessage to '" + string + "' with max. " + aS4ClientUserMessage.httpRetrySettings().getMaxRetries() + " retries");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  ServiceType = '" + aS4ClientUserMessage.getServiceType() + "'");
            LOGGER.debug("  Service = '" + aS4ClientUserMessage.getServiceValue() + "'");
            LOGGER.debug("  Action = '" + aS4ClientUserMessage.getAction() + "'");
            LOGGER.debug("  ConversationId = '" + aS4ClientUserMessage.getConversationID() + "'");
            LOGGER.debug("  MessageProperties:");
            for (Object object2 : aS4ClientUserMessage.ebms3Properties()) {
                LOGGER.debug("    [" + ((Ebms3Property)object2).getName() + "] = [" + ((Ebms3Property)object2).getValue() + "]");
            }
            LOGGER.debug("  Attachments (" + aS4ClientUserMessage.attachments().size() + "):");
            for (Object object2 : aS4ClientUserMessage.attachments()) {
                LOGGER.debug("    [" + object2.getId() + "] with [" + object2.getMimeType() + "] and [" + String.valueOf(((WSS4JAttachment)object2).getCharsetOrDefault(null)) + "] and [" + String.valueOf((Object)((WSS4JAttachment)object2).getCompressionMode()) + "] and [" + String.valueOf(((WSS4JAttachment)object2).getContentTransferEncoding()) + "]");
            }
        }
        Wrapper wrapper = new Wrapper();
        object2 = classicHttpResponse -> {
            HttpEntity httpEntity = ResponseHandlerHttpEntity.INSTANCE.handleResponse(classicHttpResponse);
            if (httpEntity == null) {
                return null;
            }
            wrapper.set((Object)classicHttpResponse);
            return EntityUtils.toByteArray((HttpEntity)httpEntity);
        };
        AS4ClientSentMessage<byte[]> aS4ClientSentMessage = aS4ClientUserMessage.sendMessageWithRetries(string, object2, iAS4ClientBuildMessageCallback, iAS4OutgoingDumper, iAS4RetryCallback);
        String string2 = aS4ClientSentMessage.getMessageID();
        LOGGER.info("Successfully transmitted AS4 UserMessage with message ID '" + string2 + "' to '" + string + "'");
        if (iAS4RawResponseConsumer != null) {
            iAS4RawResponseConsumer.handleResponse(aS4ClientSentMessage);
        }
        if (aS4ClientSentMessage.hasResponse() && aS4ClientSentMessage.getResponse().length > 0) {
            AS4IncomingMessageMetadata aS4IncomingMessageMetadata = AS4IncomingMessageMetadata.createForResponse(string2).setRemoteAddr(string);
            AS4IncomingHandler.parseSignalMessage(iAS4CryptoFactory, iAS4CryptoFactory2, iPModeResolver, iAS4IncomingAttachmentFactory, iAS4IncomingProfileSelector, aS4ClientUserMessage.getAS4ResourceHelper(), aS4ClientUserMessage.getPMode(), locale, aS4IncomingMessageMetadata, (HttpResponse)wrapper.get(), aS4ClientSentMessage.getResponse(), iAS4IncomingDumper, iAS4IncomingSecurityConfiguration, iAS4SignalMessageConsumer);
        } else {
            LOGGER.info("AS4 ResponseEntity is empty");
        }
    }

    public static void sendAS4PullRequestAndReceiveAS4UserMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nonnull IPModeResolver iPModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector, @Nonnull AS4ClientPullRequestMessage aS4ClientPullRequestMessage, @Nonnull Locale locale, @Nonnull String string, @Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration, @Nullable IAS4RetryCallback iAS4RetryCallback, @Nullable IAS4RawResponseConsumer iAS4RawResponseConsumer, @Nullable IAS4UserMessageConsumer iAS4UserMessageConsumer, @Nullable IPMode iPMode) throws IOException, Phase4Exception, WSSecurityException, MessagingException {
        LOGGER.info("Sending AS4 PullRequest to '" + string + "' with max. " + aS4ClientPullRequestMessage.httpRetrySettings().getMaxRetries() + " retries");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  MPC = '" + aS4ClientPullRequestMessage.getMPC() + "'");
        }
        Wrapper wrapper = new Wrapper();
        HttpClientResponseHandler httpClientResponseHandler = classicHttpResponse -> {
            HttpEntity httpEntity = ResponseHandlerHttpEntity.INSTANCE.handleResponse(classicHttpResponse);
            if (httpEntity == null) {
                return null;
            }
            wrapper.set((Object)classicHttpResponse);
            return EntityUtils.toByteArray((HttpEntity)httpEntity);
        };
        AS4ClientSentMessage<byte[]> aS4ClientSentMessage = aS4ClientPullRequestMessage.sendMessageWithRetries(string, httpClientResponseHandler, iAS4ClientBuildMessageCallback, iAS4OutgoingDumper, iAS4RetryCallback);
        String string2 = aS4ClientSentMessage.getMessageID();
        LOGGER.info("Successfully transmitted AS4 PullRequest with message ID '" + string2 + "' to '" + string + "'");
        if (iAS4RawResponseConsumer != null) {
            iAS4RawResponseConsumer.handleResponse(aS4ClientSentMessage);
        }
        if (aS4ClientSentMessage.hasResponse() && aS4ClientSentMessage.getResponse().length > 0) {
            AS4IncomingMessageMetadata aS4IncomingMessageMetadata = AS4IncomingMessageMetadata.createForResponse(string2).setRemoteAddr(string);
            AS4IncomingHandler.parseUserMessage(iAS4CryptoFactory, iAS4CryptoFactory2, iPModeResolver, iAS4IncomingAttachmentFactory, iAS4IncomingProfileSelector, aS4ClientPullRequestMessage.getAS4ResourceHelper(), iPMode, locale, aS4IncomingMessageMetadata, (HttpResponse)wrapper.get(), aS4ClientSentMessage.getResponse(), iAS4IncomingDumper, iAS4IncomingSecurityConfiguration, iAS4UserMessageConsumer);
        } else {
            LOGGER.info("AS4 ResponseEntity is empty");
        }
    }

    public static void sendAS4PullRequestAndReceiveAS4UserOrSignalMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nonnull IPModeResolver iPModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector, @Nonnull AS4ClientPullRequestMessage aS4ClientPullRequestMessage, @Nonnull Locale locale, @Nonnull String string, @Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration, @Nullable IAS4RetryCallback iAS4RetryCallback, @Nullable IAS4RawResponseConsumer iAS4RawResponseConsumer, @Nullable IAS4UserMessageConsumer iAS4UserMessageConsumer, @Nullable IAS4SignalMessageConsumer iAS4SignalMessageConsumer, @Nullable IPMode iPMode) throws IOException, Phase4Exception, WSSecurityException, MessagingException {
        LOGGER.info("Sending AS4 PullRequest to '" + string + "' with max. " + aS4ClientPullRequestMessage.httpRetrySettings().getMaxRetries() + " retries");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  MPC = '" + aS4ClientPullRequestMessage.getMPC() + "'");
        }
        Wrapper wrapper = new Wrapper();
        HttpClientResponseHandler httpClientResponseHandler = classicHttpResponse -> {
            HttpEntity httpEntity = ResponseHandlerHttpEntity.INSTANCE.handleResponse(classicHttpResponse);
            if (httpEntity == null) {
                return null;
            }
            wrapper.set((Object)classicHttpResponse);
            return EntityUtils.toByteArray((HttpEntity)httpEntity);
        };
        AS4ClientSentMessage<byte[]> aS4ClientSentMessage = aS4ClientPullRequestMessage.sendMessageWithRetries(string, httpClientResponseHandler, iAS4ClientBuildMessageCallback, iAS4OutgoingDumper, iAS4RetryCallback);
        String string2 = aS4ClientSentMessage.getMessageID();
        LOGGER.info("Successfully transmitted AS4 PullRequest with message ID '" + string2 + "' to '" + string + "'");
        if (iAS4RawResponseConsumer != null) {
            iAS4RawResponseConsumer.handleResponse(aS4ClientSentMessage);
        }
        if (aS4ClientSentMessage.hasResponse() && aS4ClientSentMessage.getResponse().length > 0) {
            AS4IncomingMessageMetadata aS4IncomingMessageMetadata = AS4IncomingMessageMetadata.createForResponse(string2).setRemoteAddr(string);
            AS4IncomingHandler.parseUserOrSignalMessage(iAS4CryptoFactory, iAS4CryptoFactory2, iPModeResolver, iAS4IncomingAttachmentFactory, iAS4IncomingProfileSelector, aS4ClientPullRequestMessage.getAS4ResourceHelper(), iPMode, locale, aS4IncomingMessageMetadata, (HttpResponse)wrapper.get(), aS4ClientSentMessage.getResponse(), iAS4IncomingDumper, iAS4IncomingSecurityConfiguration, iAS4UserMessageConsumer, iAS4SignalMessageConsumer);
        } else {
            LOGGER.info("AS4 ResponseEntity is empty");
        }
    }
}

