/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.attr.AttributeContainerAny;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.ebms3header.Ebms3Messaging;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.mpc.IMPC;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.profile.IAS4Profile;
import com.helger.phase4.servlet.IAS4MessageState;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4ResourceHelper;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.util.Locale;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public final class AS4MessageState
extends AttributeContainerAny<String>
implements IAS4MessageState {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4MessageState.class);
    private static final String KEY_EBMS3_MESSAGING = "phase4.ebms3.messaging";
    private static final String KEY_PMODE = "phase4.pmode";
    private static final String KEY_MPC = "phase4.mpc";
    private static final String KEY_ORIGINAL_SOAP_DOCUMENT = "phase4.soap.document";
    private static final String KEY_ORIGINAL_ATTACHMENT_LIST = "phase4.soap.attachmentlist";
    private static final String KEY_DECRYPTED_SOAP_DOCUMENT = "phase4.soap.decrypted.document";
    private static final String KEY_DECRYPTED_ATTACHMENT_LIST = "phase4.soap.decrypted.attachmentlist";
    private static final String KEY_COMPRESSED_ATTACHMENT_IDS = "phase4.compressed.attachment.ids";
    private static final String KEY_SOAP_BODY_PAYLOAD_PRESENT = "phase4.soap.body.payload.present";
    private static final String KEY_INITIATOR_ID = "phase4.initiator.id";
    private static final String KEY_RESPONDER_ID = "phase4.responder.id";
    private static final String KEY_USED_CERTIFICATE = "phase4.used.certificate";
    private static final String KEY_EFFECTIVE_PMODE_LEG = "phase4.pmode.effective.leg";
    private static final String KEY_EFFECTIVE_PMODE_LEG_NUMBER = "phase4.pmode.effective.leg.number";
    private static final String KEY_WSS4J_SECURITY_ACTIONS = "phase4.soap.wss4j-security-actions";
    private static final String KEY_WSS4J_EXCEPTION = "phase4.soap.wss4j-exception";
    private static final String KEY_PHASE4_PROFILE = "phase4.profile";
    private static final String KEY_AS4_MESSAGE_ID = "phase4.message.id";
    private static final String KEY_AS4_REF_TO_MESSAGE_ID = "phase4.ref.to.message.id";
    private static final String KEY_AS4_MESSAGE_TIMESTAMP = "phase4.message.timestamp";
    private static final String KEY_IS_PING_MESSAGE = "phase4.is.ping.message";
    private static final String KEY_SOAP_BODY_PAYLOAD_NODE = "phase4.soap.body.first.child";
    private static final String KEY_SOAP_HEADER_ELEMENT_PROCESSING_SUCCESSFUL = "phase4.soap.header.element.processing.successful";
    private static final String KEY_CRYPTO_FACTORY_SIGN = "phase4.crypto-factory.sign";
    private static final String KEY_CRYPTO_FACTORY_CRYPT = "phase4.crypto-factory.crypt";
    private final OffsetDateTime m_aReceiptDT = MetaAS4Manager.getTimestampMgr().getCurrentDateTime();
    private final ESoapVersion m_eSoapVersion;
    private final AS4ResourceHelper m_aResHelper;
    private final Locale m_aLocale;

    public AS4MessageState(@Nonnull ESoapVersion eSoapVersion, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nonnull Locale locale) {
        this.m_eSoapVersion = (ESoapVersion)((Object)ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SOAPVersion"));
        this.m_aResHelper = (AS4ResourceHelper)ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        this.m_aLocale = (Locale)ValueEnforcer.notNull((Object)locale, (String)"Locale");
    }

    @Override
    @Nonnull
    public OffsetDateTime getReceiptDT() {
        return this.m_aReceiptDT;
    }

    @Override
    @Nonnull
    public ESoapVersion getSoapVersion() {
        return this.m_eSoapVersion;
    }

    @Override
    @Nonnull
    public AS4ResourceHelper getResourceHelper() {
        return this.m_aResHelper;
    }

    @Override
    @Nonnull
    public Locale getLocale() {
        return this.m_aLocale;
    }

    @Override
    @Nullable
    public Ebms3Messaging getMessaging() {
        return (Ebms3Messaging)this.getCastedValue(KEY_EBMS3_MESSAGING);
    }

    public void setMessaging(@Nullable Ebms3Messaging ebms3Messaging) {
        this.putIn(KEY_EBMS3_MESSAGING, ebms3Messaging);
    }

    @Override
    @Nullable
    public IPMode getPMode() {
        return (IPMode)this.getCastedValue(KEY_PMODE);
    }

    public void setPMode(@Nullable IPMode iPMode) {
        this.putIn(KEY_PMODE, iPMode);
    }

    @Override
    @Nullable
    public Document getOriginalSoapDocument() {
        return (Document)this.getCastedValue(KEY_ORIGINAL_SOAP_DOCUMENT);
    }

    public void setOriginalSoapDocument(@Nullable Document document) {
        this.putIn(KEY_ORIGINAL_SOAP_DOCUMENT, document);
    }

    @Override
    @Nullable
    public ICommonsList<WSS4JAttachment> getOriginalAttachments() {
        return (ICommonsList)this.getCastedValue(KEY_ORIGINAL_ATTACHMENT_LIST);
    }

    public void setOriginalAttachments(@Nullable ICommonsList<WSS4JAttachment> iCommonsList) {
        this.putIn(KEY_ORIGINAL_ATTACHMENT_LIST, iCommonsList);
    }

    @Override
    @Nullable
    public Document getDecryptedSoapDocument() {
        return (Document)this.getCastedValue(KEY_DECRYPTED_SOAP_DOCUMENT);
    }

    public void setDecryptedSoapDocument(@Nullable Document document) {
        this.putIn(KEY_DECRYPTED_SOAP_DOCUMENT, document);
    }

    @Override
    @Nullable
    public ICommonsList<WSS4JAttachment> getDecryptedAttachments() {
        return (ICommonsList)this.getCastedValue(KEY_DECRYPTED_ATTACHMENT_LIST);
    }

    public void setDecryptedAttachments(@Nullable ICommonsList<WSS4JAttachment> iCommonsList) {
        this.putIn(KEY_DECRYPTED_ATTACHMENT_LIST, iCommonsList);
    }

    @Override
    @Nullable
    public ICommonsMap<String, EAS4CompressionMode> getCompressedAttachmentIDs() {
        return (ICommonsMap)this.getCastedValue(KEY_COMPRESSED_ATTACHMENT_IDS);
    }

    public void setCompressedAttachmentIDs(@Nullable ICommonsMap<String, EAS4CompressionMode> iCommonsMap) {
        this.putIn(KEY_COMPRESSED_ATTACHMENT_IDS, iCommonsMap);
    }

    @Override
    @Nullable
    public IMPC getMPC() {
        return (IMPC)this.getCastedValue(KEY_MPC);
    }

    public void setMPC(@Nullable IMPC iMPC) {
        this.putIn(KEY_MPC, iMPC);
    }

    @Override
    public boolean isSoapBodyPayloadPresent() {
        return this.getAsBoolean(KEY_SOAP_BODY_PAYLOAD_PRESENT, false);
    }

    public void setSoapBodyPayloadPresent(boolean bl) {
        this.putIn(KEY_SOAP_BODY_PAYLOAD_PRESENT, bl);
    }

    @Override
    @Nullable
    public String getInitiatorID() {
        return this.getAsString(KEY_INITIATOR_ID);
    }

    public void setInitiatorID(@Nullable String string) {
        this.putIn(KEY_INITIATOR_ID, string);
    }

    @Override
    @Nullable
    public String getResponderID() {
        return this.getAsString(KEY_RESPONDER_ID);
    }

    public void setResponderID(@Nullable String string) {
        this.putIn(KEY_RESPONDER_ID, string);
    }

    @Override
    @Nullable
    public X509Certificate getUsedCertificate() {
        return (X509Certificate)this.getCastedValue(KEY_USED_CERTIFICATE);
    }

    public void setUsedCertificate(@Nullable X509Certificate x509Certificate) {
        this.putIn(KEY_USED_CERTIFICATE, x509Certificate);
    }

    @Override
    @Nullable
    public PModeLeg getEffectivePModeLeg() {
        return (PModeLeg)this.getCastedValue(KEY_EFFECTIVE_PMODE_LEG);
    }

    @Override
    @CheckForSigned
    public int getEffectivePModeLegNumber() {
        return this.getAsInt(KEY_EFFECTIVE_PMODE_LEG_NUMBER, -1);
    }

    public void setEffectivePModeLeg(@Nonnegative int n, @Nullable PModeLeg pModeLeg) {
        ValueEnforcer.isTrue((n == 1 || n == 2 ? 1 : 0) != 0, (String)"LegNumber must be 1 or 2");
        this.putIn(KEY_EFFECTIVE_PMODE_LEG, pModeLeg);
        this.putIn(KEY_EFFECTIVE_PMODE_LEG_NUMBER, n);
    }

    @Override
    public int getSoapWSS4JSecurityActions() {
        return this.getAsInt(KEY_WSS4J_SECURITY_ACTIONS, 0);
    }

    public void setSoapWSS4JSecurityActions(int n) {
        this.putIn(KEY_WSS4J_SECURITY_ACTIONS, n);
    }

    @Override
    public boolean isSoapSignatureChecked() {
        return (this.getSoapWSS4JSecurityActions() & 2) == 2;
    }

    @Override
    public boolean isSoapDecrypted() {
        return (this.getSoapWSS4JSecurityActions() & 4) == 4;
    }

    @Override
    @Nullable
    public Exception getSoapWSS4JException() {
        return (Exception)this.getCastedValue(KEY_WSS4J_EXCEPTION);
    }

    public void setSoapWSS4JException(@Nullable Exception exception) {
        this.putIn(KEY_WSS4J_EXCEPTION, exception);
    }

    @Override
    @Nullable
    public IAS4Profile getAS4Profile() {
        return (IAS4Profile)this.getCastedValue(KEY_PHASE4_PROFILE);
    }

    public void setAS4Profile(@Nullable IAS4Profile iAS4Profile) {
        this.putIn(KEY_PHASE4_PROFILE, iAS4Profile);
    }

    @Override
    @Nullable
    public String getMessageID() {
        return this.getAsString(KEY_AS4_MESSAGE_ID);
    }

    public void setMessageID(@Nullable String string) {
        String string2 = this.getMessageID();
        if (string2 != null && !string2.equals(string)) {
            LOGGER.warn("Overwriting the AS4 message ID from '" + string2 + "' to '" + string + "'");
        }
        this.putIn(KEY_AS4_MESSAGE_ID, string);
    }

    @Override
    @Nullable
    public String getRefToMessageID() {
        return this.getAsString(KEY_AS4_REF_TO_MESSAGE_ID);
    }

    public void setRefToMessageID(@Nullable String string) {
        this.putIn(KEY_AS4_REF_TO_MESSAGE_ID, string);
    }

    @Override
    @Nullable
    public XMLOffsetDateTime getMessageTimestamp() {
        return (XMLOffsetDateTime)this.getCastedValue(KEY_AS4_MESSAGE_TIMESTAMP);
    }

    public void setMessageTimestamp(@Nullable XMLOffsetDateTime xMLOffsetDateTime) {
        this.putIn(KEY_AS4_MESSAGE_TIMESTAMP, xMLOffsetDateTime);
    }

    @Override
    public boolean isPingMessage() {
        return this.getAsBoolean(KEY_IS_PING_MESSAGE, false);
    }

    public void setPingMessage(boolean bl) {
        this.putIn(KEY_IS_PING_MESSAGE, bl);
    }

    @Override
    @Nullable
    public Node getSoapBodyPayloadNode() {
        return (Node)this.getCastedValue(KEY_SOAP_BODY_PAYLOAD_NODE);
    }

    public void setSoapBodyPayloadNode(@Nullable Node node) {
        this.putIn(KEY_SOAP_BODY_PAYLOAD_NODE, node);
    }

    @Override
    public boolean isSoapHeaderElementProcessingSuccessful() {
        return this.getAsBoolean(KEY_SOAP_HEADER_ELEMENT_PROCESSING_SUCCESSFUL, false);
    }

    public void setSoapHeaderElementProcessingSuccessful(boolean bl) {
        this.putIn(KEY_SOAP_HEADER_ELEMENT_PROCESSING_SUCCESSFUL, bl);
    }

    @Override
    @Nullable
    public IAS4CryptoFactory getCryptoFactorySign() {
        return (IAS4CryptoFactory)this.getCastedValue(KEY_CRYPTO_FACTORY_SIGN);
    }

    @Nullable
    public void setCryptoFactorySign(@Nullable IAS4CryptoFactory iAS4CryptoFactory) {
        this.putIn(KEY_CRYPTO_FACTORY_SIGN, iAS4CryptoFactory);
    }

    @Override
    @Nullable
    public IAS4CryptoFactory getCryptoFactoryCrypt() {
        return (IAS4CryptoFactory)this.getCastedValue(KEY_CRYPTO_FACTORY_CRYPT);
    }

    @Nullable
    public void setCryptoFactoryCrypt(@Nullable IAS4CryptoFactory iAS4CryptoFactory) {
        this.putIn(KEY_CRYPTO_FACTORY_CRYPT, iAS4CryptoFactory);
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

