/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3Messaging;
import com.helger.phase4.ebms3header.Ebms3PullRequest;
import com.helger.phase4.ebms3header.Ebms3Receipt;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.model.mpc.IMPC;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.profile.IAS4Profile;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4ResourceHelper;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.util.Locale;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public interface IAS4MessageState {
    @Nonnull
    public OffsetDateTime getReceiptDT();

    @Nonnull
    public ESoapVersion getSoapVersion();

    @Nonnull
    public AS4ResourceHelper getResourceHelper();

    @Nonnull
    public Locale getLocale();

    @Nullable
    public Ebms3Messaging getMessaging();

    @Nullable
    default public Ebms3UserMessage getEbmsUserMessage() {
        Ebms3Messaging ebms3Messaging = this.getMessaging();
        return ebms3Messaging != null && ebms3Messaging.hasUserMessageEntries() ? ebms3Messaging.getUserMessageAtIndex(0) : null;
    }

    @Nullable
    default public Ebms3SignalMessage getEbmsSignalMessage() {
        Ebms3Messaging ebms3Messaging = this.getMessaging();
        return ebms3Messaging != null && ebms3Messaging.hasSignalMessageEntries() ? ebms3Messaging.getSignalMessageAtIndex(0) : null;
    }

    @Nullable
    default public Ebms3Error getEbmsError() {
        Ebms3SignalMessage ebms3SignalMessage = this.getEbmsSignalMessage();
        return ebms3SignalMessage != null && ebms3SignalMessage.hasErrorEntries() ? ebms3SignalMessage.getErrorAtIndex(0) : null;
    }

    @Nullable
    default public Ebms3PullRequest getEbmsPullRequest() {
        Ebms3SignalMessage ebms3SignalMessage = this.getEbmsSignalMessage();
        return ebms3SignalMessage != null ? ebms3SignalMessage.getPullRequest() : null;
    }

    @Nullable
    default public Ebms3Receipt getEbmsReceipt() {
        Ebms3SignalMessage ebms3SignalMessage = this.getEbmsSignalMessage();
        return ebms3SignalMessage != null ? ebms3SignalMessage.getReceipt() : null;
    }

    @Nullable
    public IPMode getPMode();

    @Nullable
    public Document getOriginalSoapDocument();

    default public boolean hasOriginalSoapDocument() {
        return this.getOriginalSoapDocument() != null;
    }

    @Nullable
    public ICommonsList<WSS4JAttachment> getOriginalAttachments();

    default public boolean hasOriginalAttachments() {
        ICommonsList<WSS4JAttachment> iCommonsList = this.getOriginalAttachments();
        return iCommonsList != null && iCommonsList.isNotEmpty();
    }

    @Nullable
    public Document getDecryptedSoapDocument();

    default public boolean hasDecryptedSoapDocument() {
        return this.getDecryptedSoapDocument() != null;
    }

    @Nullable
    public ICommonsList<WSS4JAttachment> getDecryptedAttachments();

    default public boolean hasDecryptedAttachments() {
        ICommonsList<WSS4JAttachment> iCommonsList = this.getDecryptedAttachments();
        return iCommonsList != null && iCommonsList.isNotEmpty();
    }

    @Nullable
    public ICommonsMap<String, EAS4CompressionMode> getCompressedAttachmentIDs();

    default public boolean hasCompressedAttachmentIDs() {
        ICommonsMap<String, EAS4CompressionMode> iCommonsMap = this.getCompressedAttachmentIDs();
        return iCommonsMap != null && iCommonsMap.isNotEmpty();
    }

    @Nullable
    default public EAS4CompressionMode getAttachmentCompressionMode(@Nullable String string) {
        ICommonsMap<String, EAS4CompressionMode> iCommonsMap = this.getCompressedAttachmentIDs();
        return iCommonsMap == null ? null : (EAS4CompressionMode)((Object)iCommonsMap.get((Object)string));
    }

    default public boolean containsCompressedAttachmentID(@Nullable String string) {
        ICommonsMap<String, EAS4CompressionMode> iCommonsMap = this.getCompressedAttachmentIDs();
        return iCommonsMap != null && iCommonsMap.containsKey((Object)string);
    }

    @Nullable
    public IMPC getMPC();

    default public boolean hasMPC() {
        return this.getMPC() != null;
    }

    public boolean isSoapBodyPayloadPresent();

    @Nullable
    public String getInitiatorID();

    default public boolean hasInitiatorID() {
        return StringHelper.hasText((String)this.getInitiatorID());
    }

    @Nullable
    public String getResponderID();

    default public boolean hasResponderID() {
        return StringHelper.hasText((String)this.getResponderID());
    }

    @Nullable
    public X509Certificate getUsedCertificate();

    default public boolean hasUsedCertificate() {
        return this.getUsedCertificate() != null;
    }

    @Nullable
    public PModeLeg getEffectivePModeLeg();

    @CheckForSigned
    public int getEffectivePModeLegNumber();

    @Nonnegative
    public int getSoapWSS4JSecurityActions();

    public boolean isSoapSignatureChecked();

    public boolean isSoapDecrypted();

    @Nullable
    public Exception getSoapWSS4JException();

    default public boolean hasSoapWSS4JException() {
        return this.getSoapWSS4JException() != null;
    }

    @Nullable
    default public String getProfileID() {
        IAS4Profile iAS4Profile = this.getAS4Profile();
        return iAS4Profile == null ? null : (String)iAS4Profile.getID();
    }

    @Nullable
    public IAS4Profile getAS4Profile();

    @Nullable
    public String getMessageID();

    @Nullable
    public String getRefToMessageID();

    @Nullable
    public XMLOffsetDateTime getMessageTimestamp();

    public boolean isPingMessage();

    @Nullable
    public Node getSoapBodyPayloadNode();

    public boolean isSoapHeaderElementProcessingSuccessful();

    @Nullable
    public IAS4CryptoFactory getCryptoFactorySign();

    @Nullable
    public IAS4CryptoFactory getCryptoFactoryCrypt();
}

