/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.soap;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.phase4.crypto.AS4SigningParams;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.crypto.IAS4DecryptParameterModifier;
import com.helger.phase4.crypto.IAS4IncomingSecurityConfiguration;
import com.helger.phase4.crypto.IAS4PModeAwareCryptoFactory;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.servlet.soap.ISOAPHeaderElementProcessor;
import com.helger.phase4.servlet.soap.SOAPHeaderElementProcessorExtractEbms3Messaging;
import com.helger.phase4.servlet.soap.SOAPHeaderElementProcessorWSS4J;
import java.security.Provider;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SOAPHeaderElementProcessorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOAPHeaderElementProcessorRegistry.class);
    private final ICommonsOrderedMap<QName, ISOAPHeaderElementProcessor> m_aMap = new CommonsLinkedHashMap();

    public void registerHeaderElementProcessor(@Nonnull QName qName, @Nonnull ISOAPHeaderElementProcessor iSOAPHeaderElementProcessor) {
        ValueEnforcer.notNull((Object)qName, (String)"QName");
        ValueEnforcer.notNull((Object)iSOAPHeaderElementProcessor, (String)"Processor");
        if (this.m_aMap.containsKey((Object)qName)) {
            throw new IllegalArgumentException("A processor for QName " + qName.toString() + " is already registered!");
        }
        this.m_aMap.put((Object)qName, (Object)iSOAPHeaderElementProcessor);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully registered SOAP header element processor for " + qName.toString());
        }
    }

    @Nullable
    public ISOAPHeaderElementProcessor getHeaderElementProcessor(@Nullable QName qName) {
        if (qName == null) {
            return null;
        }
        return (ISOAPHeaderElementProcessor)this.m_aMap.get((Object)qName);
    }

    public boolean containsHeaderElementProcessor(@Nullable QName qName) {
        return qName != null && this.m_aMap.containsKey((Object)qName);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<QName, ISOAPHeaderElementProcessor> getAllElementProcessors() {
        return this.m_aMap.getClone();
    }

    @Nonnull
    public static SOAPHeaderElementProcessorRegistry createDefault(@Nonnull IPModeResolver iPModeResolver, @Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nullable IPMode iPMode2, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration) {
        SOAPHeaderElementProcessorRegistry sOAPHeaderElementProcessorRegistry = new SOAPHeaderElementProcessorRegistry();
        Consumer<IPMode> consumer = iPMode -> {
            if (iAS4CryptoFactory instanceof IAS4PModeAwareCryptoFactory) {
                ((IAS4PModeAwareCryptoFactory)iAS4CryptoFactory).setContextPMode((IPMode)iPMode);
            }
            if (!EqualsHelper.identityEqual((Object)iAS4CryptoFactory, (Object)iAS4CryptoFactory2) && iAS4CryptoFactory2 instanceof IAS4PModeAwareCryptoFactory) {
                ((IAS4PModeAwareCryptoFactory)iAS4CryptoFactory2).setContextPMode((IPMode)iPMode);
            }
        };
        sOAPHeaderElementProcessorRegistry.registerHeaderElementProcessor(SOAPHeaderElementProcessorExtractEbms3Messaging.QNAME_MESSAGING, new SOAPHeaderElementProcessorExtractEbms3Messaging(iPModeResolver, consumer));
        AS4SigningParams aS4SigningParams = iAS4IncomingSecurityConfiguration.getSigningParams();
        Provider provider = aS4SigningParams == null ? null : aS4SigningParams.getSecurityProviderVerify();
        Supplier<IPMode> supplier = () -> iPMode2;
        IAS4DecryptParameterModifier iAS4DecryptParameterModifier = iAS4IncomingSecurityConfiguration.getDecryptParameterModifier();
        sOAPHeaderElementProcessorRegistry.registerHeaderElementProcessor(SOAPHeaderElementProcessorWSS4J.QNAME_SECURITY, new SOAPHeaderElementProcessorWSS4J(iAS4CryptoFactory, iAS4CryptoFactory2, provider, supplier, iAS4DecryptParameterModifier));
        return sOAPHeaderElementProcessorRegistry;
    }
}

