/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.soap;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.attachment.WSS4JAttachmentCallbackHandler;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.crypto.ECryptoMode;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.crypto.IAS4DecryptParameterModifier;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.error.EEbmsError;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.servlet.AS4MessageState;
import com.helger.phase4.servlet.soap.AS4KeyStoreCallbackHandler;
import com.helger.phase4.servlet.soap.ISOAPHeaderElementProcessor;
import com.helger.phase4.wss.WSSConfigManager;
import com.helger.phase4.wss.WSSSynchronizer;
import com.helger.xml.XMLHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPHeaderElementProcessorWSS4J
implements ISOAPHeaderElementProcessor {
    public static final QName QNAME_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    private static final Logger LOGGER = LoggerFactory.getLogger(SOAPHeaderElementProcessorWSS4J.class);
    private final IAS4CryptoFactory m_aCryptoFactorySign;
    private final IAS4CryptoFactory m_aCryptoFactoryCrypt;
    private final Provider m_aSecurityProviderSignVerify;
    private final Supplier<? extends IPMode> m_aFallbackPModeProvider;
    private final IAS4DecryptParameterModifier m_aDecryptParameterModifier;

    public SOAPHeaderElementProcessorWSS4J(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nullable Provider provider, @Nonnull Supplier<? extends IPMode> supplier, @Nullable IAS4DecryptParameterModifier iAS4DecryptParameterModifier) {
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactorySign");
        ValueEnforcer.notNull((Object)iAS4CryptoFactory2, (String)"CryptoFactoryCrypt");
        ValueEnforcer.notNull(supplier, (String)"FallbackPModeProvider");
        this.m_aCryptoFactorySign = iAS4CryptoFactory;
        this.m_aCryptoFactoryCrypt = iAS4CryptoFactory2;
        this.m_aSecurityProviderSignVerify = provider;
        this.m_aFallbackPModeProvider = supplier;
        this.m_aDecryptParameterModifier = iAS4DecryptParameterModifier;
    }

    @Nonnull
    private ESuccess _verifyAndDecrypt(@Nonnull Document document, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4MessageState aS4MessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2, @Nonnull Supplier<? extends WSSConfig> supplier) {
        Locale locale = aS4MessageState.getLocale();
        try {
            Object object;
            Serializable serializable;
            ICommonsList<WSS4JAttachment> iCommonsList32;
            AS4KeyStoreCallbackHandler aS4KeyStoreCallbackHandler = new AS4KeyStoreCallbackHandler(this.m_aCryptoFactoryCrypt);
            WSS4JAttachmentCallbackHandler wSS4JAttachmentCallbackHandler = new WSS4JAttachmentCallbackHandler((Iterable<? extends WSS4JAttachment>)iCommonsList, aS4MessageState.getResourceHelper());
            WSSConfig wSSConfig = supplier.get();
            if (this.m_aDecryptParameterModifier != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Before modifyWSSConfig");
                }
                this.m_aDecryptParameterModifier.modifyWSSConfig(wSSConfig);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("After modifyWSSConfig");
                }
            }
            LOGGER.info("phase4 --- verify-decrypt:start");
            RequestData requestData = new RequestData();
            requestData.setCallbackHandler((CallbackHandler)aS4KeyStoreCallbackHandler);
            if (iCommonsList.isNotEmpty()) {
                requestData.setAttachmentCallbackHandler((CallbackHandler)wSS4JAttachmentCallbackHandler);
            }
            requestData.setSigVerCrypto(this.m_aCryptoFactorySign.getCrypto(ECryptoMode.DECRYPT_VERIFY));
            requestData.setDecCrypto(this.m_aCryptoFactoryCrypt.getCrypto(ECryptoMode.DECRYPT_VERIFY));
            requestData.setWssConfig(wSSConfig);
            requestData.setSignatureProvider(this.m_aSecurityProviderSignVerify);
            if (this.m_aDecryptParameterModifier != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Before modifyRequestData");
                }
                this.m_aDecryptParameterModifier.modifyRequestData(requestData);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("After modifyRequestData");
                }
            }
            WSSecurityEngine wSSecurityEngine = new WSSecurityEngine();
            wSSecurityEngine.setWssConfig(wSSConfig);
            WSHandlerResult wSHandlerResult = wSSecurityEngine.processSecurityHeader(document, requestData);
            List list = wSHandlerResult.getResults();
            LOGGER.info("phase4 --- verify-decrypt:end");
            CommonsHashSet commonsHashSet = new CommonsHashSet();
            X509Certificate x509Certificate = null;
            int n = 0;
            for (ICommonsList<WSS4JAttachment> iCommonsList32 : list) {
                Object object2;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("WSSecurityEngineResult: " + String.valueOf(iCommonsList32));
                }
                int n2 = (object2 = (Integer)iCommonsList32.get((Object)"action")) != null ? (Integer)object2 : 0;
                n |= n2;
                serializable = (X509Certificate)iCommonsList32.get((Object)"x509-certificate");
                if (serializable == null) continue;
                commonsHashSet.add((Object)serializable);
                if (n2 != 4096 || x509Certificate != null) continue;
                x509Certificate = serializable;
            }
            aS4MessageState.setSoapWSS4JSecurityActions(n);
            if (commonsHashSet.size() > 1) {
                if (x509Certificate == null) {
                    LOGGER.warn("Found " + commonsHashSet.size() + " different certificates in message. Using the first one.");
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("All gathered certificates: " + String.valueOf(commonsHashSet));
                    }
                    object = (X509Certificate)commonsHashSet.getAtIndex(0);
                } else {
                    object = x509Certificate;
                }
            } else {
                object = commonsHashSet.size() == 1 ? (X509Certificate)commonsHashSet.getAtIndex(0) : null;
            }
            aS4MessageState.setUsedCertificate((X509Certificate)object);
            aS4MessageState.setDecryptedSoapDocument(document);
            LOGGER.info("phase4 --- attachment.storetemp:start");
            iCommonsList32 = wSS4JAttachmentCallbackHandler.getAllResponseAttachments();
            for (WSS4JAttachment wSS4JAttachment : iCommonsList32) {
                serializable = aS4MessageState.getResourceHelper().createTempFile();
                if (StreamHelper.copyByteStream().from(wSS4JAttachment.getSourceStream()).closeFrom(true).to((OutputStream)FileHelper.getBufferedOutputStream((File)serializable)).closeTo(true).build().isFailure()) {
                    LOGGER.error("Failed to write response attachment to temporary file '" + ((File)serializable).getAbsolutePath() + "'");
                }
                wSS4JAttachment.setSourceStreamProvider((IHasInputStream)HasInputStream.multiple(() -> SOAPHeaderElementProcessorWSS4J.lambda$_verifyAndDecrypt$0((File)serializable)));
            }
            aS4MessageState.setDecryptedAttachments(iCommonsList32);
            LOGGER.info("phase4 --- attachment.storetemp:end");
            return ESuccess.SUCCESS;
        }
        catch (IllegalStateException | IndexOutOfBoundsException | WSSecurityException throwable) {
            LOGGER.error("Error processing the WSSSecurity Header", throwable);
            iCommonsList2.add((Object)EEbmsError.EBMS_FAILED_DECRYPTION.errorBuilder(locale).errorDetail("Error processing the WSSSecurity Header", throwable).build());
            aS4MessageState.setSoapWSS4JException((Exception)throwable);
            return ESuccess.FAILURE;
        }
        catch (IOException iOException) {
            LOGGER.error("IO error processing the WSSSecurity Header", (Throwable)iOException);
            iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(locale).errorDetail("IO error processing the WSSSecurity Header", iOException).build());
            aS4MessageState.setSoapWSS4JException(iOException);
            return ESuccess.FAILURE;
        }
    }

    @Override
    @Nonnull
    public ESuccess processHeaderElement(@Nonnull Document document, @Nonnull Element element, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4MessageState aS4MessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) {
        aS4MessageState.setCryptoFactorySign(this.m_aCryptoFactorySign);
        aS4MessageState.setCryptoFactoryCrypt(this.m_aCryptoFactoryCrypt);
        IPMode iPMode = aS4MessageState.getPMode();
        if (iPMode == null) {
            iPMode = this.m_aFallbackPModeProvider.get();
        }
        if (iPMode == null) {
            throw new IllegalStateException("No PMode contained in AS4 state - seems like Ebms3 Messaging header is missing!");
        }
        Locale locale = aS4MessageState.getLocale();
        PModeLeg pModeLeg = iPMode.getLeg1();
        Ebms3UserMessage ebms3UserMessage = aS4MessageState.getEbmsUserMessage();
        if (ebms3UserMessage != null && StringHelper.hasText((String)ebms3UserMessage.getMessageInfo().getRefToMessageId())) {
            pModeLeg = iPMode.getLeg2();
        }
        if (pModeLeg.getSecurity() != null) {
            Object object;
            Object object2;
            Element element2;
            Element element3 = XMLHelper.getFirstChildElementOfName((Node)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
            if (element3 != null) {
                element2 = XMLHelper.getFirstChildElementOfName((Node)(element3 = XMLHelper.getFirstChildElementOfName((Node)element3, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"SignedInfo")), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"SignatureMethod");
                String string = element2 == null ? null : element2.getAttribute("Algorithm");
                object2 = ECryptoAlgorithmSign.getFromURIOrNull(string);
                if (object2 == null) {
                    String string2 = "Error processing the Security Header, your signing algorithm '" + string + "' is incorrect. Expected one of the following '" + Arrays.toString(ECryptoAlgorithmSign.values()) + "' algorithms";
                    LOGGER.error(string2);
                    iCommonsList2.add((Object)EEbmsError.EBMS_FAILED_AUTHENTICATION.errorBuilder(locale).errorDetail(string2).build());
                    return ESuccess.FAILURE;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using signature algorithm " + String.valueOf(object2));
                }
                element3 = XMLHelper.getFirstChildElementOfName((Node)element3, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Reference");
                string = (element3 = XMLHelper.getFirstChildElementOfName((Node)element3, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"DigestMethod")) == null ? null : element3.getAttribute("Algorithm");
                object = ECryptoAlgorithmSignDigest.getFromURIOrNull(string);
                if (object == null) {
                    String string3 = "Error processing the Security Header - the signing digest algorithm is incorrect. Expected one of the following algorithms: '" + Arrays.toString(ECryptoAlgorithmSignDigest.values()) + "'";
                    LOGGER.error(string3);
                    iCommonsList2.add((Object)EEbmsError.EBMS_FAILED_AUTHENTICATION.errorBuilder(locale).errorDetail(string3).build());
                    return ESuccess.FAILURE;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using signature digest algorithm " + String.valueOf(object));
                }
            }
            if (ebms3UserMessage != null) {
                boolean bl = aS4MessageState.isSoapBodyPayloadPresent();
                for (int i = 0; i < iCommonsList.size(); ++i) {
                    object2 = (String)((WSS4JAttachment)iCommonsList.get(i)).getHeaders().get("Content-ID");
                    if (StringHelper.hasNoText((String)object2)) {
                        LOGGER.error("The provided attachment ID in the 'Content-ID' header may not be empty.");
                        iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail("The provided attachment ID in the 'Content-ID' header may not be empty.").build());
                        return ESuccess.FAILURE;
                    }
                    if (!((String)object2).startsWith("<attachment=")) {
                        object = "The provided attachment ID '" + (String)object2 + "' in the 'Content-ID' header does not start with the required prefix '<attachment='";
                        LOGGER.error((String)object);
                        iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail((String)object).build());
                        return ESuccess.FAILURE;
                    }
                    if (!((String)object2).endsWith(">")) {
                        object = "The provided attachment ID '" + (String)object2 + "' in the 'Content-ID' header does not end with the required suffix '>'";
                        LOGGER.error((String)object);
                        iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail((String)object).build());
                        return ESuccess.FAILURE;
                    }
                    object2 = ((String)object2).substring("<attachment=".length(), ((String)object2).length() - ">".length());
                    object = ebms3UserMessage.getPayloadInfo().getPartInfoAtIndex((bl ? 1 : 0) + i).getHref();
                    if (((String)object).contains((CharSequence)object2)) continue;
                    String string = "The usermessage part information '" + (String)object + "' does not reference the respective attachment ID '" + (String)object2 + "'";
                    LOGGER.error(string);
                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string).build());
                    return ESuccess.FAILURE;
                }
            }
            if ((element2 = AS4Configuration.isWSS4JSynchronizedSecurity() ? (ESuccess)WSSSynchronizer.call(() -> this._verifyAndDecrypt(document, iCommonsList, aS4MessageState, iCommonsList2, WSSConfigManager::createStaticWSSConfig)) : this._verifyAndDecrypt(document, iCommonsList, aS4MessageState, iCommonsList2, WSSConfigManager.getInstance()::createWSSConfig)).isFailure()) {
                return ESuccess.FAILURE;
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PMode leg has no security defined - skipping Verification and Decryption step");
        }
        return ESuccess.SUCCESS;
    }

    private static /* synthetic */ InputStream lambda$_verifyAndDecrypt$0(File file) {
        return FileHelper.getBufferedInputStream((File)file);
    }
}

