/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.spi;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.ESuccess;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.attachment.WSS4JAttachment;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AS4MessageProcessorResult
implements ISuccessIndicator {
    private final ESuccess m_eSuccess;
    @Deprecated(forRemoval=true, since="2.3.0")
    private final String m_sErrorMsg;
    private final ICommonsList<WSS4JAttachment> m_aAttachments;
    private final String m_sAsyncResponseURL;

    protected AS4MessageProcessorResult(@Nonnull ESuccess eSuccess, @Nullable String string, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nullable String string2) {
        ValueEnforcer.notNull((Object)eSuccess, (String)"Success");
        this.m_eSuccess = eSuccess;
        this.m_sErrorMsg = string;
        this.m_aAttachments = iCommonsList;
        this.m_sAsyncResponseURL = string2;
    }

    public boolean isSuccess() {
        return this.m_eSuccess.isSuccess();
    }

    @Nullable
    @Deprecated(forRemoval=true, since="2.3.0")
    public String getErrorMessage() {
        return this.m_sErrorMsg;
    }

    @Deprecated(forRemoval=true, since="2.3.0")
    public boolean hasErrorMessage() {
        return StringHelper.hasText((String)this.m_sErrorMsg);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<WSS4JAttachment> getAllAttachments() {
        return new CommonsArrayList(this.m_aAttachments);
    }

    public boolean hasAttachments() {
        return CollectionHelper.isNotEmpty(this.m_aAttachments);
    }

    public void addAllAttachmentsTo(@Nonnull Collection<? super WSS4JAttachment> collection) {
        if (this.m_aAttachments != null) {
            collection.addAll((Collection<? super WSS4JAttachment>)this.m_aAttachments);
        }
    }

    @Nullable
    public String getAsyncResponseURL() {
        return this.m_sAsyncResponseURL;
    }

    public boolean hasAsyncResponseURL() {
        return StringHelper.hasText((String)this.m_sAsyncResponseURL);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Success", (Enum)this.m_eSuccess).appendIf("ErrorMsg", (Object)this.m_sErrorMsg, () -> ((ESuccess)this.m_eSuccess).isFailure()).appendIf("Attachments", this.m_aAttachments, () -> ((ESuccess)this.m_eSuccess).isSuccess()).appendIfNotNull("AsyncResponseURL", (Object)this.m_sAsyncResponseURL).getToString();
    }

    @Nonnull
    public static AS4MessageProcessorResult createSuccess() {
        return AS4MessageProcessorResult.createSuccessExt(null, null);
    }

    @Nonnull
    public static AS4MessageProcessorResult createSuccessExt(@Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nullable String string) {
        return new AS4MessageProcessorResult(ESuccess.SUCCESS, null, iCommonsList, string);
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="2.3.0")
    public static AS4MessageProcessorResult createFailure(@Nullable String string) {
        return new AS4MessageProcessorResult(ESuccess.FAILURE, string, (ICommonsList<WSS4JAttachment>)((ICommonsList)null), null);
    }

    @Nonnull
    public static AS4MessageProcessorResult createFailure() {
        return new AS4MessageProcessorResult(ESuccess.FAILURE, null, (ICommonsList<WSS4JAttachment>)((ICommonsList)null), null);
    }
}

