/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.soap12;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.soap12.Soap12Body;
import com.helger.phase4.soap12.Soap12Header;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Envelope", propOrder={"header", "body"})
@CodingStyleguideUnaware
public class Soap12Envelope
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="Header")
    private Soap12Header header;
    @XmlElement(name="Body", required=true)
    private Soap12Body body;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    @Nullable
    public Soap12Header getHeader() {
        return this.header;
    }

    public void setHeader(@Nullable Soap12Header soap12Header) {
        this.header = soap12Header;
    }

    @Nullable
    public Soap12Body getBody() {
        return this.body;
    }

    public void setBody(@Nullable Soap12Body soap12Body) {
        this.body = soap12Body;
    }

    @Nullable
    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Soap12Envelope soap12Envelope = (Soap12Envelope)object;
        if (!EqualsHelper.equals((Object)this.body, (Object)soap12Envelope.body)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.header, (Object)soap12Envelope.header)) {
            return false;
        }
        return EqualsHelper.equals(this.otherAttributes, soap12Envelope.otherAttributes);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.body).append((Object)this.header).append(this.otherAttributes).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("body", (Object)this.body).append("header", (Object)this.header).append("otherAttributes", this.otherAttributes).getToString();
    }

    public void cloneTo(@Nonnull Soap12Envelope soap12Envelope) {
        soap12Envelope.body = this.body == null ? null : this.body.clone();
        soap12Envelope.header = this.header == null ? null : this.header.clone();
        soap12Envelope.otherAttributes = this.otherAttributes == null ? null : new HashMap<QName, String>(this.otherAttributes);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Soap12Envelope clone() {
        Soap12Envelope soap12Envelope = new Soap12Envelope();
        this.cloneTo(soap12Envelope);
        return soap12Envelope;
    }
}

